/*
 * Decompiled with CFR 0.152.
 */
package com.product.trace;

import com.product.trace.Method;
import com.product.trace.ThreadLocalValues;
import java.util.ArrayDeque;
import java.util.Deque;

public class LoggerThreadLocal {
    static final ThreadLocal<ThreadLocalValues> threadLocal = new ThreadLocal();

    private LoggerThreadLocal() {
    }

    public static void setMethodStack(Deque<Method> methodStack) {
        ThreadLocalValues threadLocalValues = threadLocal.get();
        if (null == threadLocalValues) {
            threadLocalValues = new ThreadLocalValues();
        }
        threadLocalValues.setMethodStack(methodStack);
        threadLocal.set(threadLocalValues);
    }

    public static void setMainMethod(Method mainMethod) {
        ThreadLocalValues threadLocalValues = threadLocal.get();
        if (null == threadLocalValues) {
            threadLocalValues = new ThreadLocalValues();
        }
        threadLocalValues.setMainMethod(mainMethod);
        threadLocal.set(threadLocalValues);
    }

    public static Method getMainMethod() {
        if (threadLocal.get() == null) {
            return null;
        }
        return threadLocal.get().getMainMethod();
    }

    public static Deque<Method> getMethodStack() {
        if (threadLocal.get() == null) {
            LoggerThreadLocal.setMethodStack(new ArrayDeque<Method>());
        }
        return threadLocal.get().getMethodStack();
    }
}

