/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSON;
import com.product.model.ServiceResponse;
import com.product.model.UrlConfigBean;
import com.product.util.DumpMsg;
import com.product.util.RestBaseUtils;
import com.product.util.RestCallback;
import com.product.util.RestClientFactory;
import com.product.util.SpringBeanFactory;
import com.product.util.UniqueID;
import com.sun.jersey.api.client.Client;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.util.StringUtils;

public class RestUtils {
    public static ObjectPool<Client> poolInstance = null;

    private static synchronized void initClientPool() {
        if (poolInstance == null) {
            int poolSize = 1000;
            int maxWait = 5000;
            GenericObjectPoolConfig connectionPool = new GenericObjectPoolConfig();
            if (poolSize > 0) {
                connectionPool.setMaxTotal(poolSize);
                connectionPool.setMaxIdle(poolSize);
                connectionPool.setMinIdle(poolSize >= 2 ? poolSize / 2 : poolSize);
            }
            if (maxWait > 0) {
                connectionPool.setMaxWaitMillis((long)maxWait);
            }
            connectionPool.setMaxTotal(poolSize);
            connectionPool.setMaxIdle(poolSize);
            connectionPool.setMinIdle(0);
            connectionPool.setMaxWaitMillis((long)maxWait);
            connectionPool.setTestOnBorrow(false);
            connectionPool.setTestOnReturn(true);
            connectionPool.setTestWhileIdle(true);
            connectionPool.setMinEvictableIdleTimeMillis(-1L);
            connectionPool.setTimeBetweenEvictionRunsMillis(-1L);
            poolInstance = new GenericObjectPool<Client>((PooledObjectFactory)new RestClientFactory(), connectionPool){
                private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

                public Client borrowObject() throws Exception {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(String.format("RestUtils.CurrentDate:%1$s ", this.format.format(new Date())));
                    buffer.append(String.format("BorrowedCount:%1$d ", this.getBorrowedCount()));
                    buffer.append(String.format("CreatedCount:%1$d ", this.getCreatedCount()));
                    buffer.append(String.format("DestroyedCount:%1$d ", this.getDestroyedCount()));
                    buffer.append(String.format("MaxBorrowWaitTimeMillis:%1$d ", this.getMaxBorrowWaitTimeMillis()));
                    buffer.append(String.format("NumActive:%1$d ", this.getNumActive()));
                    buffer.append(String.format("NumIdle:%1$d ", this.getNumIdle()));
                    buffer.append(String.format("NumWaiters:%1$d ", this.getNumWaiters()));
                    buffer.append(String.format("ReturnedCount:%1$d", this.getReturnedCount()));
                    System.out.println(buffer.toString());
                    return (Client)super.borrowObject();
                }
            };
        }
    }

    public static ObjectPool<Client> getClientPool() {
        if (poolInstance == null) {
            RestUtils.initClientPool();
        }
        return poolInstance;
    }

    private static void onDataDump(String filename, String targetURL, String postValue, String resultData) {
        if (targetURL.indexOf("omp-event-webin") >= 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            String current = formatter.format(new Date());
            StringBuffer buffer = new StringBuffer();
            buffer.append("-----------------------------------\r\n");
            buffer.append(String.format("targetURL=%1$s postValue=%2$s current=%3$s\r\n", targetURL, postValue, current));
            buffer.append("data:\r\n");
            buffer.append("===================================\r\n");
            buffer.append(resultData);
            buffer.append("\r\n===================================\r\n");
            DumpMsg.dump(filename, buffer.toString(), true);
        }
    }

    public static String doPost(String remoteURL, String value) throws Exception {
        RestCallback callback = null;
        return RestUtils.doPost(remoteURL, callback, value);
    }

    public static String doPost(String remoteURL, RestCallback callback, String value) throws Exception {
        return RestUtils.doPost(remoteURL, null, null, value, callback, String.class);
    }

    public static String doPost(String remoteURL, MultivaluedMap<String, String> params, String value) throws Exception {
        return RestUtils.doPost(remoteURL, params, null, value);
    }

    public static String doPost(String remoteURL, MultivaluedMap<String, String> params, RestCallback callback, String value) throws Exception {
        return RestUtils.doPost(remoteURL, params, null, value, callback, String.class);
    }

    public static <T> T doPost(String remoteURL, MultivaluedMap<String, String> params, String value, Class<T> classzz) throws Exception {
        return RestUtils.doPost(remoteURL, params, value, null, classzz);
    }

    public static <T> T doPost(String remoteURL, MultivaluedMap<String, String> params, String value, RestCallback callback, Class<T> classzz) throws Exception {
        return RestUtils.doPost(remoteURL, params, null, value, callback, classzz);
    }

    public static String onQueryServiceURI(String remoteURL, MultivaluedMap<String, String> params) throws Exception {
        System.out.println(String.format("onQueryServiceURI(%1$s,%2$s)", remoteURL, params));
        String expressStr = RestUtils.findExpressFormStr(remoteURL);
        if (expressStr != null) {
            System.out.println("start query service env...");
            UrlConfigBean urlConfigBean = (UrlConfigBean)SpringBeanFactory.getBean("omni.serviceEnvQuery");
            if (urlConfigBean == null) {
                System.out.println("not config Bean:[omni.serviceEnvQuery]...");
                StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
                StringBuffer buffer = new StringBuffer();
                buffer.append(String.format("query:%1$s parameter:%2$s", remoteURL, params) + "\r\n");
                for (int i = 1; i < stacks.length; ++i) {
                    String trackInfo = stacks[i].toString();
                    buffer.append("\r\n" + trackInfo);
                }
                System.out.println(String.format("-------------------------------\r\n%1$s\r\n===============================\r\n", buffer.toString()));
                throw new Exception("\u672a\u914d\u7f6e\u670d\u52a1\u5de5\u5382\u5730\u5740\u7684Bean:[omni.serviceEnvQuery].");
            }
            params.add((Object)"service", (Object)expressStr);
            String result = RestUtils.doGet(urlConfigBean.getRemoteURL(), params, null, null, String.class);
            ServiceResponse response = (ServiceResponse)JSON.parseObject((String)result, ServiceResponse.class);
            if (response != null && response.getReturncode().equals("0")) {
                String targetURL = response.getData().toString();
                targetURL = remoteURL.replace(expressStr, targetURL);
                System.out.println(String.format("successful query service env[%1$s],envConfig:[%2$s]", remoteURL, targetURL));
                return targetURL;
            }
        }
        return remoteURL;
    }

    private static String findExpressFormStr(String str) {
        String matchStr = null;
        Pattern p = Pattern.compile("(\\$\\{[^>]*\\})");
        Matcher m = p.matcher(str);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group());
        }
        if (result.size() > 0) {
            matchStr = (String)result.get(0);
        }
        return matchStr;
    }

    public static <T> T doPost(String remoteURL, MultivaluedMap<String, String> params, String type, String value, RestCallback callback, Class<T> classzz) throws Exception {
        String targetURL = RestUtils.onQueryServiceURI(remoteURL, params);
        if (StringUtils.isEmpty((Object)targetURL)) {
            targetURL = remoteURL;
        }
        return RestUtils.onPost(targetURL, params, type, value, callback, classzz);
    }

    private static <T> T onPost(String remoteURL, MultivaluedMap<String, String> params, String type, String value, RestCallback callback, Class<T> classzz) throws Exception {
        long traceID = UniqueID.getUniqueID();
        int connectTimeout = -1;
        int readTimeout = -1;
        String mediaType = type;
        Class<T> responseType = classzz;
        StringBuffer buffer = new StringBuffer();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (params != null) {
            Set keySet = params.keySet();
            for (String keyname : keySet) {
                String keyvalue = (String)params.getFirst((Object)keyname);
                paramsMap.put(keyname, keyvalue);
                String keyvalue_new = "{" + keyname + "}";
                buffer.append(String.format("%1$s%2$s=%3$s", paramsMap.size() > 1 ? "&" : "", keyname, keyvalue_new));
            }
        }
        String templateURL = remoteURL.indexOf("?") > 0 ? String.format("%1$s&%2$s", remoteURL, buffer.toString()) : String.format("%1$s?%2$s", remoteURL, buffer.toString());
        return RestBaseUtils.onHttpPost(traceID, connectTimeout, readTimeout, mediaType, templateURL, paramsMap, value, responseType, callback, null);
    }

    public static String doGet(String remoteURL) throws Exception {
        return RestUtils.doGet(remoteURL, null, String.class);
    }

    public static String doGet(String remoteURL, MultivaluedMap<String, String> params) throws Exception {
        return RestUtils.doGet(remoteURL, params, String.class);
    }

    public static <T> T doGet(String remoteURL, MultivaluedMap<String, String> params, Class<T> classzz) throws Exception {
        return RestUtils.doGet(remoteURL, params, null, classzz);
    }

    public static <T> T doGet(String remoteURL, MultivaluedMap<String, String> params, RestCallback callback, Class<T> classzz) throws Exception {
        return RestUtils.doGet(remoteURL, params, null, callback, classzz);
    }

    public static <T> T doGet(String remoteURL, MultivaluedMap<String, String> params, String type, RestCallback callback, Class<T> classzz) throws Exception {
        long traceID = UniqueID.getUniqueID();
        int connectTimeout = -1;
        int readTimeout = -1;
        String mediaType = type;
        Class<T> responseType = classzz;
        StringBuffer buffer = new StringBuffer();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (params != null) {
            Set keySet = params.keySet();
            for (String keyname : keySet) {
                String keyvalue = (String)params.getFirst((Object)keyname);
                paramsMap.put(keyname, keyvalue);
                buffer.append(String.format("%1$s%2$s=%3$s", paramsMap.size() > 1 ? "&" : "", keyname, keyvalue));
            }
        }
        String templateURL = remoteURL.indexOf("?") > 0 ? String.format("%1$s&%2$s", remoteURL, buffer.toString()) : String.format("%1$s?%2$s", remoteURL, buffer.toString());
        return RestBaseUtils.onHttpGet(traceID, connectTimeout, readTimeout, mediaType, templateURL, paramsMap, responseType, callback, null);
    }
}

