/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.efuture.redis.BaseJedisConnectionFactory;
import com.product.model.ServiceSession;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class AuthorityBaseServiceImpl {
    private static Logger log = LoggerFactory.getLogger(AuthorityBaseServiceImpl.class);
    @Resource(name="jedisConnectionFactory")
    BaseJedisConnectionFactory jedisConnectionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDataRangeCategory(ServiceSession serviceSession) {
        ArrayList<String> cidList = new ArrayList<String>();
        try (Jedis jedis = this.jedisConnectionFactory.getJedis();){
            Set cidSets;
            String key = "datarangecategoryref:" + serviceSession.getDataRangeId();
            if (jedis.exists(key) && !(cidSets = jedis.smembers(key)).isEmpty()) {
                cidList.addAll(cidSets);
            }
        }
        return cidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDataRangeBusiCompany(ServiceSession serviceSession) {
        ArrayList<String> oidList = new ArrayList<String>();
        try (Jedis jedis = this.jedisConnectionFactory.getJedis();){
            Set oidSets;
            String key = "datarangebusicompanyref:" + serviceSession.getDataRangeId();
            if (jedis.exists(key) && !(oidSets = jedis.smembers(key)).isEmpty()) {
                oidList.addAll(oidSets);
            }
        }
        return oidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDataRangeShop(ServiceSession serviceSession) {
        ArrayList<String> oidList = new ArrayList<String>();
        try (Jedis jedis = this.jedisConnectionFactory.getJedis();){
            Set oidSets;
            String key = "datarangeshopref:" + serviceSession.getDataRangeId();
            if (jedis.exists(key) && !(oidSets = jedis.smembers(key)).isEmpty()) {
                oidList.addAll(oidSets);
            }
        }
        return oidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDataRangeShopCode(ServiceSession serviceSession) {
        Jedis jedis = this.jedisConnectionFactory.getJedis();
        ArrayList oidList = new ArrayList();
        ArrayList<String> shopcodeList = new ArrayList<String>();
        try {
            String key = "datarangeshopref:" + serviceSession.getDataRangeId();
            if (jedis.exists(key)) {
                Set oidSets = jedis.smembers(key);
                if (!oidSets.isEmpty()) {
                    oidList.addAll(oidSets);
                }
                if (oidList.size() > 0) {
                    Pipeline pipeline = jedis.pipelined();
                    ArrayList<Response> list = new ArrayList<Response>();
                    for (String rid : oidList) {
                        list.add(pipeline.hget("shop:" + rid, "shopCode"));
                    }
                    pipeline.sync();
                    for (Response rep : list) {
                        shopcodeList.add((String)rep.get());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e.getCause());
        }
        finally {
            jedis.close();
        }
        return shopcodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDataRangeOrg(ServiceSession serviceSession) {
        ArrayList<String> oidList = new ArrayList<String>();
        try (Jedis jedis = this.jedisConnectionFactory.getJedis();){
            Set oidSets;
            String key = "datarangeorgref:" + serviceSession.getDataRangeId();
            if (jedis.exists(key) && !(oidSets = jedis.smembers(key)).isEmpty()) {
                oidList.addAll(oidSets);
            }
        }
        return oidList;
    }
}

