/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.google.common.base.Splitter;
import com.product.annotation.NotField;
import com.product.annotation.ReferQuery;
import com.product.annotation.UniqueKey;
import com.product.component.BaseCallback;
import com.product.component.BaseServiceImpl;
import com.product.component.QueryBlankValuePreFilter;
import com.product.exception.ServiceRuntimeException;
import com.product.model.AbstractEntityBean;
import com.product.model.BeanConstant;
import com.product.model.RowMap;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.service.AnnotationService;
import com.product.service.OperationFlag;
import com.product.service.QueryConvertHandler;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.BeanUtils;
import com.product.util.FileProcessorUtils;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import com.product.util.UniqueID;
import com.shiji.core.annotation.CreateTime;
import com.shiji.core.annotation.Creator;
import com.shiji.core.annotation.CreatorName;
import com.shiji.core.annotation.Editor;
import com.shiji.core.annotation.EditorName;
import com.shiji.core.annotation.ModifyTime;
import com.shiji.core.component.CustomQueryConvert;
import com.shiji.core.service.BaseCompomentHandler;
import com.shiji.core.service.OpLogService;
import com.shiji.core.util.I18nUtil;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriTemplate;

public abstract class BaseCompomentServiceImpl<X, Y>
extends BaseServiceImpl<Y>
implements BaseCompomentHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseCompomentServiceImpl.class);
    private String collectionName;
    private String keyfieldName;
    private boolean useEntID = true;
    private boolean containEntId = true;
    private String entname = "entId";
    private boolean queryBean = false;
    private boolean insertReturnBean = false;
    private boolean isCheckDataIsModify = false;
    protected List<AnnotationService> plugins;
    protected QueryConvertHandler convertHandler;
    @Autowired
    private OpLogService opLogService;

    private boolean isQueryBean() {
        return this.queryBean;
    }

    public void setQueryforceBean(boolean flag) {
        this.queryBean = flag;
    }

    public boolean isInsertReturnBean() {
        return this.insertReturnBean;
    }

    public void setInsertReturnBean(boolean insertReturnBean) {
        this.insertReturnBean = insertReturnBean;
    }

    public boolean isCheckDataIsModify() {
        return this.isCheckDataIsModify;
    }

    public void setCheckDataIsModify(boolean checkDataIsModify) {
        this.isCheckDataIsModify = checkDataIsModify;
    }

    public List<AnnotationService> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<AnnotationService>();
        }
        return this.plugins;
    }

    public void setPlugins(List<AnnotationService> plugins) {
        this.plugins = plugins;
    }

    public void addPlugins(AnnotationService plugin) {
        this.getPlugins().add(plugin);
    }

    public boolean isUseEntID() {
        return this.useEntID;
    }

    public void setUseEntID(boolean useEntID) {
        this.useEntID = useEntID;
        this.entname = this.isUseEntID() ? "entId" : "ent_id";
    }

    public void setContainEntId(boolean containEntId) {
        this.containEntId = containEntId;
    }

    public String getEntname() {
        return this.entname;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getKeyfieldName() {
        return this.keyfieldName;
    }

    public void setKeyfieldName(String keyfieldName) {
        this.keyfieldName = keyfieldName;
    }

    public String getBusinessIdentify() {
        return "";
    }

    public QueryConvertHandler getConvertHandler() {
        return this.convertHandler;
    }

    public void setConvertHandler(QueryConvertHandler convertHandler) {
        this.convertHandler = convertHandler;
    }

    protected void onInitConvert() {
        this.setConvertHandler((QueryConvertHandler)new CustomQueryConvert());
    }

    protected String[] getReturnFields() throws IllegalArgumentException, IllegalAccessException {
        return this.getReturnFields(this.getBeanClass());
    }

    protected String[] getReturnFields(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<String> fields = new ArrayList<String>();
        this.getReturnFields(cl, fields);
        return fields.toArray(new String[fields.size()]);
    }

    protected void getReturnFields(Class<?> cl, List<String> fields) throws IllegalArgumentException, IllegalAccessException {
        Class<?> superClass;
        Field fld = AbstractEntityBean.fetchDeclaredField(cl, (String)"RETURN_FIELDS");
        String[] tmp = null;
        if (fld != null) {
            tmp = (String[])fld.get(null);
        }
        if (!StringUtils.isEmpty(tmp) && tmp.length > 0) {
            fields.addAll(Arrays.asList(tmp));
        }
        if ((superClass = cl.getSuperclass()) != null && superClass != Object.class) {
            this.getReturnFields(superClass, fields);
        }
    }

    public List<String> getUniqueKeys() {
        UniqueKey uniqueKey;
        ArrayList<String> uniqueKeys = new ArrayList<String>();
        if (this.beanClass.isAnnotationPresent(UniqueKey.class) && !StringUtils.isEmpty((Object)(uniqueKey = this.beanClass.getAnnotation(UniqueKey.class)).keys())) {
            return Arrays.asList(uniqueKey.keys());
        }
        return uniqueKeys;
    }

    public BaseCompomentServiceImpl(String collectionName, String keyfieldName) {
        this.setCollectionName(collectionName);
        this.setKeyfieldName(keyfieldName);
        this.onInitConvert();
    }

    protected abstract X getTemplate();

    protected abstract long onCount(ServiceSession var1, X var2, Query var3, String var4);

    protected abstract <T> List<T> onFind(ServiceSession var1, X var2, Query var3, Class<T> var4, String var5);

    protected abstract void onUpsert(ServiceSession var1, X var2, Query var3, Update var4, String var5);

    protected abstract int onUpsertd(ServiceSession var1, X var2, Query var3, Update var4, String var5);

    protected abstract void onInsert(ServiceSession var1, X var2, JSONObject var3, String var4);

    protected abstract int onInsertd(ServiceSession var1, X var2, JSONObject var3, String var4);

    protected abstract void onRemove(ServiceSession var1, X var2, Query var3, String var4);

    protected abstract int onRemoved(ServiceSession var1, X var2, Query var3, String var4);

    protected abstract int onUpdate(ServiceSession var1, X var2, Query var3, Update var4, String var5);

    private String getModelFlag(JSONObject dataRow) {
        if (dataRow.containsKey((Object)"_flag") && !StringUtils.isEmpty((Object)dataRow.get((Object)"_flag"))) {
            return dataRow.getString("_flag");
        }
        if (dataRow.containsKey((Object)"__flag") && !StringUtils.isEmpty((Object)dataRow.get((Object)"__flag"))) {
            return dataRow.getString("__flag");
        }
        return "#";
    }

    protected void initModel(ServiceSession session, JSONObject dataRow, OperationFlag flag) {
        List<Field> fieldList = this.getFieldList();
        for (Field field : fieldList) {
            Object value = null;
            boolean assignFlag = false;
            if (field.isAnnotationPresent(Creator.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.All)) {
                    value = StringUtils.isEmpty((Object)session.getUser_code()) ? Long.valueOf(session.getUser_id()) : session.getUser_code();
                    assignFlag = true;
                } else if (flag.equals((Object)OperationFlag.None) && "I".equalsIgnoreCase(this.getModelFlag(dataRow))) {
                    value = StringUtils.isEmpty((Object)session.getUser_code()) ? Long.valueOf(session.getUser_id()) : session.getUser_code();
                    assignFlag = true;
                }
            } else if (field.isAnnotationPresent(CreatorName.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.All)) {
                    value = StringUtils.isEmpty((Object)session.getUser_name()) ? Long.valueOf(session.getUser_id()) : session.getUser_name();
                    assignFlag = true;
                } else if (flag.equals((Object)OperationFlag.None) && "I".equalsIgnoreCase(this.getModelFlag(dataRow))) {
                    value = StringUtils.isEmpty((Object)session.getUser_name()) ? Long.valueOf(session.getUser_id()) : session.getUser_name();
                    assignFlag = true;
                }
            } else if (field.isAnnotationPresent(CreateTime.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.All)) {
                    if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                        value = System.currentTimeMillis();
                        assignFlag = true;
                    } else {
                        value = new Date();
                        assignFlag = true;
                    }
                } else if (flag.equals((Object)OperationFlag.None) && "I".equalsIgnoreCase(this.getModelFlag(dataRow))) {
                    if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                        value = System.currentTimeMillis();
                        assignFlag = true;
                    } else {
                        value = new Date();
                        assignFlag = true;
                    }
                }
            } else if (field.isAnnotationPresent(Editor.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.Update) || flag.equals((Object)OperationFlag.All)) {
                    value = StringUtils.isEmpty((Object)session.getUser_code()) ? Long.valueOf(session.getUser_id()) : session.getUser_code();
                    assignFlag = true;
                } else if (flag.equals((Object)OperationFlag.None) && ("U".equalsIgnoreCase(this.getModelFlag(dataRow)) || "I".equalsIgnoreCase(this.getModelFlag(dataRow)))) {
                    value = StringUtils.isEmpty((Object)session.getUser_code()) ? Long.valueOf(session.getUser_id()) : session.getUser_code();
                    assignFlag = true;
                }
            } else if (field.isAnnotationPresent(EditorName.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.Update) || flag.equals((Object)OperationFlag.All)) {
                    value = StringUtils.isEmpty((Object)session.getUser_name()) ? Long.valueOf(session.getUser_id()) : session.getUser_name();
                    assignFlag = true;
                } else if (flag.equals((Object)OperationFlag.None) && ("U".equalsIgnoreCase(this.getModelFlag(dataRow)) || "I".equalsIgnoreCase(this.getModelFlag(dataRow)))) {
                    value = StringUtils.isEmpty((Object)session.getUser_name()) ? Long.valueOf(session.getUser_id()) : session.getUser_name();
                    assignFlag = true;
                }
            } else if (field.isAnnotationPresent(ModifyTime.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.Update) || flag.equals((Object)OperationFlag.All)) {
                    if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                        value = System.currentTimeMillis();
                        assignFlag = true;
                    } else {
                        value = new Date();
                        assignFlag = true;
                    }
                } else if (flag.equals((Object)OperationFlag.None) && ("U".equalsIgnoreCase(this.getModelFlag(dataRow)) || "I".equalsIgnoreCase(this.getModelFlag(dataRow)))) {
                    if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                        value = System.currentTimeMillis();
                        assignFlag = true;
                    } else {
                        value = new Date();
                        assignFlag = true;
                    }
                }
            }
            if (!assignFlag) continue;
            dataRow.put(field.getName(), value);
        }
    }

    protected void onBeforeQuery(ServiceSession session, Criteria criteria) {
    }

    protected void onBeforeQuery(ServiceSession session, Query query, JSONObject paramsObject) {
    }

    protected void onAfterQuery(List<RowMap> dataList, String keyfieldName) {
        for (RowMap dataMap : dataList) {
            this.onRowAfterQuery(dataMap, keyfieldName);
        }
    }

    protected void onDifferentWarning(ServiceSession session, JSONObject params) throws Exception {
        if (params != null && params.containsKey((Object)this.getEntname())) {
            long paramsEntID = params.getLongValue(this.getEntname());
            if (session.getEnt_id() != paramsEntID) {
                throw new Exception(I18nUtil.getMessage((String)"90001", (Object[])new Object[]{paramsEntID, session.getEnt_id()}, (String)session.getLocale()));
            }
        }
    }

    protected void onQueryForEntID(ServiceSession session, JSONObject params) throws Exception {
        this.onDifferentWarning(session, params);
        params.put(this.entname, (Object)session.getEnt_id());
    }

    protected void onQueryForEntID(ServiceSession session, JSONObject params, String entCol) throws Exception {
        this.onDifferentWarning(session, params);
        params.put(entCol, (Object)session.getEnt_id());
    }

    protected void onRowAfterQuery(RowMap dataMap, String keyfieldName) {
        if (dataMap.containsKey((Object)keyfieldName)) {
            dataMap.put((Object)keyfieldName, (Object)TypeUtils.castToString((Object)dataMap.get((Object)keyfieldName)));
        }
    }

    protected Criteria onParseParamsOne(Criteria criteria, String keyName, Object keyValue) {
        if (keyValue instanceof Map) {
            Map paramsMap = (Map)keyValue;
            Set keySet = paramsMap.keySet();
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            for (String subKey : keySet) {
                Criteria criteriaMap;
                Object subValue = paramsMap.get(subKey);
                if ("$gt".equalsIgnoreCase(subKey) || ">".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).gt(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$gte".equalsIgnoreCase(subKey) || ">=".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).gte(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$lt".equalsIgnoreCase(subKey) || "<".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).lt(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$lte".equalsIgnoreCase(subKey) || "<=".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).lte(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$ne".equalsIgnoreCase(subKey) || "!=".equalsIgnoreCase(subKey) || "<>".equalsIgnoreCase(subKey)) {
                    criteriaMap = null;
                    criteriaMap = "$null".equalsIgnoreCase(subValue.toString()) ? Criteria.where((String)keyName).ne(subValue) : Criteria.where((String)keyName).ne(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$like".equalsIgnoreCase(subKey) || "like".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).regex(BaseCompomentServiceImpl.escapeExprSpecialWord(subValue.toString()));
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if (!"$in".equalsIgnoreCase(subKey) && !"in".equalsIgnoreCase(subKey)) continue;
                Object[] oos = null;
                oos = subValue instanceof JSONArray ? ((JSONArray)subValue).toArray() : (subValue instanceof List ? ((List)subValue).toArray() : subValue.toString().split(","));
                Criteria criteriaMap2 = Criteria.where((String)keyName).in(oos);
                criteriaList.add(criteriaMap2);
            }
            if (criteria == null) {
                if (criteriaList.size() > 0) {
                    c = new Criteria[criteriaList.size()];
                    criteria = new Criteria().andOperator(criteriaList.toArray(c));
                }
            } else if (criteriaList.size() > 0) {
                c = new Criteria[criteriaList.size()];
                criteria.andOperator(criteriaList.toArray(c));
            }
        } else if (keyValue instanceof JSONArray) {
            JSONArray json = (JSONArray)keyValue;
            Object[] oos = new Object[json.size()];
            for (int i = 0; i < json.size(); ++i) {
                oos[i] = json.get(i);
            }
            if (criteria == null) {
                criteria = Criteria.where((String)keyName).in(oos);
            } else {
                criteria.and(keyName).in(oos);
            }
        } else if (criteria == null) {
            Object[] oos;
            criteria = keyValue instanceof String ? ((oos = ((String)keyValue).split(",")).length > 1 ? Criteria.where((String)keyName).in(oos) : Criteria.where((String)keyName).is(keyValue)) : Criteria.where((String)keyName).is(keyValue);
        } else if (keyValue instanceof String) {
            Object[] oos = ((String)keyValue).split(",");
            if (oos.length > 1) {
                criteria.and(keyName).in(oos);
            } else {
                criteria.and(keyName).is(keyValue);
            }
        } else {
            criteria.and(keyName).is(keyValue);
        }
        return criteria;
    }

    public static String escapeExprSpecialWord(String keyword) {
        if (!StringUtils.isEmpty((Object)keyword)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject, Boolean trimBlankValueFlag) {
        if (trimBlankValueFlag.booleanValue()) {
            paramsObject = QueryBlankValuePreFilter.getInstance().trimBlankValue(paramsObject);
        }
        return this.onQueryCallback(session, paramsObject, null);
    }

    public ServiceResponse onQueryWithHint(ServiceSession session, JSONObject paramsObject, Boolean BeanFalg) {
        if (BeanFalg.booleanValue()) {
            Field[] fields = this.beanClass.getDeclaredFields();
            StringBuffer fieldValue = new StringBuffer();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field.isAnnotationPresent(ReferQuery.class) || field.isAnnotationPresent(NotField.class)) continue;
                if (i == fields.length - 1) {
                    fieldValue.append(fields[i].getName());
                    continue;
                }
                fieldValue.append(fields[i].getName()).append(",");
            }
            paramsObject.put("fields", (Object)fieldValue);
            if (paramsObject.containsKey((Object)"order_field")) {
                this.removeOrderFld(paramsObject, fields);
            }
        }
        return this.onQuery(true, session, paramsObject);
    }

    private List<String> onSplit(String source) {
        ArrayList<String> responseList = new ArrayList<String>();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)source)) {
            Iterator iterator = Splitter.on((String)",").split((CharSequence)source).iterator();
            while (iterator.hasNext()) {
                responseList.add((String)iterator.next());
            }
        }
        return responseList;
    }

    private void removeOrderFld(JSONObject paramsObject, Field[] fields) {
        if (paramsObject.containsKey((Object)"order_field") && !StringUtils.isEmpty((Object)"order_field")) {
            int i;
            List<String> fld_list = this.onSplit(paramsObject.getString("order_field"));
            List<Object> sort_list = new ArrayList();
            if (paramsObject.containsKey((Object)"order_direction") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"order_direction"))) {
                sort_list = this.onSplit(paramsObject.getString("order_direction"));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            int fld_size = fld_list.size();
            int sort_size = sort_list.size();
            for (i = 0; i < fld_size; ++i) {
                if (StringUtils.isEmpty((Object)fld_list.get(i))) continue;
                if (sort_size > i && !StringUtils.isEmpty((Object)fld_list.get(i).trim())) {
                    String sortFlag = StringUtils.isEmpty((Object)((String)sort_list.get(i)).trim()) ? "ASC" : ((String)sort_list.get(i)).trim();
                    map.put(fld_list.get(i), sortFlag);
                    continue;
                }
                map.put(fld_list.get(i), "asc");
            }
            for (i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.isAnnotationPresent(ReferQuery.class) && !field.isAnnotationPresent(NotField.class) || !map.containsKey(field.getName())) continue;
                map.remove(field.getName());
            }
            if (map.isEmpty()) {
                paramsObject.remove((Object)"order_field");
                paramsObject.remove((Object)"order_direction");
            } else {
                StringBuffer orderfield = new StringBuffer();
                StringBuffer orderSort = new StringBuffer();
                for (Map.Entry entry : map.entrySet()) {
                    String mapKey = (String)entry.getKey();
                    String mapValue = (String)entry.getValue();
                    System.out.println(mapKey + ":" + mapValue);
                    orderfield.append(mapKey).append(",");
                    orderSort.append(mapValue).append(",");
                }
                orderfield.deleteCharAt(orderfield.length() - 1);
                orderSort.deleteCharAt(orderSort.length() - 1);
                paramsObject.put("order_field", (Object)orderfield.toString());
                paramsObject.put("order_direction", (Object)orderSort.toString());
            }
        }
    }

    public ServiceResponse onQuery(JSONObject paramsObject) {
        return this.onQuery(SpringContext.getSession(), paramsObject, true);
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject) {
        return this.onQuery(session, paramsObject, true);
    }

    public ServiceResponse onQuery(boolean searchPluginFlag, ServiceSession session, JSONObject paramsObject) {
        paramsObject.put("searchPluginFlag", (Object)searchPluginFlag);
        return this.onQuery(session, paramsObject, true);
    }

    public ServiceResponse onQueryCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        Object keyValue;
        String keyfieldName;
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        X template = this.getTemplate();
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put("fields", 1);
        keyMap.put("order_field", 1);
        keyMap.put("order_direction", 1);
        keyMap.put("page_no", 1);
        keyMap.put("page_size", 1);
        String entCol = BeanUtils.getBeanEntCol((Class)this.beanClass);
        if (!StringUtils.isEmpty((Object)entCol) && (paramsObject.containsKey((Object)entCol) || this.containEntId)) {
            try {
                this.onQueryForEntID(session, paramsObject, entCol);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)e.getMessage());
            }
        }
        if (paramsObject.containsKey((Object)(keyfieldName = this.getKeyfieldName())) && (keyValue = paramsObject.get((Object)keyfieldName)) != null) {
            if (keyValue instanceof Long) {
                paramsObject.put(keyfieldName, (Object)TypeUtils.castToLong((Object)paramsObject.get((Object)keyfieldName)));
            } else if (keyValue instanceof Map) {
                keyMap.remove(keyfieldName);
            }
        }
        Query query = new Query();
        this.onBeforeQuery(session, query, paramsObject);
        List criteriaList = this.convertHandler.onConvert(paramsObject, keyMap, this.getBeanClass());
        query = this.convertHandler.baseCreateQuery(query, criteriaList);
        String collectionName = this.getCollectionName();
        long rowCount = this.onCount(session, template, query, collectionName);
        JSONObject response = new JSONObject();
        response.put("total_results", (Object)rowCount);
        rowCount = 1L;
        if (rowCount > 0L) {
            int i;
            Sort order = null;
            Integer pageno = BeanConstant.QueryPage.DEFAULT_PAGENO;
            Integer pageSize = BeanConstant.QueryPage.DEFAULT_PAGESIZE;
            if (paramsObject.containsKey((Object)"page_no")) {
                pageno = paramsObject.getInteger("page_no") - 1;
            }
            if (paramsObject.containsKey((Object)"page_size")) {
                pageSize = paramsObject.getInteger("page_size");
            }
            if (pageno < 0) {
                pageno = 0;
            }
            if (paramsObject.containsKey((Object)"order_field") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"order_field"))) {
                if (paramsObject.containsKey((Object)"order_direction") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"order_direction"))) {
                    String[] dirs = paramsObject.getString("order_direction").split(",");
                    String[] flds = paramsObject.getString("order_field").split(",");
                    ArrayList<Sort.Order> lst = new ArrayList<Sort.Order>();
                    for (i = 0; i < flds.length; ++i) {
                        if (i < dirs.length) {
                            lst.add(new Sort.Order(Sort.Direction.fromString((String)dirs[i]), flds[i].trim()));
                            continue;
                        }
                        lst.add(Sort.Order.by((String)flds[i].trim()));
                    }
                    order = Sort.by(lst);
                } else {
                    order = Sort.by((String[])paramsObject.getString("order_field").split(","));
                }
            }
            org.springframework.data.mongodb.core.query.Field flds = query.fields();
            if (paramsObject.containsKey((Object)"fields") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"fields"))) {
                String[] paramFields = paramsObject.getString("fields").split(",");
                HashSet set = new HashSet();
                paramFields = this.checkFields(paramFields, set);
                if (set.size() > 0) {
                    return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10014", (Object[])new Object[]{"fields", set.toArray().toString()});
                }
                for (i = 0; i < paramFields.length; ++i) {
                    if (StringUtils.isEmpty((Object)paramFields[i].trim())) continue;
                    flds.include(paramFields[i].trim());
                }
            } else {
                flds.include("*");
            }
            query.with((Pageable)PageRequest.of((int)pageno, (int)pageSize));
            if (order != null) {
                query.with(order);
            }
            List<RowMap> dataList = this.onFind(session, template, query, RowMap.class, collectionName);
            if (!paramsObject.containsKey((Object)"searchPluginFlag")) {
                List<AnnotationService> tagPlugins = this.getPlugins();
                for (AnnotationService plugin : tagPlugins) {
                    try {
                        plugin.onAction(session, dataList, OperationFlag.afterQuery, this.getBeanClass());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.onAfterQuery(dataList, keyfieldName);
            response.put(collectionName, dataList);
            if (this.isQueryBean()) {
                List beanList = TypeUtils.getList((JSONObject)response, (String)collectionName, (Class)this.getBeanClass());
                response.put(collectionName, (Object)beanList);
            }
        } else {
            response.put(collectionName, new ArrayList());
        }
        return ServiceResponse.buildSuccess((Object)response);
    }

    protected void onBeforeUpdate(ServiceSession session, Criteria criteria, Update update) {
    }

    protected int doUpdate(ServiceSession session, X template, Query query, Update update, BaseCallback callback) {
        String collectionName = this.getCollectionName();
        return this.onUpsertd(session, template, query, update, collectionName);
    }

    protected void onRowUpdateForEntID(ServiceSession session, JSONObject params) throws Exception {
        this.onDifferentWarning(session, params);
        params.put(this.getEntname(), (Object)session.getEnt_id());
    }

    protected void onAfterRowUpdate(X template, Query query, JSONObject params) {
    }

    public ServiceResponse onUpdate(JSONObject paramsObject) {
        return this.onUpdate(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse onUpdate(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse response = this.onUpdateCallback(session, paramsObject, null);
        if (!"0".equals(response.getReturncode())) {
            throw new ServiceRuntimeException(response.getData().toString());
        }
        return response;
    }

    public ServiceResponse onUpdateCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        X template = this.getTemplate();
        String collectionName = this.getCollectionName();
        String keyfieldName = this.getKeyfieldName();
        if (paramsObject.containsKey((Object)collectionName)) {
            JSONArray response = new JSONArray();
            Object dataObject = paramsObject.get((Object)collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(collectionName);
                for (int i = 0; i < paramsArray.size(); ++i) {
                    Object keyName2;
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (callback != null) {
                        callback.onBeforeAction(params);
                    }
                    if (params.containsKey((Object)this.getEntname()) && this.containEntId) {
                        try {
                            this.onRowUpdateForEntID(session, params);
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)e.getMessage());
                        }
                    }
                    if (params.containsKey((Object)keyfieldName)) {
                        if (StringUtils.isEmpty((Object)params.get((Object)keyfieldName))) {
                            params.put(keyfieldName, (Object)UniqueID.getUniqueID(true));
                        } else {
                            params.put(keyfieldName, (Object)TypeUtils.castToLong((Object)params.get((Object)keyfieldName)));
                        }
                    } else {
                        return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10017", (Object[])new Object[]{keyfieldName});
                    }
                    HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
                    keyMap.put(keyfieldName, 1);
                    Criteria criteria = Criteria.where((String)keyfieldName).is(params.get((Object)keyfieldName));
                    if (params.containsKey((Object)this.getEntname()) && !this.getEntname().equals(keyfieldName)) {
                        criteria.and(this.getEntname()).is(params.get((Object)this.getEntname()));
                        keyMap.put(this.getEntname(), 1);
                    }
                    Object oldModel = this.dataQueryFirst(session, new Query((CriteriaDefinition)criteria));
                    this.checkDataIsModify(oldModel, params);
                    this.initModel(session, params, OperationFlag.Update);
                    Update update = new Update();
                    Set keySet = params.keySet();
                    for (Object keyName2 : keySet) {
                        if (keyMap.containsKey(keyName2) || AbstractEntityBean.isTransientField((Class)this.getBeanClass(), (String)keyName2)) continue;
                        this.onAssistMap(update, (Map<String, Object>)params, (String)keyName2, true, false);
                    }
                    List<AnnotationService> tagPlugins = this.getPlugins();
                    keyName2 = tagPlugins.iterator();
                    while (keyName2.hasNext()) {
                        AnnotationService plugin = (AnnotationService)keyName2.next();
                        try {
                            plugin.onAction(session, (Object)params, OperationFlag.Update, this.getBeanClass());
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10018", (Object[])new Object[]{e.getMessage()});
                        }
                    }
                    this.onBeforeUpdate(session, criteria, update);
                    Query query = new Query((CriteriaDefinition)criteria);
                    System.out.println(query.toString());
                    int n = this.doUpdate(session, template, query, update, callback);
                    if (n > 0) {
                        response.add(params.get((Object)keyfieldName));
                        this.opLogService.logger(session, (JSONObject)JSON.toJSON((Object)oldModel), params, this.getBeanClass(), ((FMybatisTemplate)template).getSqlSessionTemplate().getConfiguration().getEnvironment().getDataSource(), OperationFlag.Update);
                    } else {
                        response.add((Object)0);
                    }
                    this.onAfterRowUpdate(template, query, params);
                }
            }
            return ServiceResponse.buildSuccess((Object)response);
        }
        JSONObject response = new JSONObject();
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put(keyfieldName, 1);
        if (callback != null) {
            callback.onBeforeAction(paramsObject);
        }
        if (paramsObject.containsKey((Object)this.getEntname()) && this.containEntId) {
            try {
                this.onRowUpdateForEntID(session, paramsObject);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)e.getMessage());
            }
            keyMap.put(this.getEntname(), 1);
        }
        if (paramsObject.containsKey((Object)keyfieldName)) {
            if (StringUtils.isEmpty((Object)paramsObject.get((Object)keyfieldName))) {
                paramsObject.put(keyfieldName, (Object)UniqueID.getUniqueID(true));
            } else {
                paramsObject.put(keyfieldName, (Object)TypeUtils.castToLong((Object)paramsObject.get((Object)keyfieldName)));
            }
        } else {
            return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10017", (Object[])new Object[]{keyfieldName});
        }
        Criteria criteria = Criteria.where((String)keyfieldName).is(paramsObject.get((Object)keyfieldName));
        if (paramsObject.containsKey((Object)this.getEntname()) && !this.getEntname().equals(keyfieldName)) {
            criteria.and(this.getEntname()).is(paramsObject.get((Object)this.getEntname()));
            keyMap.put(this.getEntname(), 1);
        }
        List<AnnotationService> tagPlugins = this.getPlugins();
        for (AnnotationService plugin : tagPlugins) {
            try {
                plugin.onAction(session, (Object)paramsObject, OperationFlag.Update, this.getBeanClass());
            }
            catch (Exception e) {
                return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10018", (Object[])new Object[]{e.getMessage()});
            }
        }
        Object oldModel = this.dataQueryFirst(session, new Query((CriteriaDefinition)criteria));
        this.checkDataIsModify(oldModel, paramsObject);
        this.initModel(session, paramsObject, OperationFlag.Update);
        Update update = new Update();
        Set keySet = paramsObject.keySet();
        for (String keyName : keySet) {
            if (keyMap.containsKey(keyName) || AbstractEntityBean.isTransientField((Class)this.getBeanClass(), (String)keyName)) continue;
            this.onAssistMap(update, (Map<String, Object>)paramsObject, keyName, true, false);
        }
        this.onBeforeUpdate(session, criteria, update);
        Query query = new Query((CriteriaDefinition)criteria);
        int n = this.doUpdate(session, template, query, update, callback);
        if (n >= 0) {
            response.put(keyfieldName, paramsObject.get((Object)keyfieldName));
            if (n > 0) {
                this.opLogService.logger(session, (JSONObject)JSON.toJSON((Object)oldModel), paramsObject, this.getBeanClass(), ((FMybatisTemplate)template).getSqlSessionTemplate().getConfiguration().getEnvironment().getDataSource(), OperationFlag.Update);
            }
        }
        this.onAfterRowUpdate(template, query, paramsObject);
        return ServiceResponse.buildSuccess((Object)response);
    }

    protected void onBeforeInsert(ServiceSession session, JSONObject dataRow) {
    }

    protected void doInsert(ServiceSession session, X template, JSONObject dataRow, BaseCallback callback) {
        String collectionName = this.getCollectionName();
        this.onInsert(session, template, dataRow, collectionName);
    }

    protected int doInsertd(ServiceSession session, X template, JSONObject dataRow, BaseCallback callback) {
        String collectionName = this.getCollectionName();
        return this.onInsertd(session, template, dataRow, collectionName);
    }

    protected void onAfterRowInsert(X template, JSONObject dataRow) {
    }

    public ServiceResponse onInsert(JSONObject paramsObject) {
        return this.onInsert(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse onInsert(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse response = this.onInsertCallback(session, paramsObject, null);
        if (!"0".equals(response.getReturncode())) {
            throw new ServiceRuntimeException(response.getData().toString());
        }
        return response;
    }

    public ServiceResponse onInsertCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        X template = this.getTemplate();
        String collectionName = this.getCollectionName();
        String keyfieldName = this.getKeyfieldName();
        long id = 0L;
        JSONArray idArray = new JSONArray();
        if (paramsObject.containsKey((Object)collectionName)) {
            Object dataObject = paramsObject.get((Object)collectionName);
            ArrayList<Object> beanList = new ArrayList<Object>();
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(collectionName);
                for (int i = 0; i < paramsArray.size(); ++i) {
                    Object keyName2;
                    JSONObject params = paramsArray.getJSONObject(i);
                    if ((!params.containsKey((Object)this.getEntname()) || params.containsKey((Object)this.getEntname()) && StringUtils.isEmpty((Object)params.get((Object)this.getEntname()))) && this.containEntId) {
                        String entCol = this.getBeanEntCol();
                        params.put(entCol, (Object)session.getEnt_id());
                    }
                    if (StringUtils.isEmpty((Object)params.get((Object)keyfieldName))) {
                        id = UniqueID.getUniqueID(true);
                        params.put(keyfieldName, (Object)id);
                    } else {
                        id = TypeUtils.castToLong((Object)params.get((Object)keyfieldName));
                        params.put(keyfieldName, (Object)id);
                    }
                    JSONObject dataRow = new JSONObject();
                    Set keySet = params.keySet();
                    for (Object keyName2 : keySet) {
                        if (AbstractEntityBean.isTransientField((Class)this.getBeanClass(), (String)keyName2)) continue;
                        this.onAssistMap(dataRow, (Map<String, Object>)params, (String)keyName2, (String)keyName2);
                    }
                    List<AnnotationService> tagPlugins = this.getPlugins();
                    keyName2 = tagPlugins.iterator();
                    while (keyName2.hasNext()) {
                        AnnotationService plugin = (AnnotationService)keyName2.next();
                        try {
                            plugin.onAction(session, (Object)dataRow, OperationFlag.Insert, this.getBeanClass());
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10019", (Object[])new Object[]{e.getMessage()});
                        }
                    }
                    this.initModel(session, dataRow, OperationFlag.Insert);
                    if (callback != null) {
                        callback.onBeforeAction(dataRow);
                    }
                    this.onBeforeInsert(session, dataRow);
                    int n = this.doInsertd(session, template, dataRow, callback);
                    if (n > 0) {
                        idArray.add((Object)id);
                    } else {
                        idArray.add((Object)"0");
                    }
                    this.opLogService.logger(session, null, dataRow, this.getBeanClass(), ((FMybatisTemplate)template).getSqlSessionTemplate().getConfiguration().getEnvironment().getDataSource(), OperationFlag.Insert);
                    this.onAfterRowInsert(template, dataRow);
                    if (callback != null) {
                        callback.onAfterAction(dataRow);
                    }
                    if (!this.isInsertReturnBean()) continue;
                    beanList.add(TypeUtils.castToJavaBean((Object)dataRow, (Class)this.getBeanClass()));
                }
            }
            if (this.isInsertReturnBean()) {
                return ServiceResponse.buildSuccess(beanList);
            }
            return ServiceResponse.buildSuccess((Object)idArray);
        }
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put(keyfieldName, 1);
        if ((!paramsObject.containsKey((Object)this.getEntname()) || paramsObject.containsKey((Object)this.getEntname()) && StringUtils.isEmpty((Object)paramsObject.get((Object)this.getEntname()))) && this.containEntId) {
            String entCol = this.getBeanEntCol();
            paramsObject.put(entCol, (Object)session.getEnt_id());
        }
        if (StringUtils.isEmpty((Object)paramsObject.get((Object)keyfieldName))) {
            id = UniqueID.getUniqueID(true);
            paramsObject.put(keyfieldName, (Object)id);
        } else {
            id = TypeUtils.castToLong((Object)paramsObject.get((Object)keyfieldName));
            paramsObject.put(keyfieldName, (Object)id);
        }
        JSONObject dataRow = new JSONObject();
        Set keySet = paramsObject.keySet();
        for (Object keyName : keySet) {
            if (AbstractEntityBean.isTransientField((Class)this.getBeanClass(), (String)keyName)) continue;
            try {
                this.onAssistMap(dataRow, (Map<String, Object>)paramsObject, (String)keyName, (String)keyName);
            }
            catch (NullPointerException npe) {
                System.out.println(String.format("\u6267\u884c\u5217[%1$s]\u7c7b\u578b\u8f6c\u6362\u7a7a\u5f02\u5e38!", keyName));
                throw npe;
            }
        }
        List<AnnotationService> tagPlugins = this.getPlugins();
        for (AnnotationService plugin : tagPlugins) {
            try {
                plugin.onAction(session, (Object)dataRow, OperationFlag.Insert, this.getBeanClass());
            }
            catch (Exception e) {
                return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10019", (Object[])new Object[]{e.getMessage()});
            }
        }
        this.initModel(session, dataRow, OperationFlag.Insert);
        if (callback != null) {
            callback.onBeforeAction(dataRow);
        }
        this.onBeforeInsert(session, dataRow);
        int n = this.doInsertd(session, template, dataRow, callback);
        if (n <= 0) {
            return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10011", (Object[])new Object[0]);
        }
        this.opLogService.logger(session, null, dataRow, this.getBeanClass(), ((FMybatisTemplate)template).getSqlSessionTemplate().getConfiguration().getEnvironment().getDataSource(), OperationFlag.Insert);
        this.onAfterRowInsert(template, dataRow);
        JSONObject response = new JSONObject();
        response.put(keyfieldName, (Object)id);
        try {
            String[] rtnfields = this.getReturnFields();
            if (!StringUtils.isEmpty((Object)rtnfields)) {
                for (String rtnfield : rtnfields) {
                    if (!dataRow.containsKey((Object)rtnfield) || StringUtils.isEmpty((Object)dataRow.get((Object)rtnfield))) continue;
                    Object obj = dataRow.get((Object)rtnfield);
                    response.put(rtnfield, obj);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isInsertReturnBean()) {
            return ServiceResponse.buildSuccess((Object)TypeUtils.castToJavaBean((Object)dataRow, (Class)this.getBeanClass()));
        }
        return ServiceResponse.buildSuccess((Object)response);
    }

    public JSONArray insertBatch(ServiceSession session, JSONArray jsonArray, Boolean isBatch) throws Exception {
        if (isBatch.booleanValue()) {
            return null;
        }
        return this.onInsertBatch(session, jsonArray);
    }

    protected void onBeforeDelete(ServiceSession session, Criteria criteria) {
    }

    protected int doDelete(ServiceSession session, X template, Query query, BaseCallback callback) {
        String collectionName = this.getCollectionName();
        return this.onRemoved(session, template, query, collectionName);
    }

    protected void onDeleteForEntID(ServiceSession session, JSONObject params) throws Exception {
        this.onDifferentWarning(session, params);
        params.put(this.getEntname(), (Object)session.getEnt_id());
    }

    public ServiceResponse onDelete(JSONObject paramsObject) {
        return this.onDelete(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse onDelete(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse response = this.onDeleteCallback(session, paramsObject, null);
        if (!"0".equals(response.getReturncode())) {
            throw new ServiceRuntimeException(response.getData().toString());
        }
        return response;
    }

    public ServiceResponse onDeleteCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        X template = this.getTemplate();
        String collectionName = this.getCollectionName();
        String keyfieldName = this.getKeyfieldName();
        if (paramsObject.containsKey((Object)collectionName)) {
            JSONArray response = new JSONArray();
            Object dataObject = paramsObject.get((Object)collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(collectionName);
                for (int i = 0; i < paramsArray.size(); ++i) {
                    Object keyName2;
                    HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
                    keyMap.put("fields", 1);
                    keyMap.put("order_field", 1);
                    keyMap.put("order_direction", 1);
                    keyMap.put("page_no", 1);
                    keyMap.put("page_size", 1);
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (callback != null) {
                        callback.onBeforeAction(params);
                    }
                    if (this.containEntId) {
                        try {
                            this.onDeleteForEntID(session, paramsObject);
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)e.getMessage());
                        }
                    }
                    if (params.containsKey((Object)keyfieldName)) {
                        params.put(keyfieldName, (Object)TypeUtils.castToLong((Object)params.get((Object)keyfieldName)));
                    }
                    Set keySet = params.keySet();
                    Criteria criteria = null;
                    for (Object keyName2 : keySet) {
                        if (keyMap.containsKey(keyName2) || AbstractEntityBean.isTransientField((Class)this.getBeanClass(), (String)keyName2)) continue;
                        criteria = this.onParseParamsOne(criteria, (String)keyName2, params.get(keyName2));
                    }
                    if (criteria == null) continue;
                    List<AnnotationService> tagPlugins = this.getPlugins();
                    keyName2 = tagPlugins.iterator();
                    while (keyName2.hasNext()) {
                        AnnotationService plugin = (AnnotationService)keyName2.next();
                        try {
                            plugin.onAction(session, (Object)params, OperationFlag.Delete, this.getBeanClass());
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10020", (Object[])new Object[]{e.getMessage()});
                        }
                    }
                    this.onBeforeDelete(session, criteria);
                    Query query = new Query(criteria);
                    List oldModelList = this.dataQuery(query);
                    int n = this.doDelete(session, template, query, callback);
                    if (n > 0) {
                        response.add(params.get((Object)keyfieldName));
                        for (Object oldModel : oldModelList) {
                            this.opLogService.logger(session, (JSONObject)JSON.toJSON(oldModel), null, this.getBeanClass(), ((FMybatisTemplate)template).getSqlSessionTemplate().getConfiguration().getEnvironment().getDataSource(), OperationFlag.Delete);
                        }
                        continue;
                    }
                    response.add((Object)0);
                }
            }
            return ServiceResponse.buildSuccess((Object)response);
        }
        JSONObject response = new JSONObject();
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put("fields", 1);
        keyMap.put("order_field", 1);
        keyMap.put("order_direction", 1);
        keyMap.put("page_no", 1);
        keyMap.put("page_size", 1);
        if (callback != null) {
            callback.onBeforeAction(paramsObject);
        }
        if (this.containEntId) {
            try {
                this.onDeleteForEntID(session, paramsObject);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)e.getMessage());
            }
        }
        if (paramsObject.containsKey((Object)keyfieldName)) {
            paramsObject.put(keyfieldName, (Object)TypeUtils.castToLong((Object)paramsObject.get((Object)keyfieldName)));
        }
        Set keySet = paramsObject.keySet();
        Criteria criteria = null;
        for (Object keyName : keySet) {
            if (keyMap.containsKey(keyName) || AbstractEntityBean.isTransientField((Class)this.getBeanClass(), (String)keyName)) continue;
            criteria = this.onParseParamsOne(criteria, (String)keyName, paramsObject.get(keyName));
        }
        if (criteria != null) {
            List<AnnotationService> tagPlugins = this.getPlugins();
            for (AnnotationService plugin : tagPlugins) {
                try {
                    plugin.onAction(session, (Object)paramsObject, OperationFlag.Delete, this.getBeanClass());
                }
                catch (Exception e) {
                    return ServiceResponse.buildFailureWithErrCode((ServiceSession)session, (String)"10020", (Object[])new Object[]{e.getMessage()});
                }
            }
            this.onBeforeDelete(session, criteria);
            Query query = new Query(criteria);
            List oldModelList = this.dataQuery(session, query);
            int n = this.doDelete(session, template, query, callback);
            if (n > 0) {
                response.put(keyfieldName, paramsObject.get((Object)keyfieldName));
                for (Object oldModel : oldModelList) {
                    this.opLogService.logger(session, (JSONObject)JSON.toJSON(oldModel), null, this.getBeanClass(), ((FMybatisTemplate)template).getSqlSessionTemplate().getConfiguration().getEnvironment().getDataSource(), OperationFlag.Delete);
                }
            }
        }
        return ServiceResponse.buildSuccess((Object)response);
    }

    protected List<Map<String, Object>> onBeforeImportData(JSONObject jsonparam, MultipartFile file) throws Exception {
        List<Map<String, Object>> dataList = null;
        String type = jsonparam.getString("type");
        if (!type.equals("plain")) {
            if (file == null) {
                throw new Exception(I18nUtil.getMessage((String)"50018"));
            }
            dataList = FileProcessorUtils.parseFile(jsonparam, file.getInputStream());
        } else {
            dataList = FileProcessorUtils.parseFile(jsonparam);
        }
        return dataList;
    }

    protected List<Map<String, Object>> onBeforeImportData(String params, MultipartFile file) throws Exception {
        List<Map<String, Object>> dataList = null;
        JSONObject jsonparam = JSONObject.parseObject((String)params);
        String type = jsonparam.getString("type");
        if (!type.equals("plain")) {
            if (file == null) {
                throw new Exception(I18nUtil.getMessage((String)"50018"));
            }
            dataList = FileProcessorUtils.parseFile(jsonparam, file.getInputStream());
        } else {
            dataList = FileProcessorUtils.parseFile(jsonparam);
        }
        return dataList;
    }

    public ServiceResponse onImportData(String params, MultipartFile file) throws Exception {
        return this.onImportData(SpringContext.getSession(), params, file);
    }

    public ServiceResponse onImportData(ServiceSession session, String params, MultipartFile file) throws Exception {
        ServiceResponse response = null;
        List<Map<String, Object>> dataList = this.onBeforeImportData(params, file);
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> map = dataList.get(i);
            JSONObject paramsObject = JSONObject.parseObject((String)JSON.toJSONString(map));
            this.onUpdate(session, paramsObject);
        }
        response = ServiceResponse.buildSuccess((Object)"");
        return response;
    }

    public ServiceResponse onImportData(ServiceSession session, JSONObject params, MultipartFile file) throws Exception {
        ServiceResponse response = null;
        List<Map<String, Object>> dataList = this.onBeforeImportData(params, file);
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> map = dataList.get(i);
            JSONObject paramsObject = JSONObject.parseObject((String)JSON.toJSONString(map));
            this.onUpdate(session, paramsObject);
        }
        response = ServiceResponse.buildSuccess((Object)"");
        return response;
    }

    protected String onBeforeExportData(String params) throws Exception {
        return params;
    }

    public ServiceResponse onExportData(ServiceSession session, String params, OutputStream os) {
        try {
            JSONObject jsonparam = JSONObject.parseObject((String)this.onBeforeExportData(params));
            String type = jsonparam.getString("type");
            String url = jsonparam.getString("url");
            String jparams = jsonparam.getString("params");
            if (session != null) {
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("session", JSON.toJSONString((Object)session));
                UriTemplate template = new UriTemplate(url);
                url = template.expand(paramsMap).toString();
            }
            String cols = jsonparam.getString("cols");
            String tname = jsonparam.getString("tname");
            String istree = jsonparam.getString("istree");
            String childname = jsonparam.getString("childname");
            String header = jsonparam.getString("header");
            FileProcessorUtils.exportFile(type, url, jparams, cols, tname, header, istree, childname, os);
            return ServiceResponse.buildSuccess((Object)"");
        }
        catch (Exception e) {
            ServiceResponse sr = new ServiceResponse();
            sr.setReturncode("50000");
            sr.setData((Object)I18nUtil.getMessage((String)"50019", (Object[])new Object[]{e.getMessage()}, (String)session.getLocale()));
            return sr;
        }
    }

    public ServiceResponse onExportDataDirect(ServiceSession session, String params, OutputStream os) {
        try {
            JSONObject jsonparam = JSONObject.parseObject((String)params);
            String type = jsonparam.getString("type");
            String url = jsonparam.getString("url");
            String jparams = jsonparam.getString("params");
            String cols = jsonparam.getString("cols");
            String tname = jsonparam.getString("tname");
            String istree = jsonparam.getString("istree");
            String childname = jsonparam.getString("childname");
            String header = jsonparam.getString("header");
            FileProcessorUtils.exportFile(type, url, jparams, cols, tname, header, istree, childname, os);
            return ServiceResponse.buildSuccess((Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            ServiceResponse sr = new ServiceResponse();
            sr.setReturncode("50000");
            sr.setData((Object)I18nUtil.getMessage((String)"50019", (Object[])new Object[]{e.getMessage()}, (String)session.getLocale()));
            return sr;
        }
    }

    public ServiceResponse onSave(JSONObject paramsObject) throws Exception {
        return this.onSave(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse onSave(ServiceSession session, JSONObject paramsObject) throws Exception {
        Object params = paramsObject.get((Object)this.getCollectionName());
        if (params != null && params instanceof List) {
            JSONArray dataList = paramsObject.getJSONArray(this.getCollectionName());
            return this.onSaveBatch(session, dataList);
        }
        return this.onSaveSingle(session, paramsObject);
    }

    protected void onBeforeSaveBatch(ServiceSession session, JSONArray dataList) {
    }

    public ServiceResponse onSaveBatch(ServiceSession session, JSONArray dataList) {
        this.onBeforeSaveBatch(session, dataList);
        JSONArray deleteArray = new JSONArray();
        JSONArray insertArray = new JSONArray();
        JSONArray updateArray = new JSONArray();
        dataList.forEach(e -> {
            JSONObject dataMap = (JSONObject)JSON.toJSON((Object)e);
            String dataFlag = this.getModelFlag(dataMap);
            if ("D".equalsIgnoreCase(dataFlag)) {
                this.deleteFilterPrimaryKey(dataMap);
                deleteArray.add((Object)dataMap);
            } else if ("I".equalsIgnoreCase(dataFlag)) {
                insertArray.add((Object)dataMap);
            } else if ("U".equalsIgnoreCase(dataFlag)) {
                updateArray.add((Object)dataMap);
            }
        });
        JSONArray returnarray = new JSONArray();
        returnarray.addAll((Collection)this.onDeleteBatch(session, deleteArray));
        returnarray.addAll((Collection)this.onInsertBatch(session, insertArray));
        returnarray.addAll((Collection)this.onUpdateBatch(session, updateArray));
        return ServiceResponse.buildSuccess((Object)returnarray);
    }

    public void onBeforeDeleteBatch(ServiceSession session, JSONArray dataList) {
    }

    public JSONArray onDeleteBatch(ServiceSession session, JSONArray dataList) {
        this.onBeforeDeleteBatch(session, dataList);
        JSONArray returnarray = new JSONArray();
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject dataMap = dataList.getJSONObject(i);
            returnarray.add((Object)this.onDelete(session, dataMap));
        }
        return returnarray;
    }

    public void onBeforeInsertBatch(ServiceSession session, JSONArray dataList) {
    }

    public JSONArray onInsertBatch(JSONArray dataList) {
        return this.onInsertBatch(SpringContext.getSession(), dataList);
    }

    public JSONArray onInsertBatch(ServiceSession session, JSONArray dataList) {
        this.onBeforeInsertBatch(session, dataList);
        JSONArray returnarray = new JSONArray();
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject dataMap = dataList.getJSONObject(i);
            returnarray.add((Object)this.onInsert(session, dataMap));
        }
        return returnarray;
    }

    public void onBeforeUpdateBatch(ServiceSession session, JSONArray dataList) {
    }

    public JSONArray onUpdateBatch(ServiceSession session, JSONArray dataList) {
        this.onBeforeUpdateBatch(session, dataList);
        JSONArray returnarray = new JSONArray();
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject dataMap = dataList.getJSONObject(i);
            returnarray.add((Object)this.onUpdate(session, dataMap));
        }
        return returnarray;
    }

    public ServiceResponse onUpdateInsertByUniqueKey(JSONObject paramsObject) {
        if (paramsObject.containsKey((Object)this.collectionName)) {
            Object dataObject = paramsObject.get((Object)this.collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(this.collectionName);
                this.onUpdateInsertByUniqueKey(paramsArray);
                return ServiceResponse.buildSuccess((Object)"success");
            }
            return this.onUpdateInsertByUniqueKeySingle(TypeUtils.toJSONObj((Object)dataObject, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
        }
        return this.onUpdateInsertByUniqueKeySingle(paramsObject);
    }

    public void onUpdateInsertByUniqueKey(JSONArray dataList) {
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject params = dataList.getJSONObject(i);
            this.onUpdateInsertByUniqueKeySingle(params);
        }
    }

    public ServiceResponse onUpdateInsertByUniqueKeySingle(JSONObject paramsObject) {
        ServiceSession session = SpringContext.getSession();
        List<String> uniqueKeys = this.getUniqueKeys();
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty(uniqueKeys) || uniqueKeys.isEmpty()) {
            throw new ServiceRuntimeException(String.format("\u8868%1$s\u552f\u4e00\u952e\u672a\u8bbe\u7f6e", new Object[0]), this.getCollectionName());
        }
        Criteria criteria = null;
        for (String keyName : uniqueKeys) {
            if (StringUtils.isEmpty((Object)paramsObject.get((Object)keyName))) {
                throw new ServiceRuntimeException(String.format("\u8868%1$s\u6309\u552f\u4e00\u952e\u4fee\u6539\u65f6\u5b57\u6bb5%2$s\u503c\u4e3a\u7a7a", this.getCollectionName(), keyName));
            }
            criteria = this.onParseParamsOne(criteria, keyName, paramsObject.get((Object)keyName));
            rtnMap.put(keyName, paramsObject.get((Object)keyName));
        }
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put(this.keyfieldName, 1);
        if (paramsObject.containsKey((Object)this.getEntname()) && this.containEntId) {
            keyMap.put(this.getEntname(), 1);
        }
        Object oldModel = this.dataQueryFirst(session, new Query((CriteriaDefinition)criteria));
        this.checkDataIsModify(oldModel, paramsObject);
        this.initModel(session, paramsObject, OperationFlag.Update);
        Update update = new Update();
        Set keySet = paramsObject.keySet();
        for (String keyName : keySet) {
            if (keyMap.containsKey(keyName) || AbstractEntityBean.isTransientField((Class)this.getBeanClass(), (String)keyName)) continue;
            this.onAssistMap(update, (Map<String, Object>)paramsObject, keyName, true, false);
        }
        this.onBeforeUpdate(session, criteria, update);
        Query query = new Query((CriteriaDefinition)criteria);
        int n = this.onUpdate(session, this.getTemplate(), query, update, this.getCollectionName());
        if (n > 0) {
            this.opLogService.logger(session, (JSONObject)JSON.toJSON((Object)oldModel), paramsObject, this.getBeanClass(), ((FMybatisTemplate)this.getTemplate()).getSqlSessionTemplate().getConfiguration().getEnvironment().getDataSource(), OperationFlag.Update);
            return ServiceResponse.buildSuccess(rtnMap);
        }
        if (n <= 0) {
            return this.onInsert(paramsObject);
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    public ServiceResponse onUpdateByUniqueKey(JSONObject paramsObject) {
        if (paramsObject.containsKey((Object)this.collectionName)) {
            Object dataObject = paramsObject.get((Object)this.collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(this.collectionName);
                this.onUpdateByUniqueKey(paramsArray);
                return ServiceResponse.buildSuccess((Object)"success");
            }
            return this.onUpdateByUniqueKeySingle(TypeUtils.toJSONObj((Object)dataObject, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
        }
        return this.onUpdateByUniqueKeySingle(paramsObject);
    }

    public void onUpdateByUniqueKey(JSONArray dataList) {
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject params = dataList.getJSONObject(i);
            this.onUpdateByUniqueKeySingle(params);
        }
    }

    public ServiceResponse onUpdateByUniqueKeySingle(JSONObject paramsObject) {
        ServiceSession session = SpringContext.getSession();
        List<String> uniqueKeys = this.getUniqueKeys();
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty(uniqueKeys) || uniqueKeys.isEmpty()) {
            throw new ServiceRuntimeException(String.format("\u8868%1$s\u552f\u4e00\u952e\u672a\u8bbe\u7f6e", new Object[0]), this.getCollectionName());
        }
        Criteria criteria = null;
        for (String keyName : uniqueKeys) {
            if (StringUtils.isEmpty((Object)paramsObject.get((Object)keyName))) {
                throw new ServiceRuntimeException(String.format("\u8868%1$s\u6309\u552f\u4e00\u952e\u4fee\u6539\u65f6\u5b57\u6bb5%2$s\u503c\u4e3a\u7a7a", this.getCollectionName(), keyName));
            }
            criteria = this.onParseParamsOne(criteria, keyName, paramsObject.get((Object)keyName));
            rtnMap.put(keyName, paramsObject.get((Object)keyName));
        }
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put(this.keyfieldName, 1);
        if (paramsObject.containsKey((Object)this.getEntname()) && this.containEntId) {
            keyMap.put(this.getEntname(), 1);
        }
        Object oldModel = this.dataQueryFirst(session, new Query((CriteriaDefinition)criteria));
        this.checkDataIsModify(oldModel, paramsObject);
        this.initModel(session, paramsObject, OperationFlag.Update);
        Update update = new Update();
        Set keySet = paramsObject.keySet();
        for (String keyName : keySet) {
            if (keyMap.containsKey(keyName) || AbstractEntityBean.isTransientField((Class)this.getBeanClass(), (String)keyName)) continue;
            this.onAssistMap(update, (Map<String, Object>)paramsObject, keyName, true, false);
        }
        this.onBeforeUpdate(session, criteria, update);
        Query query = new Query((CriteriaDefinition)criteria);
        int n = this.doUpdate(session, this.getTemplate(), query, update, null);
        if (n > 0) {
            this.opLogService.logger(session, (JSONObject)JSON.toJSON((Object)oldModel), paramsObject, this.getBeanClass(), ((FMybatisTemplate)this.getTemplate()).getSqlSessionTemplate().getConfiguration().getEnvironment().getDataSource(), OperationFlag.Update);
        }
        return ServiceResponse.buildSuccess(rtnMap);
    }

    public ServiceResponse onDeleteByUniqueKey(JSONObject paramsObject) {
        if (paramsObject.containsKey((Object)this.collectionName)) {
            Object dataObject = paramsObject.get((Object)this.collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(this.collectionName);
                this.onDeleteByUniqueKey(paramsArray);
                return ServiceResponse.buildSuccess((Object)"success");
            }
            return this.onDeleteByUniqueKeySingle(TypeUtils.toJSONObj((Object)dataObject, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
        }
        return this.onDeleteByUniqueKeySingle(paramsObject);
    }

    public void onDeleteByUniqueKey(JSONArray dataList) {
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject params = dataList.getJSONObject(i);
            this.onDeleteByUniqueKeySingle(params);
        }
    }

    public ServiceResponse onDeleteByUniqueKeySingle(JSONObject paramsObject) {
        ServiceSession session = SpringContext.getSession();
        List<String> uniqueKeys = this.getUniqueKeys();
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty(uniqueKeys) || uniqueKeys.isEmpty()) {
            throw new ServiceRuntimeException(String.format("\u8868%1$s\u552f\u4e00\u952e\u672a\u8bbe\u7f6e", new Object[0]), this.getCollectionName());
        }
        Criteria criteria = null;
        for (String keyName : uniqueKeys) {
            if (StringUtils.isEmpty((Object)paramsObject.get((Object)keyName))) {
                throw new ServiceRuntimeException(String.format("\u8868%1$s\u6309\u552f\u4e00\u952e\u4fee\u6539\u65f6\u5b57\u6bb5%2$s\u503c\u4e3a\u7a7a", this.getCollectionName(), keyName));
            }
            criteria = this.onParseParamsOne(criteria, keyName, paramsObject.get((Object)keyName));
            rtnMap.put(keyName, paramsObject.get((Object)keyName));
        }
        this.onBeforeDelete(session, criteria);
        Query query = new Query(criteria);
        Object oldModel = this.dataQueryFirst(query);
        int n = this.doDelete(session, this.getTemplate(), query, null);
        if (n > 0) {
            this.opLogService.logger(session, (JSONObject)JSON.toJSON((Object)oldModel), null, this.getBeanClass(), ((FMybatisTemplate)this.getTemplate()).getSqlSessionTemplate().getConfiguration().getEnvironment().getDataSource(), OperationFlag.Delete);
        }
        return ServiceResponse.buildSuccess(rtnMap);
    }

    public ServiceResponse onSaveByUniqueKey(JSONObject paramsObject) {
        if (paramsObject.containsKey((Object)this.collectionName)) {
            Object dataObject = paramsObject.get((Object)this.collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray dataList = paramsObject.getJSONArray(this.collectionName);
                JSONArray deleteArray = new JSONArray();
                JSONArray insertArray = new JSONArray();
                JSONArray updateArray = new JSONArray();
                dataList.forEach(e -> {
                    JSONObject dataMap = (JSONObject)JSON.toJSON((Object)e);
                    String dataFlag = this.getModelFlag(dataMap);
                    if ("D".equalsIgnoreCase(dataFlag)) {
                        this.deleteFilterPrimaryKey(dataMap);
                        deleteArray.add((Object)dataMap);
                    } else if ("I".equalsIgnoreCase(dataFlag)) {
                        insertArray.add((Object)dataMap);
                    } else if ("U".equalsIgnoreCase(dataFlag)) {
                        updateArray.add((Object)dataMap);
                    }
                });
                this.onDeleteByUniqueKey(deleteArray);
                this.onInsertBatch(insertArray);
                this.onUpdateByUniqueKey(updateArray);
                return ServiceResponse.buildSuccess((Object)"success");
            }
            return this.onSaveByUniqueKeySingle(TypeUtils.toJSONObj((Object)dataObject, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
        }
        return this.onSaveByUniqueKeySingle(paramsObject);
    }

    public ServiceResponse onSaveByUniqueKeySingle(JSONObject paramsObject) {
        String dataFlag = this.getModelFlag(paramsObject);
        if ("I".equals(dataFlag)) {
            return this.onInsert(paramsObject);
        }
        if ("D".equals(dataFlag)) {
            return this.onDeleteByUniqueKeySingle(paramsObject);
        }
        if ("U".equals(dataFlag)) {
            return this.onUpdateByUniqueKeySingle(paramsObject);
        }
        return this.onQuery(paramsObject);
    }

    public ServiceResponse onSaveSingle(ServiceSession session, JSONObject paramsObject) {
        String dataFlag = this.getModelFlag(paramsObject);
        if ("I".equalsIgnoreCase(dataFlag)) {
            return this.onInsert(session, paramsObject);
        }
        if ("U".equalsIgnoreCase(dataFlag)) {
            return this.onUpdate(session, paramsObject);
        }
        if ("D".equalsIgnoreCase(dataFlag)) {
            this.deleteFilterPrimaryKey(paramsObject);
            return this.onDelete(session, paramsObject);
        }
        return this.onQuery(session, paramsObject);
    }

    public Query transformJSON(JSONObject paramsObject, Map<String, Integer> keyMap) {
        List criteriaList = this.convertHandler.onConvert(paramsObject, keyMap, this.getBeanClass());
        Query query = new Query();
        query = this.convertHandler.baseCreateQuery(query, criteriaList);
        return query;
    }

    public Query transformJSON(JSONObject paramsObject) {
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put("fields", 1);
        keyMap.put("order_field", 1);
        keyMap.put("order_direction", 1);
        keyMap.put("page_no", 1);
        keyMap.put("page_size", 1);
        List criteriaList = this.convertHandler.onConvert(paramsObject, keyMap, this.getBeanClass());
        Query query = new Query();
        query = this.convertHandler.baseCreateQuery(query, criteriaList);
        return query;
    }

    public String getBeanEntCol() {
        String[] cols;
        StringBuffer sb = new StringBuffer();
        ((FMybatisTemplate)this.getTemplate()).fetchAllDeclaredField(this.getBeanClass(), sb);
        for (String col : cols = sb.toString().split(",")) {
            if (!col.equalsIgnoreCase(this.getEntname())) continue;
            return col;
        }
        return this.getEntname();
    }

    public void deleteFilterPrimaryKey(JSONObject paramsObject) {
        if (StringUtils.isEmpty((Object)(paramsObject = (JSONObject)TypeUtils.filter((JSON)paramsObject, (ValueFilter)new ValueFilter(){

            public Object process(Object object, String name, Object value) {
                if (!name.equalsIgnoreCase(BaseCompomentServiceImpl.this.getCollectionName()) && !name.equalsIgnoreCase(BaseCompomentServiceImpl.this.getKeyfieldName())) {
                    return null;
                }
                if (value != null && value instanceof String && value.toString().isEmpty()) {
                    return null;
                }
                return value;
            }
        }))) || paramsObject.size() == 0) {
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10024"));
        }
    }

    public void checkDataIsModify(Y oldModel, JSONObject newJson) {
        List<Field> fieldList;
        Field field;
        if (this.isCheckDataIsModify && !StringUtils.isEmpty((Object)(field = (Field)(fieldList = this.getFieldList()).stream().filter(f -> f.isAnnotationPresent(ModifyTime.class)).findFirst().orElse(null)))) {
            String fieldName = field.getName();
            Object obj = null;
            try {
                obj = AbstractEntityBean.getFieldValue((Class)this.getBeanClass(), oldModel, (String)fieldName);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Class<?> type = field.getType();
            if (type == Long.class || type == Long.TYPE) {
                Long oldValue = (Long)obj;
                Long newValue = newJson.getLongValue(fieldName);
                if (!(StringUtils.isEmpty((Object)oldValue) || StringUtils.isEmpty((Object)newValue) || oldValue.equals(newValue))) {
                    throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50027"));
                }
            } else if (type == Date.class) {
                Date oldValue = (Date)obj;
                Date newValue = newJson.getDate(fieldName);
                if (!(StringUtils.isEmpty((Object)oldValue) || StringUtils.isEmpty((Object)newValue) || oldValue.equals(newValue))) {
                    throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50027"));
                }
            }
        }
    }

    private List<Field> getFieldList() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class tempClass = this.getBeanClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        return fieldList;
    }
}

