/*
 * Decompiled with CFR 0.152.
 */
package com.product.component.essearch;

import com.product.service.EsIndexService;
import jakarta.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"elasticsearch.enable"}, havingValue="true", matchIfMissing=false)
@Component
public class EsIndexTemplate
implements EsIndexService {
    @Resource
    protected ElasticsearchOperations operations;

    @Override
    public <T> boolean createIndex(Class<T> t) {
        IndexOperations indexOperations = this.operations.indexOps(t);
        boolean createIndexRes = indexOperations.create();
        if (!createIndexRes) {
            return false;
        }
        Document document = indexOperations.createMapping();
        return indexOperations.putMapping(document);
    }

    @Override
    public <T> boolean deleteIndex(Class<T> t) {
        return this.operations.indexOps(t).delete();
    }

    @Override
    public <T> boolean reCreate(Class<T> t) {
        IndexOperations indexOperations = this.operations.indexOps(t);
        return indexOperations.delete() && indexOperations.create();
    }

    @Override
    public <T> boolean indexExists(Class<T> t) {
        return this.operations.indexOps(t).exists();
    }
}

