/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.dynamicds;

import com.product.config.BaseConfiger;
import com.product.config.dynamicds.DbConfigModel;
import com.product.config.dynamicds.DbConfigServiceImpl;
import com.product.datasource.DatabaseConfig;
import com.product.datasource.DynamicDataSourceContextHolder;
import com.product.datasource.DynamicRoutingDataSource;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.logging.LoggingMeterRegistry;
import io.micrometer.core.instrument.logging.LoggingRegistryConfig;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(prefix="dynamicsds", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={BaseConfiger.class})
public class DynamicDatasourceConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DynamicDatasourceConfig.class);
    private final String masterKey = "defaultDs";
    @Value(value="${spring.datasource.validation-timeout:4000}")
    long validationTimeoutMs;
    @Value(value="${spring.datasource.connection-timeout:8000}")
    long connectionTimeoutMs;
    @Value(value="${spring.datasource.maximum-pool-size:50}")
    int maxPoolSize;
    @Value(value="${spring.datasource.minimum-idle:10}")
    int minIdle;
    @Value(value="${spring.datasource.idle-timeout:0}")
    long idleTimeoutMs;
    @Value(value="${spring.datasource.max-lifetime:3600000}")
    long maxLifetimeMs;
    @Value(value="${dynamicsds.hikari.stat:false}")
    Boolean hikariStat;
    @Autowired
    FMybatisTemplate mybatisTemplate;
    @Autowired
    @Qualifier(value="datasource")
    private DataSource dataSource;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Bean(value={"dynamicDataSource"})
    public DataSource onDynamicDataSource() {
        log.info("---> creating dynamicDataSource");
        DynamicRoutingDataSource dynamicRoutingDataSource = new DynamicRoutingDataSource();
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(2);
        String serverTimezone = null;
        if (this.dataSource instanceof HikariDataSource) {
            this.dsMeterStat((HikariDataSource)this.dataSource);
            serverTimezone = DatabaseConfig.extractServerTimezone(((HikariDataSource)this.dataSource).getJdbcUrl());
        }
        dataSourceMap.put("defaultDs", this.dataSource);
        this.checkConfigExist();
        DbConfigServiceImpl dbConfigSrv = new DbConfigServiceImpl(this.mybatisTemplate);
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        List<DbConfigModel> dblist = this.mybatisTemplate.select(query, DbConfigModel.class, dbConfigSrv.getCollectionName());
        for (DbConfigModel db : dblist) {
            HikariDataSource ds = (HikariDataSource)this.createByConfig(db, serverTimezone);
            this.dsMeterStat(ds);
            dataSourceMap.put(db.getCode(), (DataSource)ds);
        }
        String defaultdbkey = "defaultDs";
        dynamicRoutingDataSource.setDefaultTargetDataSource(dataSourceMap.get(defaultdbkey));
        dynamicRoutingDataSource.setTargetDataSources(dataSourceMap);
        DynamicDataSourceContextHolder.setDataSourcesMap(dataSourceMap);
        DynamicDataSourceContextHolder.dataSourceKeys.addAll(dataSourceMap.keySet());
        DynamicDataSourceContextHolder.setRouterKey((String)defaultdbkey);
        return dynamicRoutingDataSource;
    }

    public DataSource createByConfig(DbConfigModel db, String serverTimezone) {
        this.fillDbProp(db);
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(db.getDriverClassName());
        if (!StringUtils.isEmpty((Object)serverTimezone)) {
            if (db.getJdbcUrl().contains("?")) {
                config.setJdbcUrl(db.getJdbcUrl() + "&serverTimezone=" + serverTimezone);
            } else {
                config.setJdbcUrl(db.getJdbcUrl() + "?serverTimezone=" + serverTimezone);
            }
        } else {
            config.setJdbcUrl(db.getJdbcUrl());
        }
        config.setUsername(db.getUsername());
        config.setPassword(db.getPassword());
        config.setValidationTimeout(this.validationTimeoutMs);
        config.setConnectionTimeout(this.connectionTimeoutMs);
        config.setMaximumPoolSize(this.maxPoolSize);
        config.setMinimumIdle(this.minIdle);
        config.setIdleTimeout(this.idleTimeoutMs);
        config.setMaxLifetime(this.maxLifetimeMs);
        HikariDataSource ds = new HikariDataSource(config);
        log.info("---> DynamicDatasourceConfig creating HikariDataSource:{}: jdbcDriver:{} jdbcUrl:{} jdbcUser:{} jdbcPass:{} ", new Object[]{db.getCode(), config.getDriverClassName(), config.getJdbcUrl(), config.getUsername(), config.getPassword()});
        return ds;
    }

    public void dsMeterStat(HikariDataSource ds) {
        if (this.hikariStat.booleanValue()) {
            try {
                LoggingMeterRegistry loggingMeterRegistry = new LoggingMeterRegistry(new LoggingRegistryConfig(){

                    public String get(String key) {
                        return null;
                    }

                    public Duration step() {
                        return Duration.ofSeconds(10L);
                    }
                }, Clock.SYSTEM);
                ds.setMetricRegistry((Object)loggingMeterRegistry);
                Connection connection = ds.getConnection();
                TimeUnit.SECONDS.sleep(3L);
                connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Bean(name={"moreSqlSessionFactory"})
    @DependsOn(value={"dynamicDataSource"})
    public SqlSessionFactoryBean onSqlSessionFactoryBean(@Qualifier(value="dynamicDataSource") DataSource datasource) {
        log.info("---> creating more sqlSessionFactoryBean");
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(datasource);
        Resource[] mappers = this.resolveMapperLocations(resource);
        if (!StringUtils.isEmpty((Object)mappers) && mappers.length > 0) {
            service.setMapperLocations(mappers);
        }
        return service;
    }

    @Bean(name={"moreSessionTemplate"})
    @DependsOn(value={"moreSqlSessionFactory"})
    public SqlSessionTemplate onSessionTemplate(@Qualifier(value="moreSqlSessionFactory") SqlSessionFactory moreSessionFactory) {
        log.info("---> creating moreSessionTemplate");
        SqlSessionTemplate response = new SqlSessionTemplate(moreSessionFactory);
        return response;
    }

    @Bean(name={"moreStorageOperation"})
    @Qualifier(value="moreStorageOperation")
    @DependsOn(value={"moreSqlSessionFactory"})
    public FMybatisTemplate onMoreFMybatisTemplate(@Qualifier(value="moreSqlSessionFactory") SqlSessionFactory moreSessionFactory) {
        log.info("---> creating moreFMybatisTemplate");
        return new FMybatisTemplate(moreSessionFactory, ExecutorType.BATCH);
    }

    @Bean(name={"dynamicTemplate"})
    @DependsOn(value={"dynamicDataSource"})
    public JdbcTemplate dynamicTemplate(@Qualifier(value="dynamicDataSource") DataSource datasource) {
        return new JdbcTemplate(datasource);
    }

    @Bean(name={"dynamicTransactionManager"})
    @DependsOn(value={"dynamicDataSource"})
    public PlatformTransactionManager transactionManager(@Qualifier(value="dynamicDataSource") DataSource datasource) {
        log.info("---> creating dynamicTransactionManager");
        return new DataSourceTransactionManager(datasource);
    }

    public Resource[] resolveMapperLocations(Resource resource) {
        try {
            InputStream inputStream = resource.getInputStream();
            XMLConfigBuilder xmlConfigBuilder = new XMLConfigBuilder(inputStream);
            org.apache.ibatis.session.Configuration configuration = xmlConfigBuilder.parse();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            if (configuration.getMappedStatements().isEmpty() || configuration.getMappedStatements().size() == 0) {
                PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
                ArrayList<String> mapperLocations = new ArrayList<String>();
                mapperLocations.add("classpath*:beanmapper/**/*.xml");
                mapperLocations.add("classpath*:beanmapper/*.xml");
                if (!StringUtils.isEmpty(mapperLocations)) {
                    for (String mapperLocation : mapperLocations) {
                        try {
                            Resource[] mappers;
                            for (Resource mapper : mappers = resourceResolver.getResources(mapperLocation)) {
                                if (resources.contains(mapper)) continue;
                                resources.add(mapper);
                            }
                        }
                        catch (IOException e) {
                            log.error("Get myBatis resources happened exception", (Throwable)e);
                        }
                    }
                }
            }
            return resources.toArray(new Resource[resources.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContext.setInstance((ConfigurableApplicationContext)((ConfigurableApplicationContext)applicationContext));
    }

    private void fillDbProp(DbConfigModel db) {
        String jdbcUrl;
        String driverClassName = DatabaseConfig.getDriverClassName(db.getDbType().toLowerCase());
        String jdbcUrlTemplate = DatabaseConfig.getJdbcUrlTemplate(db.getDbType().toLowerCase());
        if (driverClassName == null || jdbcUrlTemplate == null) {
            throw new IllegalArgumentException("Unsupported database type: " + db.getDbType());
        }
        try {
            jdbcUrl = String.format(jdbcUrlTemplate, db.getIp(), db.getPort(), db.getDb());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct JDBC URL", e);
        }
        db.setDriverClassName(driverClassName);
        db.setJdbcUrl(jdbcUrl);
    }

    private void checkConfigExist() {
        try {
            DatabaseMetaData metaData = this.dataSource.getConnection().getMetaData();
            String jdbcUrl = metaData.getURL();
            String dbtype = DatabaseConfig.getDatabaseTypeFromJdbcUrl(jdbcUrl);
            if ("mysql".equals(dbtype)) {
                String schema = DatabaseConfig.getSchemaFromJdbcUrl(jdbcUrl);
                String sql = "select count(1) count from information_schema.TABLES where table_name='dbconfig' and table_schema='" + schema + "'";
                String createSql = "CREATE TABLE `dbconfig` (\n  `sid` bigint(20) NOT NULL COMMENT 'ID',\n  `ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'ip\u5730\u5740',\n  `port` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '\u7aef\u53e3',\n  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '\u7528\u6237\u540d',\n  `password` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '\u5bc6\u7801',\n  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '\u521b\u5efa\u4eba',\n  `createdate` datetime DEFAULT NULL COMMENT '\u521b\u5efa\u65e5\u671f',\n  `modifier` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '\u4fee\u6539\u4eba',\n  `updatedate` datetime DEFAULT NULL COMMENT '\u4fee\u6539\u65e5\u671f',\n  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '\u5e93\u7f16\u53f7 \u552f\u4e00\u6807\u8bc6,myshop\u4e2d\u95e8\u5e97\u7ec4',\n  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '\u8bf4\u660e',\n  `db` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '\u5e93\u540d \u5982\uff1aomdmain\u3001order',\n  `dbtype` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'MYSQL ORACLE SQLSERVER',\n  PRIMARY KEY (`sid`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8";
                Map map = (Map)this.mybatisTemplate.getSqlSessionTemplate().selectOne("mybatis.sql.select", sql);
                if (StringUtils.isEmpty((Object)map) || "0".equals(map.get("count").toString())) {
                    this.mybatisTemplate.getSqlSessionTemplate().selectOne("mybatis.sql.select", createSql);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

