/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.saas.filter;

import com.product.storage.filter.FtSqlSource;
import com.product.storage.slice.filter.ExecutorSliceWrapper;
import com.product.util.SpringContext;
import com.product.util.StaticVariable;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class ExecutorSaasWrapper
implements Interceptor {
    protected MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length > 0) {
            builder.keyProperty(ms.getKeyProperties()[0]);
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    protected String exchange(String sql) {
        String schema = "" + StaticVariable.get((String)"context.schema");
        String entId = "" + StaticVariable.get((String)"context.entId");
        String responseSQL = sql;
        if (!(StringUtils.isEmpty((CharSequence)schema) || StringUtils.isEmpty((CharSequence)entId) || "null".equals(schema) || "null".equals(entId))) {
            if (!sql.startsWith("/* !mycat:schema")) {
                responseSQL = String.format("/* !mycat:schema = %1$s-%2$s*/%3$s", schema, entId, sql);
            }
            System.out.println("\u5728\u6b64\u4fee\u6539SQL\uff1a" + sql + " \u6700\u7ec8SQL:" + responseSQL);
        }
        return responseSQL;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (SpringContext.getActiveProfile().equals("local")) {
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[ExecutorSliceWrapper.MAPPED_STATEMENT_INDEX];
        String sqlStatement = "";
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        if (invocation.getArgs().length == 6) {
            boundSql = (BoundSql)invocation.getArgs()[ExecutorSliceWrapper.BOUNDSQL_INDEX];
        }
        sqlStatement = boundSql.getSql();
        String newStatement = this.exchange(sqlStatement);
        FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newStatement, boundSql);
        MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
        invocation.getArgs()[0] = newMs;
        Object response = invocation.proceed();
        return response;
    }
}

