/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class CodeTableEncrypt {
    private static final int FIXED_LENGTH = 62;
    private static final String CHAR_POOL = "abcdefghijklmnopqrstuvwxyz";
    private static final String NUM_POOL = "0123456789";
    private static final Map<Character, String> UPPERCASE_MAP = new HashMap<Character, String>();
    private static final Map<Character, String> LOWERCASE_MAP = new HashMap<Character, String>();
    private static final Map<Character, String> NUMBER_MAP = new HashMap<Character, String>();
    private static final Map<Character, String> SPECIAL_CHAR_MAP = new HashMap<Character, String>();

    public static String encodeByRule(String input) {
        String base64Encoded = Base64.getEncoder().encodeToString(input.getBytes()).replace("=", "");
        int inputLength = base64Encoded.length();
        StringBuilder mixedString = new StringBuilder();
        for (int i = 0; i < base64Encoded.length(); ++i) {
            char c = base64Encoded.charAt(i);
            if (Character.isUpperCase(c)) {
                mixedString.append(UPPERCASE_MAP.get(Character.valueOf(c)));
                continue;
            }
            if (Character.isLowerCase(c)) {
                mixedString.append(LOWERCASE_MAP.get(Character.valueOf(c)));
                continue;
            }
            if (Character.isDigit(c)) {
                mixedString.append(NUMBER_MAP.get(Character.valueOf(c)));
                continue;
            }
            if (!SPECIAL_CHAR_MAP.containsKey(Character.valueOf(c))) continue;
            mixedString.append(SPECIAL_CHAR_MAP.get(Character.valueOf(c)));
        }
        int twiceEncodedLength = mixedString.length();
        while (twiceEncodedLength < 62) {
            String fillerBase64Encoded = Base64.getEncoder().encodeToString(base64Encoded.getBytes()).replace("=", "");
            for (int i = 0; i < fillerBase64Encoded.length() && twiceEncodedLength < 62; ++i) {
                char c = fillerBase64Encoded.charAt(i);
                if (Character.isUpperCase(c)) {
                    mixedString.append(UPPERCASE_MAP.get(Character.valueOf(c)));
                } else if (Character.isLowerCase(c)) {
                    mixedString.append(LOWERCASE_MAP.get(Character.valueOf(c)));
                } else if (Character.isDigit(c)) {
                    mixedString.append(NUMBER_MAP.get(Character.valueOf(c)));
                } else if (SPECIAL_CHAR_MAP.containsKey(Character.valueOf(c))) {
                    mixedString.append(SPECIAL_CHAR_MAP.get(Character.valueOf(c)));
                }
                twiceEncodedLength = mixedString.length();
            }
        }
        String lengthStr = String.format("%02d", inputLength);
        mixedString.append(lengthStr);
        return mixedString.toString();
    }

    public static String decodeByRule(String mixedString) {
        String lengthStr = mixedString.substring(mixedString.length() - 2);
        int originalLength = Integer.parseInt(lengthStr);
        int encodedPartLength = originalLength * 2;
        StringBuilder base64Encoded = new StringBuilder();
        for (int i = 0; i < encodedPartLength; i += 2) {
            String segment = mixedString.substring(i, i + 2);
            char decodedChar = CodeTableEncrypt.getDecodedChar(segment);
            base64Encoded.append(decodedChar);
        }
        byte[] decodedBytes = Base64.getDecoder().decode(base64Encoded.toString());
        return new String(decodedBytes);
    }

    private static char getDecodedChar(String segment) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!UPPERCASE_MAP.containsValue(segment)) break block4;
                        for (Map.Entry<Character, String> entry : UPPERCASE_MAP.entrySet()) {
                            if (!entry.getValue().equals(segment)) continue;
                            return entry.getKey().charValue();
                        }
                        break block5;
                    }
                    if (!LOWERCASE_MAP.containsValue(segment)) break block6;
                    for (Map.Entry<Character, String> entry : LOWERCASE_MAP.entrySet()) {
                        if (!entry.getValue().equals(segment)) continue;
                        return entry.getKey().charValue();
                    }
                    break block5;
                }
                if (!NUMBER_MAP.containsValue(segment)) break block7;
                for (Map.Entry<Character, String> entry : NUMBER_MAP.entrySet()) {
                    if (!entry.getValue().equals(segment)) continue;
                    return entry.getKey().charValue();
                }
                break block5;
            }
            if (!SPECIAL_CHAR_MAP.containsValue(segment)) break block5;
            for (Map.Entry<Character, String> entry : SPECIAL_CHAR_MAP.entrySet()) {
                if (!entry.getValue().equals(segment)) continue;
                return entry.getKey().charValue();
            }
        }
        throw new IllegalArgumentException("Invalid encoded segment: " + segment);
    }

    public static void main(String[] args) {
        String input = "123456";
        String encodedStr = Base64.getEncoder().encodeToString(input.getBytes());
        System.out.println("Original: " + input + ", Original length: " + input.length());
        System.out.println("Base64 Encoded: " + encodedStr + ", Base64 length: " + encodedStr.length());
        String encoded = CodeTableEncrypt.encodeByRule(input);
        String decoded = CodeTableEncrypt.decodeByRule(encoded);
        System.out.println("Encoded: " + encoded + ", Encoded length: " + encoded.length());
        System.out.println("Decoded: " + decoded);
    }

    static {
        UPPERCASE_MAP.put(Character.valueOf('A'), "a1");
        UPPERCASE_MAP.put(Character.valueOf('B'), "12");
        UPPERCASE_MAP.put(Character.valueOf('C'), "c3");
        UPPERCASE_MAP.put(Character.valueOf('D'), "24");
        UPPERCASE_MAP.put(Character.valueOf('E'), "e5");
        UPPERCASE_MAP.put(Character.valueOf('F'), "36");
        UPPERCASE_MAP.put(Character.valueOf('G'), "g7");
        UPPERCASE_MAP.put(Character.valueOf('H'), "48");
        UPPERCASE_MAP.put(Character.valueOf('I'), "i9");
        UPPERCASE_MAP.put(Character.valueOf('J'), "51");
        UPPERCASE_MAP.put(Character.valueOf('K'), "k2");
        UPPERCASE_MAP.put(Character.valueOf('L'), "73");
        UPPERCASE_MAP.put(Character.valueOf('M'), "m4");
        UPPERCASE_MAP.put(Character.valueOf('N'), "85");
        UPPERCASE_MAP.put(Character.valueOf('O'), "o6");
        UPPERCASE_MAP.put(Character.valueOf('P'), "97");
        UPPERCASE_MAP.put(Character.valueOf('Q'), "q8");
        UPPERCASE_MAP.put(Character.valueOf('R'), "89");
        UPPERCASE_MAP.put(Character.valueOf('S'), "s1");
        UPPERCASE_MAP.put(Character.valueOf('T'), "72");
        UPPERCASE_MAP.put(Character.valueOf('U'), "u3");
        UPPERCASE_MAP.put(Character.valueOf('V'), "64");
        UPPERCASE_MAP.put(Character.valueOf('W'), "w5");
        UPPERCASE_MAP.put(Character.valueOf('X'), "56");
        UPPERCASE_MAP.put(Character.valueOf('Y'), "y7");
        UPPERCASE_MAP.put(Character.valueOf('Z'), "28");
        LOWERCASE_MAP.put(Character.valueOf('a'), "1z");
        LOWERCASE_MAP.put(Character.valueOf('b'), "2y");
        LOWERCASE_MAP.put(Character.valueOf('c'), "3x");
        LOWERCASE_MAP.put(Character.valueOf('d'), "4w");
        LOWERCASE_MAP.put(Character.valueOf('e'), "5v");
        LOWERCASE_MAP.put(Character.valueOf('f'), "6u");
        LOWERCASE_MAP.put(Character.valueOf('g'), "7t");
        LOWERCASE_MAP.put(Character.valueOf('h'), "8s");
        LOWERCASE_MAP.put(Character.valueOf('i'), "9r");
        LOWERCASE_MAP.put(Character.valueOf('j'), "1q");
        LOWERCASE_MAP.put(Character.valueOf('k'), "2p");
        LOWERCASE_MAP.put(Character.valueOf('l'), "3o");
        LOWERCASE_MAP.put(Character.valueOf('m'), "4n");
        LOWERCASE_MAP.put(Character.valueOf('n'), "5m");
        LOWERCASE_MAP.put(Character.valueOf('o'), "6l");
        LOWERCASE_MAP.put(Character.valueOf('p'), "7k");
        LOWERCASE_MAP.put(Character.valueOf('q'), "8j");
        LOWERCASE_MAP.put(Character.valueOf('r'), "9i");
        LOWERCASE_MAP.put(Character.valueOf('s'), "1h");
        LOWERCASE_MAP.put(Character.valueOf('t'), "2g");
        LOWERCASE_MAP.put(Character.valueOf('u'), "3f");
        LOWERCASE_MAP.put(Character.valueOf('v'), "4e");
        LOWERCASE_MAP.put(Character.valueOf('w'), "5d");
        LOWERCASE_MAP.put(Character.valueOf('x'), "6c");
        LOWERCASE_MAP.put(Character.valueOf('y'), "7b");
        LOWERCASE_MAP.put(Character.valueOf('z'), "8a");
        NUMBER_MAP.put(Character.valueOf('0'), "z1");
        NUMBER_MAP.put(Character.valueOf('1'), "y2");
        NUMBER_MAP.put(Character.valueOf('2'), "x3");
        NUMBER_MAP.put(Character.valueOf('3'), "w4");
        NUMBER_MAP.put(Character.valueOf('4'), "v5");
        NUMBER_MAP.put(Character.valueOf('5'), "u6");
        NUMBER_MAP.put(Character.valueOf('6'), "t7");
        NUMBER_MAP.put(Character.valueOf('7'), "s8");
        NUMBER_MAP.put(Character.valueOf('8'), "r9");
        NUMBER_MAP.put(Character.valueOf('9'), "q0");
        SPECIAL_CHAR_MAP.put(Character.valueOf('+'), "98");
        SPECIAL_CHAR_MAP.put(Character.valueOf('/'), "99");
    }
}

