/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.druid.util.StringUtils;
import com.product.language.MessageSourceHelper;
import com.product.util.CodeTableEncrypt;
import com.product.util.SpringContext;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtils {
    private static final Logger loggerEncrypt = LoggerFactory.getLogger((String)"encryptUtilsLogger");
    private static final Base64 base64 = new Base64();
    private static final int sequenceCount = 3;
    private static final int crossCount = 2;
    private static final String sSource = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String sTarget = "012WXhi73ABCDEYZabcdOPQRSTopqrjklmn56stu4UVefgFGHIJKLMN89vwxyz";

    public static String reverseByStack(String encoderText) {
        char[] chArray;
        if (encoderText == null || encoderText.length() == 0) {
            return encoderText;
        }
        Stack<Character> strStack = new Stack<Character>();
        char[] cArray = chArray = encoderText.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            strStack.push(ch);
        }
        int len = encoderText.length();
        for (int i = 0; i < len; ++i) {
            chArray[i] = ((Character)strStack.pop()).charValue();
        }
        return new String(chArray);
    }

    public static String reverseEncoderByStack(String encoderText, int enCoderLen) {
        Stack stack;
        int i;
        int loopSize;
        if (encoderText == null || encoderText.length() == 0) {
            return encoderText;
        }
        Stack stackAll = new Stack();
        ArrayList stackList = new ArrayList();
        if (enCoderLen > encoderText.length()) {
            enCoderLen = -1;
        }
        if ((loopSize = enCoderLen) < 1) {
            loopSize = 1;
        }
        for (int i2 = 0; i2 < loopSize; ++i2) {
            stackList.add(new Stack());
        }
        char[] chArray = encoderText.toCharArray();
        int length = chArray.length;
        for (i = 0; i < length; ++i) {
            Character ch = Character.valueOf(chArray[i]);
            stack = stackAll;
            if (enCoderLen > 0) {
                int index = i % stackList.size();
                stack = (Stack)stackList.get(index);
            }
            stack.push(ch);
        }
        if (enCoderLen > 0) {
            for (i = 0; i < length; ++i) {
                int index = i % stackList.size();
                stack = (Stack)stackList.get(index);
                chArray[i] = ((Character)stack.pop()).charValue();
            }
        } else {
            for (i = 0; i < length; ++i) {
                chArray[i] = ((Character)stackAll.pop()).charValue();
            }
        }
        return new String(chArray);
    }

    public static String encoder(String encodeText, String source, String target, boolean bitChange) {
        String response = "";
        for (int i = 0; i < encodeText.length(); ++i) {
            int newPos;
            String indexChr = encodeText.substring(i, i + 1);
            Integer indexPos = source.indexOf(indexChr);
            if (indexPos < 0) {
                response = response.concat(indexChr);
                continue;
            }
            if (bitChange && (newPos = indexPos + i) + 2 > target.length()) {
                indexPos = newPos - target.length() + 1;
            }
            response = response.concat(target.substring(indexPos, indexPos + 1));
        }
        return response;
    }

    public static String encoder(String encodeText, String source, String target) {
        return EncryptUtils.encoder(encodeText, source, target, false);
    }

    public static String decoder(String encodedText, String source, String target, boolean bitChange) {
        String response = "";
        for (int i = 0; i < encodedText.length(); ++i) {
            int newPos;
            String indexChr = encodedText.substring(i, i + 1);
            Integer indexPos = target.indexOf(indexChr);
            if (indexPos < 0) {
                response = response.concat(indexChr);
                continue;
            }
            if (bitChange && (newPos = indexPos + i) + 2 > source.length()) {
                indexPos = newPos - source.length() + 1;
            }
            response = response.concat(source.substring(indexPos, indexPos + 1));
        }
        return response;
    }

    public static String decoder(String encodedText, String source, String target) {
        return EncryptUtils.decoder(encodedText, source, target, false);
    }

    public static String decoder(String source) {
        if ("true".equals(SpringContext.getEnvironmentVar((String)"user.password.rule.sign"))) {
            String decodedText = CodeTableEncrypt.decodeByRule(source);
            return decodedText;
        }
        String decodedText = EncryptUtils.decoder(source, sSource, sTarget);
        return decodedText;
    }

    public static String encoder(String source) {
        if ("true".equals(SpringContext.getEnvironmentVar((String)"user.password.rule.sign"))) {
            String encodedText = CodeTableEncrypt.encodeByRule(source);
            return encodedText;
        }
        String encodedText = EncryptUtils.encoder(source, sSource, sTarget);
        return encodedText;
    }

    public static String encoderBase64(String source) {
        String encodedText = "";
        try {
            byte[] textByte = source.getBytes("UTF-8");
            encodedText = base64.encodeAsString(textByte);
        }
        catch (UnsupportedEncodingException uee) {
            encodedText = String.format("*#06#_%1$s", source);
        }
        return encodedText;
    }

    public static String decoderBase64(String source) {
        try {
            byte[] textByte = base64.decode(source);
            String decodedText = new String(textByte, "UTF-8");
            return decodedText;
        }
        catch (UnsupportedEncodingException uee) {
            if (source.startsWith("*#06#_")) {
                return source.substring(5);
            }
            return source;
        }
    }

    public static boolean ruler(String source) throws Exception {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return true;
        }
        List<String> ruleList = Arrays.asList("ABCDEFGHIJKLMNOPQRSTUVWXYZ", "abcdefghijklmnopqrstuvwxyz", "0123456789", "qwertyuiopasdfghjklzxcvbnm", "qazwsxedcrfvtgbyhnujmikolp", "!@#$%^&*()-=_+,./<>?;:{}[]");
        List<String> tagList = Arrays.asList("\u8fde\u7eed\u5927\u5199\u5b57\u7b26", "\u8fde\u7eed\u5c0f\u5199\u5b57\u7b26", "\u8fde\u7eed\u6570\u5b57", "\u952e\u76d8\u6a2a\u5411\u8fde\u7eed\u5b57\u7b26", "\u952e\u76d8\u7eb5\u5411\u8fde\u7eed\u5b57\u7b26", "\u952e\u76d8\u8fde\u7eed\u7279\u6b8a\u5b57\u7b26");
        HashMap<Integer, Boolean> crossMap = new HashMap<Integer, Boolean>();
        for (int i = 0; i < ruleList.size(); ++i) {
            crossMap.put(i, false);
            String ruleText = ruleList.get(i);
            String tagName = tagList.get(i);
            Integer lastPos = -1;
            AtomicInteger inCrement = new AtomicInteger(0);
            AtomicInteger deCrement = new AtomicInteger(0);
            AtomicInteger duCrement = new AtomicInteger(0);
            for (int j = 0; j < source.length(); ++j) {
                String indexChr = source.substring(j, j + 1);
                Integer indexPos = ruleText.indexOf(indexChr);
                if (indexPos >= 0) {
                    crossMap.put(i, true);
                }
                if (lastPos < 0) {
                    lastPos = indexPos;
                    inCrement.addAndGet(-inCrement.get() + 1);
                    deCrement.addAndGet(-deCrement.get() + 1);
                    duCrement.addAndGet(-duCrement.get() + 1);
                } else if (lastPos.equals(indexPos)) {
                    duCrement.incrementAndGet();
                    inCrement.addAndGet(-inCrement.get());
                    deCrement.addAndGet(-deCrement.get());
                    lastPos = indexPos;
                } else if (lastPos.equals(indexPos - 1)) {
                    inCrement.incrementAndGet();
                    deCrement.addAndGet(-deCrement.get());
                    duCrement.addAndGet(-duCrement.get());
                    lastPos = indexPos;
                } else if (lastPos.equals(indexPos + 1)) {
                    deCrement.incrementAndGet();
                    inCrement.addAndGet(-inCrement.get());
                    duCrement.addAndGet(-duCrement.get());
                    lastPos = indexPos;
                } else {
                    inCrement.addAndGet(-inCrement.get());
                    deCrement.addAndGet(-deCrement.get());
                    duCrement.addAndGet(-duCrement.get());
                    lastPos = -1;
                }
                if (inCrement.get() < 3 && deCrement.get() < 3 && duCrement.get() < 3) continue;
                throw new Exception(String.format("\u6821\u9a8c\u89c4\u5219:%1$s \u8fde\u7eed\u589e\u52a0:%2$d \u8fde\u7eed\u51cf\u5c11:%3$d \u8fde\u7eed\u91cd\u590d:%4$d", tagName, inCrement.get(), deCrement.get(), duCrement.get()));
            }
        }
        AtomicInteger crossInteger = new AtomicInteger(0);
        crossMap.forEach((key, value) -> {
            if (key != 3 && key != 4 && value.booleanValue()) {
                crossInteger.getAndIncrement();
            }
        });
        if (crossInteger.get() < 2) {
            throw new Exception("\u6821\u9a8c\u89c4\u5219:\u4e0d\u6ee1\u8db3\u540c\u65f6\u5305\u542b(\u5927\u5199\u3001\u5c0f\u5199\u3001\u6570\u5b57\u3001\u7279\u6b8a\u5b57\u7b26)");
        }
        return true;
    }

    public static boolean ruler(String source, String lang) throws Exception {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return true;
        }
        loggerEncrypt.debug("ruler lang:{}", (Object)lang);
        if (source.length() < 8) {
            loggerEncrypt.debug("ruler Exception:{}", (Object)"EncryptUtils50005");
            String message = MessageSourceHelper.getMessageWithDefault((String)"EncryptUtils50005", (String)"\u6821\u9a8c\u89c4\u5219:\u5bc6\u7801\u957f\u5ea6\u8981\u6c42\u6700\u5c118\u4f4d", (String)lang, (Object[])new Object[0]);
            throw new Exception(message);
        }
        if (source.length() > 20) {
            loggerEncrypt.debug("ruler Exception:{}", (Object)"EncryptUtils500011");
            String message = MessageSourceHelper.getMessageWithDefault((String)"EncryptUtils500011", (String)"\u6821\u9a8c\u89c4\u5219:\u5bc6\u7801\u957f\u5ea6\u4e0d\u80fd\u591a\u4e8e20\u4f4d", (String)lang, (Object[])new Object[0]);
            throw new Exception(message);
        }
        List<String> ruleList = Arrays.asList("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", "0123456789", "!@#$%^&*()-=_+,./<>?;:{}[]");
        List<String> tagList = Arrays.asList(MessageSourceHelper.getMessageWithDefault((String)"EncryptUtils50006", (String)"\u91cd\u8986\u5b57\u6bcd", (String)lang, (Object[])new Object[0]), MessageSourceHelper.getMessageWithDefault((String)"EncryptUtils50007", (String)"\u91cd\u8986\u6578\u5b57", (String)lang, (Object[])new Object[0]), MessageSourceHelper.getMessageWithDefault((String)"EncryptUtils50008", (String)"\u91cd\u8986\u7b26\u865f", (String)lang, (Object[])new Object[0]));
        HashMap<Integer, Boolean> crossMap = new HashMap<Integer, Boolean>();
        for (int i = 0; i < ruleList.size(); ++i) {
            crossMap.put(i, false);
            String ruleText = ruleList.get(i);
            String tagName = tagList.get(i);
            Integer lastPos = -1;
            AtomicInteger inCrement = new AtomicInteger(0);
            AtomicInteger deCrement = new AtomicInteger(0);
            AtomicInteger duCrement = new AtomicInteger(0);
            for (int j = 0; j < source.length(); ++j) {
                String indexChr = source.substring(j, j + 1);
                Integer indexPos = ruleText.indexOf(indexChr);
                if (indexPos >= 0) {
                    crossMap.put(i, true);
                }
                if (lastPos < 0) {
                    lastPos = indexPos;
                    inCrement.addAndGet(-inCrement.get() + 1);
                    deCrement.addAndGet(-deCrement.get() + 1);
                    duCrement.addAndGet(-duCrement.get() + 1);
                } else if (lastPos.equals(indexPos)) {
                    duCrement.incrementAndGet();
                    inCrement.addAndGet(-inCrement.get());
                    deCrement.addAndGet(-deCrement.get());
                    lastPos = indexPos;
                } else if (lastPos.equals(indexPos - 1)) {
                    inCrement.incrementAndGet();
                    deCrement.addAndGet(-deCrement.get());
                    duCrement.addAndGet(-duCrement.get());
                    lastPos = indexPos;
                } else if (lastPos.equals(indexPos + 1)) {
                    deCrement.incrementAndGet();
                    inCrement.addAndGet(-inCrement.get());
                    duCrement.addAndGet(-duCrement.get());
                    lastPos = indexPos;
                } else {
                    inCrement.addAndGet(-inCrement.get());
                    deCrement.addAndGet(-deCrement.get());
                    duCrement.addAndGet(-duCrement.get());
                    lastPos = -1;
                }
                if (duCrement.get() < 3) continue;
                String message = MessageSourceHelper.getMessageWithDefault((String)"EncryptUtils50009", (String)"\u65b0\u5bc6\u78bc\u4e0d\u80fd\u4f7f\u7528\u591a\u65bc: {1} \u500b {0}", (String)lang, (Object[])new Object[]{tagName, duCrement.get()});
                throw new Exception(message);
            }
        }
        AtomicInteger crossInteger = new AtomicInteger(0);
        crossMap.forEach((key, value) -> {
            if (value.booleanValue()) {
                crossInteger.getAndIncrement();
            }
        });
        if (crossInteger.get() < 3) {
            String message = MessageSourceHelper.getMessageWithDefault((String)"EncryptUtils50010", (String)"\u6821\u9a8c\u89c4\u5219:\u4e0d\u6ee1\u8db3\u540c\u65f6\u5305\u542b(\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u7279\u6b8a\u5b57\u7b26)", (String)lang, (Object[])new Object[0]);
            throw new Exception(message);
        }
        return true;
    }
}

