/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

public class AuthorityBaseServiceImpl {
    private static Logger log = LoggerFactory.getLogger(AuthorityBaseServiceImpl.class);
    @Autowired
    StringRedisTemplate redisTemplate;

    public List<String> getDataRangeCategory(ServiceSession serviceSession) {
        Set cidSets;
        ArrayList<String> cidList = new ArrayList<String>();
        String key = "datarangecategoryref:" + serviceSession.getDataRangeId();
        if (this.redisTemplate.hasKey((Object)key).booleanValue() && !(cidSets = this.redisTemplate.opsForSet().members((Object)key)).isEmpty()) {
            cidList.addAll(cidSets);
        }
        return cidList;
    }

    public List<String> getDataRangeBusiCompany(ServiceSession serviceSession) {
        Set oidSets;
        ArrayList<String> oidList = new ArrayList<String>();
        String key = "datarangebusicompanyref:" + serviceSession.getDataRangeId();
        if (this.redisTemplate.hasKey((Object)key).booleanValue() && !(oidSets = this.redisTemplate.opsForSet().members((Object)key)).isEmpty()) {
            oidList.addAll(oidSets);
        }
        return oidList;
    }

    public List<String> getDataRangeShop(ServiceSession serviceSession) {
        Set oidSets;
        ArrayList<String> oidList = new ArrayList<String>();
        String key = "datarangeshopref:" + serviceSession.getDataRangeId();
        if (this.redisTemplate.hasKey((Object)key).booleanValue() && !(oidSets = this.redisTemplate.opsForSet().members((Object)key)).isEmpty()) {
            oidList.addAll(oidSets);
        }
        return oidList;
    }

    public List<String> getDataRangeShopCode(ServiceSession serviceSession) {
        ArrayList oidList = new ArrayList();
        ArrayList<String> shopcodeList = new ArrayList<String>();
        String key = "datarangeshopref:" + serviceSession.getDataRangeId();
        if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
            Set oidSets = this.redisTemplate.opsForSet().members((Object)key);
            if (!oidSets.isEmpty()) {
                oidList.addAll(oidSets);
            }
            if (oidList.size() > 0) {
                for (String rid : oidList) {
                    Object o = this.redisTemplate.opsForHash().get((Object)("shop:" + rid), (Object)"shopCode");
                    shopcodeList.add((String)o);
                }
            }
        }
        return shopcodeList;
    }

    public List<String> getDataRangeOrg(ServiceSession serviceSession) {
        Set oidSets;
        ArrayList<String> oidList = new ArrayList<String>();
        String key = "datarangeorgref:" + serviceSession.getDataRangeId();
        if (this.redisTemplate.hasKey((Object)key).booleanValue() && !(oidSets = this.redisTemplate.opsForSet().members((Object)key)).isEmpty()) {
            oidList.addAll(oidSets);
        }
        return oidList;
    }
}

