/*
 * Decompiled with CFR 0.152.
 */
package com.product.component.redis;

import com.product.storage.slice.filter.SliceBase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class MessageSubscriber
implements MessageListener {
    @Autowired
    SliceBase sliceBase;
    @Autowired
    StringRedisTemplate redisTemplate;
    @Value(value="${spring.application.name}")
    private String serviceName;

    public void onMessage(Message message, byte[] pattern) {
        String receivedMessage = message.toString();
        System.out.println(" ====================>>>>> Received message: " + receivedMessage);
        if ("refresh.splitconfig".equals(receivedMessage)) {
            this.sliceBase.init();
            String ipAddress = MessageSubscriber.getIPAddress();
            System.out.println("Service Name: " + this.serviceName);
            System.out.println("IP Address: " + ipAddress);
            Map<String, String> ORGANIZATION_MAP = SliceBase.ORGANIZATION_MAP;
            int count = 0;
            for (Map.Entry<String, String> entry : ORGANIZATION_MAP.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                ++count;
            }
            String appSliceKey = String.format("slice:%s:%s", this.serviceName, ipAddress);
            System.out.println("appSliceKey: " + appSliceKey);
            System.out.println("count: " + count);
            this.redisTemplate.opsForSet().add((Object)appSliceKey, (Object[])new String[]{String.valueOf(count)});
            this.redisTemplate.opsForSet().add((Object)"slice:instances:list", (Object[])new String[]{this.serviceName + ":" + ipAddress});
            this.redisTemplate.expire((Object)appSliceKey, 1L, TimeUnit.DAYS);
            this.redisTemplate.expire((Object)"slice:instances:list", 1L, TimeUnit.DAYS);
        }
    }

    public static String getIPAddress() {
        String ip = "127.0.0.1";
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            ip = localHost.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return ip;
    }
}

