/*
 * Decompiled with CFR 0.152.
 */
package com.product.component.redis;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.product.model.ServiceSession;
import com.product.util.TypeUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RedisCacheInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisCacheInterceptor.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Pointcut(value="@annotation(com.product.annotation.redis.CachePut)")
    public void CachePut() {
    }

    @Pointcut(value="@annotation(com.product.annotation.redis.CacheDel)")
    public void CacheDel() {
    }

    @Around(value="CachePut()")
    public Object CachePutArount(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        try {
            result = point.proceed();
            this.updateRedisCache(point, result);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Around(value="CacheDel()")
    public Object CacheDelArount(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        try {
            result = point.proceed();
            this.deleteRedisCache(point, result);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void updateRedisCache(ProceedingJoinPoint point, Object result) throws Exception {
        JSONObject dataJSON;
        JSONArray dataArray;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        LOGGER.info("\u8bf7\u6c42\u8def\u5f84:" + request.getRequestURL());
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        LOGGER.info("\u8bf7\u6c42\u65b9\u6cd5:" + method.getName());
        Object[] args = point.getArgs();
        LOGGER.info("\u8bf7\u6c42\u53c2\u6570:" + JSONObject.toJSONString((Object)args));
        Object targetObject = point.getTarget();
        method = targetObject.getClass().getMethod("getCollectionName", new Class[0]);
        Object tableObject = method.invoke(targetObject, new Object[0]);
        String tableName = tableObject.toString();
        LOGGER.info("tableName:" + tableName);
        targetObject = point.getTarget();
        method = targetObject.getClass().getMethod("getKeyfieldName", new Class[0]);
        Object fieldObject = method.invoke(targetObject, new Object[0]);
        String keyField = fieldObject.toString();
        LOGGER.info("\u4e3b\u952efield:" + keyField);
        JSONObject response = (JSONObject)TypeUtils.cast((Object)result, JSONObject.class, (ParserConfig)ParserConfig.getGlobalInstance());
        String keyValue = response.getJSONObject("data").getString(keyField);
        LOGGER.info("\u4e3b\u952evalue:" + keyValue);
        method = targetObject.getClass().getMethod("onQuery", ServiceSession.class, JSONObject.class);
        JSONObject paramJSON = new JSONObject();
        paramJSON.put(keyField, (Object)keyValue);
        Object dataObject = method.invoke(targetObject, args[0], paramJSON);
        response = (JSONObject)TypeUtils.cast((Object)dataObject, JSONObject.class, (ParserConfig)ParserConfig.getGlobalInstance());
        if ("0".equals(response.getString("returncode")) && response.get((Object)"data") instanceof JSONObject && (dataArray = (dataJSON = (JSONObject)response.get((Object)"data")).getJSONArray(tableName)).size() > 0) {
            String cacheKey = "cache:" + tableName + ":" + keyValue;
            this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)dataArray.get(0).toString());
        }
    }

    private void deleteRedisCache(ProceedingJoinPoint point, Object result) throws Exception {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        LOGGER.info("\u8bf7\u6c42\u8def\u5f84:" + request.getRequestURL());
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        LOGGER.info("\u8bf7\u6c42\u65b9\u6cd5:" + method.getName());
        Object[] args = point.getArgs();
        LOGGER.info("\u8bf7\u6c42\u53c2\u6570:" + JSONObject.toJSONString((Object)args));
        Object targetObject = point.getTarget();
        method = targetObject.getClass().getMethod("getCollectionName", new Class[0]);
        Object tableObject = method.invoke(targetObject, new Object[0]);
        String tableName = tableObject.toString();
        LOGGER.info("tableName:" + tableName);
        targetObject = point.getTarget();
        method = targetObject.getClass().getMethod("getKeyfieldName", new Class[0]);
        Object fieldObject = method.invoke(targetObject, new Object[0]);
        String keyField = fieldObject.toString();
        LOGGER.info("\u4e3b\u952efield:" + keyField);
        JSONObject response = (JSONObject)TypeUtils.cast((Object)args[1], JSONObject.class, (ParserConfig)ParserConfig.getGlobalInstance());
        String keyValue = response.getString(keyField);
        LOGGER.info("\u4e3b\u952evalue:" + keyValue);
        String cacheKey = "cache:" + tableName + ":" + keyValue;
        this.stringRedisTemplate.delete((Object)cacheKey);
    }
}

