/*
 * Decompiled with CFR 0.152.
 */
package com.product.datasource;

import com.shiji.core.utils.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DatabaseConfig {
    private static final Map<String, String> DB_DRIVER_MAP = new HashMap<String, String>();
    private static final Map<String, String> DB_JDBC_URL_MAP = new HashMap<String, String>();
    private static final Map<String, String> DATABASE_TYPE_MAPPING = new HashMap<String, String>();

    public static String getDriverClassName(String databaseType) {
        return DB_DRIVER_MAP.get(databaseType);
    }

    public static String getJdbcUrlTemplate(String databaseType) {
        return DB_JDBC_URL_MAP.get(databaseType);
    }

    public static String getDatabaseTypeFromJdbcUrl(String jdbcUrl) {
        for (String prefix : DATABASE_TYPE_MAPPING.keySet()) {
            if (!jdbcUrl.startsWith(prefix)) continue;
            return DATABASE_TYPE_MAPPING.get(prefix);
        }
        return null;
    }

    public static String getSchemaFromJdbcUrl(String jdbcUrl) {
        String schema = null;
        String dbtype = DatabaseConfig.getDatabaseTypeFromJdbcUrl(jdbcUrl);
        if ("dm".equals(dbtype)) {
            String url = jdbcUrl.split("\\?")[1];
            if (!StringUtil.isEmpty((String)url)) {
                String[] parts = url.split("&");
                String temp = Arrays.stream(parts).filter(e -> e.indexOf("SCHEMA") >= 0 || e.indexOf("schema") >= 0).findFirst().get();
                return temp.split("=")[1];
            }
        } else {
            String[] parts = jdbcUrl.split("/", 4);
            if (parts.length >= 4) {
                schema = parts[3].split("\\?")[0];
            }
        }
        return schema;
    }

    public static String getIpFromJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.split("\\?")[0];
        String[] parts = url.split("/", 4);
        return parts[2].split(":")[0];
    }

    public static int getPortFromJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.split("\\?")[0];
        String[] parts = url.split("/", 4);
        return Integer.parseInt(parts[2].split(":")[1]);
    }

    public static String extractServerTimezone(String jdbcUrl) {
        String serverTimezone = null;
        String[] parts = jdbcUrl.split("\\?");
        if (parts.length > 1) {
            String[] queryParams;
            String queryString = parts[1];
            for (String queryParam : queryParams = queryString.split("&")) {
                String[] paramParts = queryParam.split("=");
                if (paramParts.length != 2 || !paramParts[0].equals("serverTimezone")) continue;
                serverTimezone = paramParts[1];
                break;
            }
        }
        return serverTimezone;
    }

    static {
        DB_DRIVER_MAP.put("mysql", "com.mysql.cj.jdbc.Driver");
        DB_DRIVER_MAP.put("oracle", "oracle.jdbc.driver.OracleDriver");
        DB_DRIVER_MAP.put("dm", "dm.jdbc.driver.DmDriver");
        DB_JDBC_URL_MAP.put("mysql", "jdbc:mysql://%1$s:%2$s/%3$s?useSSL=false&useUnicode=true&characterEncoding=utf8&autoReconnect=true&allowMultiQueries=true&useAffectedRows=true");
        DB_JDBC_URL_MAP.put("oracle", "jdbc:oracle:thin:@%1$s:%2$s/%3$s");
        DB_JDBC_URL_MAP.put("dm", "jdbc:dm://%1$s:%2$s?SCHEMA=%3$s");
        DATABASE_TYPE_MAPPING.put("jdbc:mysql:", "mysql");
        DATABASE_TYPE_MAPPING.put("jdbc:oracle:", "oracle");
        DATABASE_TYPE_MAPPING.put("jdbc:dm:", "dm");
    }
}

