/*
 * Decompiled with CFR 0.152.
 */
package com.product.interceptor;

import com.product.model.ServiceResponse;
import com.product.util.SpringContext;
import com.shiji.core.util.ExceptionHandlerUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ServiceResponse handleControllerError(HttpServletRequest req, HttpServletResponse rsp, Exception ex) throws Exception {
        Throwable rootCause = ex.getCause();
        if ("true".equals(SpringContext.getEnvironmentVar((String)"exception.stack.enabled"))) {
            return ServiceResponse.buildFailure(null, (String)"10000", (String)ex.getMessage());
        }
        String friendlyMessage = ExceptionHandlerUtils.getFriendlyErrorMessage((Throwable)rootCause);
        return ServiceResponse.buildFailure(null, (String)"10000", (String)friendlyMessage);
    }
}

