/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter;

import com.product.storage.filter.GzipRequestWrapper;
import com.product.storage.filter.GzipResponseWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class GzipFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isgzip = false;
        HttpServletRequest req = (HttpServletRequest)request;
        String contentEncoding = req.getHeader("Content-Encoding");
        if (null != contentEncoding && contentEncoding.indexOf("gzip") != -1) {
            isgzip = true;
        }
        if (isgzip) {
            GzipRequestWrapper gzipreq = new GzipRequestWrapper((HttpServletRequest)request);
            GzipResponseWrapper gziprep = new GzipResponseWrapper((HttpServletResponse)response);
            chain.doFilter((ServletRequest)gzipreq, (ServletResponse)gziprep);
            gziprep.finishResponse();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

