/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipRequestWrapper
extends HttpServletRequestWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(GzipRequestWrapper.class);
    private HttpServletRequest request;

    public GzipRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public ServletInputStream getInputStream() throws IOException {
        ServletInputStream stream = this.request.getInputStream();
        try {
            final GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)stream);
            ServletInputStream newStream = new ServletInputStream(){

                public int read() throws IOException {
                    return gzipInputStream.read();
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener listener) {
                }
            };
            return newStream;
        }
        catch (Exception e) {
            LOGGER.debug("ungzip request fail.", (Throwable)e);
            return stream;
        }
    }
}

