/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.slice.filter.CollectionInsertWrapper;
import com.product.storage.slice.filter.ExecutorCallback;
import com.product.util.DateTimeFormatUtil;
import com.product.util.SpringContext;
import com.product.util.StatisticUtils;
import com.product.util.UniqueID;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.servlet.http.HttpServletRequest;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class ExecutorSliceWrapper
extends CollectionInsertWrapper
implements Interceptor {
    public static int MAPPED_STATEMENT_INDEX = 0;
    public static int PARAMETER_INDEX = 1;
    public static int ROWBOUNDS_INDEX = 2;
    public static int RESULT_HANDLER_INDEX = 3;
    public static int CACHEKEY_INDEX = 4;
    public static int BOUNDSQL_INDEX = 5;
    public static final Logger logger = LoggerFactory.getLogger((String)"sliceLogger");
    public static final Logger slogLogger = LoggerFactory.getLogger((String)"slowLogger");

    private static String getParameterValue(Object obj) {
        Object value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", ExecutorSliceWrapper.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", ExecutorSliceWrapper.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", ExecutorSliceWrapper.getParameterValue(obj));
                }
            }
        }
        return sql;
    }

    public static String getSql(Configuration configuration, BoundSql boundSql, String sqlId, long time) {
        String sql = ExecutorSliceWrapper.showSql(configuration, boundSql);
        return sql;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (SpringContext.getActiveProfile().equals("local")) {
            return invocation.proceed();
        }
        final long interceptID = UniqueID.getUniqueID();
        long startTime = System.currentTimeMillis();
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[MAPPED_STATEMENT_INDEX];
        String sqlStatement = "";
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        String sqlId = mappedStatement.getId();
        Configuration configuration = mappedStatement.getConfiguration();
        if (invocation.getArgs().length == 6) {
            boundSql = (BoundSql)invocation.getArgs()[BOUNDSQL_INDEX];
        }
        sqlStatement = boundSql.getSql();
        logger.debug(String.format("intercept(%1$d)--->1--->%2$s--->%3$s", interceptID, "\u8fdb\u5165\u5206\u7247\u62e6\u622a\u5668", sqlStatement.replaceAll("[\\s]+", " ")));
        String organizationCode = "";
        Object paramsValue = boundSql.getParameterObject();
        if (paramsValue instanceof Map) {
            logger.debug(String.format("intercept(%1$d)--->2--->\u53c2\u6570\u4e3aMap", interceptID));
            Map paramsMap = (Map)paramsValue;
            if (paramsMap.containsKey("@datakey")) {
                organizationCode = paramsMap.get("@datakey").toString();
                logger.debug(String.format("intercept(%1$d)--->3--->organizationCode--->%2$s", interceptID, organizationCode));
                boolean isexec = false;
                if (this.isWrapper(sqlStatement, organizationCode)) {
                    isexec = true;
                    logger.debug(String.format("intercept(%1$d)--->4--->isWrapper--->%2$b", interceptID, isexec));
                }
                if (!isexec) {
                    long start = System.currentTimeMillis();
                    Object returnValue = invocation.proceed();
                    long end = System.currentTimeMillis();
                    long execTime = end - start;
                    this.printSlowLog(configuration, boundSql, sqlId, execTime);
                    return returnValue;
                }
                logger.debug(String.format("intercept(%1$d)--->5--->organizationCode--->%2$s", interceptID, organizationCode));
                final String partionKey = organizationCode;
                ExecutorCallback callback = new ExecutorCallback(){

                    @Override
                    public void onAction(SQLSelectQueryBlock query, String collectionName, String collectionAlias) {
                        SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr();
                        String authWhereSql = ExecutorSliceWrapper.this.getPartionWhere(collectionName, collectionAlias, partionKey);
                        if (!StringUtils.isEmpty((Object)authWhereSql)) {
                            logger.debug(String.format("intercept(%1$d)--->6--->partionKey authWhereSql--->1--->%2$s", interceptID, authWhereSql));
                            SQLExpr authWhereExpr = ExecutorSliceWrapper.this.getWhereInfo(authWhereSql);
                            if (query.getWhere() != null && query.getWhere() instanceof SQLBinaryOpExpr) {
                                SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr)query.getWhere();
                                if (whereExpr != null) {
                                    newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                                    newWhereExpr.setLeft(authWhereExpr);
                                    newWhereExpr.setRight((SQLExpr)whereExpr);
                                }
                            } else {
                                newWhereExpr = authWhereExpr;
                            }
                            query.setWhere((SQLExpr)newWhereExpr);
                        }
                    }
                };
                try {
                    JSONObject logJson = new JSONObject();
                    DbType dbType = DbType.valueOf((String)this.getDbType());
                    List statementList = SQLUtils.toStatementList((String)sqlStatement, (DbType)dbType);
                    for (SQLStatement stmt : statementList) {
                        logJson.put("selectSql", (Object)sqlStatement);
                        if (stmt instanceof SQLSelectStatement) {
                            logger.debug(String.format("intercept(%1$d)--->7--->SqlType--->1--->%2$s", interceptID, "SQLSelectStatement"));
                            this.onSelectStatement(logger, sqlStatement, logJson, invocation, mappedStatement, boundSql, stmt, callback);
                            continue;
                        }
                        if (stmt instanceof SQLUpdateStatement) {
                            logger.debug(String.format("intercept(%1$d)--->8--->SqlType--->1--->%2$s", interceptID, "SQLUpdateStatement"));
                            this.onUpdateStatement(logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey);
                            continue;
                        }
                        if (stmt instanceof SQLDeleteStatement) {
                            logger.debug(String.format("intercept(%1$d)--->9--->SqlType--->1--->%2$s", interceptID, "SQLDeleteStatement"));
                            this.onDeleteStatement(logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey);
                            continue;
                        }
                        if (!(stmt instanceof SQLInsertStatement)) continue;
                        logger.debug(String.format("intercept(%1$d)--->10--->SqlType--->1--->%2$s", interceptID, "SQLInsertStatement"));
                        this.onInsertStatement(logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey);
                    }
                }
                catch (Exception e) {
                    invocation.getArgs()[0] = mappedStatement;
                    logger.info(String.format("intercept(%1$d)--->11--->newSQL --->Faiure:%2$s ---> %3$s", interceptID, e.getMessage(), sqlStatement));
                    JSONObject errorJson = new JSONObject();
                    errorJson.put("unresolved sql", (Object)sqlStatement);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("mybatis\u5206\u7247\u7ec4\u88c5\u8017\u8d39\u65f6\u95f4:----{} --->{}", (Object)(startTime - endTime), (Object)StatisticUtils.onDescibeMethod());
        long start = System.currentTimeMillis();
        Object response = invocation.proceed();
        long end = System.currentTimeMillis();
        long execTime = end - start;
        this.printSlowLog(configuration, boundSql, sqlId, execTime);
        return response;
    }

    private void printSlowLog(Configuration configuration, BoundSql boundSql, String sqlId, long execTime) {
        ConfigurableEnvironment environment = SpringContext.getEnvironment();
        String slowlog_limit = environment.getProperty("slowlog.limit");
        String slowlog_table = environment.getProperty("slowlog.table");
        String slowlog_redis = environment.getProperty("slowlog.redis");
        if (!StringUtils.isEmpty((Object)slowlog_limit) && !StringUtils.isEmpty((Object)slowlog_table)) {
            if (execTime < Long.valueOf(slowlog_limit)) {
                return;
            }
            String sql = ExecutorSliceWrapper.getSql(configuration, boundSql, sqlId, execTime);
            String[] tableArray = slowlog_table.split(",");
            if (slowlog_table.equals("*") || CollectionUtils.containsAll(Arrays.asList(tableArray), ExecutorSliceWrapper.getAllTableNameBySQL(sql))) {
                this.printToLogBack(execTime, sql);
                if ("true".equals(slowlog_redis)) {
                    this.insertSqlToRedis(configuration, sql, execTime);
                }
            }
        }
    }

    private void printToLogBack(long execTime, String sql) {
        slogLogger.info("# Query_time(ms): {}", (Object)execTime);
        slogLogger.info("SET timestamp={}({})", (Object)System.currentTimeMillis(), (Object)DateTimeFormatUtil.toDateTime(new Date()));
        slogLogger.info("sql:{}", (Object)sql);
        HttpServletRequest request = SpringContext.getRequest();
        slogLogger.info("--------------------- \u8bf7\u6c42\u4fe1\u606f begin --------------------- ");
        slogLogger.info(request.getAttribute("requestSession").toString());
        slogLogger.info("--------------------- \u8bf7\u6c42\u4fe1\u606f end ----------------------- ");
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean find = false;
        slogLogger.info("--------------------- \u5806\u6808\u4fe1\u606f begin --------------------- ");
        for (StackTraceElement ele : stackTrace) {
            if (ele.toString().contains("com.product.controller.ProductReflect.invoke")) {
                find = true;
            }
            if (find || ele.toString().contains("sun.reflect") || ele.toString().contains("java.lang") || ele.toString().contains("org.springframework.aop") || ele.toString().contains("com.product.storage.slice.filter")) continue;
            slogLogger.info(ele.toString());
        }
        slogLogger.info("--------------------- \u5806\u6808\u4fe1\u606f end ---------------------");
    }

    private void insertSqlToRedis(Configuration configuration, String sql, long execTime) {
        StringRedisTemplate stringRedisTemplate = null;
        String methodName = SpringContext.getRequest().getParameter("method");
        HikariDataSource datasource = (HikariDataSource)configuration.getEnvironment().getDataSource();
        String jdbcUrl = datasource.getJdbcUrl();
        String ipAndPort = org.apache.commons.lang3.StringUtils.substringBefore((String)org.apache.commons.lang3.StringUtils.substringAfter((String)jdbcUrl, (String)"//"), (String)"/");
        String ip = org.apache.commons.lang3.StringUtils.substringBefore((String)ipAndPort, (String)":");
        String port = org.apache.commons.lang3.StringUtils.substringAfter((String)ipAndPort, (String)":");
        String user = datasource.getUsername();
        String password = datasource.getPassword();
        String dbName = datasource.getPoolName();
        dbName = org.apache.commons.lang3.StringUtils.substringAfter((String)dbName, (String)"-");
        final String sqlId = String.valueOf(UniqueID.getUniqueID());
        final HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", sqlId);
        dataMap.put("ip", ip);
        dataMap.put("port", port);
        dataMap.put("username", user);
        dataMap.put("password", password);
        dataMap.put("dbCode", ip + "-" + dbName);
        dataMap.put("databaseName", dbName);
        dataMap.put("methodName", methodName);
        dataMap.put("slowSql", sql);
        dataMap.put("execTime", String.valueOf(execTime));
        dataMap.put("createDate", DateTimeFormatUtil.toDateTime(new Date()));
        stringRedisTemplate = (StringRedisTemplate)SpringContext.getBean(StringRedisTemplate.class, null);
        List list = (List)stringRedisTemplate.execute((SessionCallback)new SessionCallback<List<Object>>(){

            public List<Object> execute(RedisOperations operations) throws DataAccessException {
                operations.multi();
                operations.boundListOps((Object)"slowsql:queue").leftPush((Object)sqlId);
                operations.boundHashOps((Object)("slowsql:" + sqlId)).putAll(dataMap);
                operations.expire((Object)("slowsql:" + sqlId), 48L, TimeUnit.HOURS);
                return operations.exec();
            }
        });
    }

    private static List<String> getAllTableNameBySQL(String sql) {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLStatement sqlStatement = parser.parseStatement();
        MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
        sqlStatement.accept((SQLASTVisitor)visitor);
        Map tables = visitor.getTables();
        ArrayList<String> allTableName = new ArrayList<String>();
        for (TableStat.Name t : tables.keySet()) {
            allTableName.add(t.getName());
        }
        return allTableName;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dbType = properties.getProperty("dbType");
        if (dbType == null || dbType.equals("")) {
            this.setDbType("mysql");
        } else {
            this.setDbType(dbType);
        }
    }
}

