/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

public class SliceBase {
    private static Logger log = LoggerFactory.getLogger(SliceBase.class);
    public static final String FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    @Value(value="${use.base.slice:true}")
    private boolean useBaseSlice;
    public static final Map<String, String> ORGANIZATION_MAP = new ConcurrentHashMap<String, String>();
    public static final Map<String, String> COLLECTION_MAP = new ConcurrentHashMap<String, String>();
    @Autowired
    LettuceConnectionFactory lettuceConnectionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOrganizationMap(RedisConnection conn) {
        long beginTimeMillis = System.currentTimeMillis();
        try {
            Set zSet = conn.zRange("posshop:log:update".getBytes(), 0L, -1L);
            conn.openPipeline();
            Iterator iter = zSet.iterator();
            while (iter.hasNext()) {
                String organizationCode = new String((byte[])iter.next());
                String hashKey = String.format("posshop:log:%1$s", organizationCode);
                conn.hGetAll(hashKey.getBytes(StandardCharsets.UTF_8));
            }
            List resultList = conn.closePipeline();
            for (Object item : resultList) {
                Map dataMap = (Map)item;
                if (null == dataMap.get("organizationCode".getBytes(StandardCharsets.UTF_8)) || null == dataMap.get("splitCode".getBytes(StandardCharsets.UTF_8))) continue;
                String organizationCode = new String((byte[])dataMap.get("organizationCode".getBytes(StandardCharsets.UTF_8)));
                String splitCode = new String((byte[])dataMap.get("splitCode".getBytes(StandardCharsets.UTF_8)));
                if (!ORGANIZATION_MAP.containsKey(organizationCode)) {
                    ORGANIZATION_MAP.put(organizationCode, splitCode);
                    continue;
                }
                String k = ORGANIZATION_MAP.get(organizationCode);
                if (null == k || k.equals(splitCode)) continue;
                ORGANIZATION_MAP.put(organizationCode, splitCode);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (conn.isPipelined()) {
                    conn.closePipeline();
                }
                log.info(e.getMessage());
            }
            catch (Throwable throwable) {
                long endTimeMillis = System.currentTimeMillis();
                log.info(String.format("SliceBase.initOrganizationMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
                throw throwable;
            }
            long endTimeMillis = System.currentTimeMillis();
            log.info(String.format("SliceBase.initOrganizationMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
        }
        long endTimeMillis = System.currentTimeMillis();
        log.info(String.format("SliceBase.initOrganizationMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCollectionMap(RedisConnection conn) {
        long beginTimeMillis = System.currentTimeMillis();
        try {
            Set zSet = conn.zRange("collection:log:update".getBytes(StandardCharsets.UTF_8), 0L, -1L);
            conn.openPipeline();
            Iterator iter = zSet.iterator();
            while (iter.hasNext()) {
                String collectionName = new String((byte[])iter.next());
                String hashKey = String.format("collection:log:%1$s", collectionName);
                conn.hGetAll(hashKey.getBytes(StandardCharsets.UTF_8));
            }
            List resultList = conn.closePipeline();
            for (Object item : resultList) {
                Map dataMap = (Map)item;
                if (null == dataMap.get("collection".getBytes(StandardCharsets.UTF_8)) || null == dataMap.get("fieldname".getBytes(StandardCharsets.UTF_8))) continue;
                String collectionName = new String((byte[])dataMap.get("collection".getBytes(StandardCharsets.UTF_8)));
                String fieldname = new String((byte[])dataMap.get("fieldname".getBytes(StandardCharsets.UTF_8)));
                if (!COLLECTION_MAP.containsKey(collectionName)) {
                    COLLECTION_MAP.put(collectionName, fieldname);
                    continue;
                }
                String k = COLLECTION_MAP.get(collectionName);
                if (null == k || k.equals(fieldname)) continue;
                COLLECTION_MAP.put(collectionName, fieldname);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (conn.isPipelined()) {
                    conn.closePipeline();
                }
                log.info(e.getMessage());
            }
            catch (Throwable throwable) {
                long endTimeMillis = System.currentTimeMillis();
                log.info(String.format("SliceBase.initCollectionMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
                throw throwable;
            }
            long endTimeMillis = System.currentTimeMillis();
            log.info(String.format("SliceBase.initCollectionMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
        }
        long endTimeMillis = System.currentTimeMillis();
        log.info(String.format("SliceBase.initCollectionMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.useBaseSlice) {
            try (RedisConnection conn = this.getConnection(false);){
                long start = System.currentTimeMillis();
                this.initOrganizationMap(conn);
                this.initCollectionMap(conn);
                long end = System.currentTimeMillis();
                System.out.println("------------------------------->" + (end - start));
            }
            log.info("\u5206\u7247\u7801\u5b8c\u6210\u521d\u59cb\u5316\u5230\u5185\u5b58\u4e2d");
        }
    }

    public Map<String, String> getCollectionMap() {
        return COLLECTION_MAP;
    }

    public Map<String, String> getOrganizationMap() {
        return ORGANIZATION_MAP;
    }

    private RedisConnection getConnection(boolean enableTransactionSupport) {
        RedisConnection connection = this.lettuceConnectionFactory.getConnection();
        return connection;
    }

    public static boolean isTableWrapper(String tableName, String organizationCode) {
        if (ORGANIZATION_MAP.containsKey(organizationCode)) {
            Set<String> collectionSet = COLLECTION_MAP.keySet();
            for (String collectionName : collectionSet) {
                if (!tableName.equalsIgnoreCase(collectionName)) continue;
                return true;
            }
        }
        return false;
    }

    public SplitObject getPartionSplitObject(String collectionName, String organizationCode) {
        SplitObject splitObject = null;
        String tableName = collectionName.toLowerCase();
        if (SliceBase.isTableWrapper(tableName, organizationCode)) {
            splitObject = new SplitObject();
            String fieldName = COLLECTION_MAP.get(tableName);
            String splitCode = ORGANIZATION_MAP.get(organizationCode);
            splitObject.setFieldName(fieldName);
            splitObject.setSplitCode(splitCode);
            log.info(String.format("\u5206\u7247\u53f7-\u300b\u3010%1$s\u3011-----\u5206\u7247\u5b57\u6bb5-\u300b\u3010%2$s\u3011---\u95e8\u5e97\u53f7-\u300b\u3010%3$s\u3011", splitCode, fieldName, organizationCode));
        }
        return splitObject;
    }

    public String getPartionWhere(String collectionName, String organizationCode) {
        String partionKey = "";
        if (SliceBase.isTableWrapper(collectionName, organizationCode)) {
            partionKey = ORGANIZATION_MAP.get(organizationCode);
            log.debug(String.format("\u5206\u7247\u53f7-\u300b\u3010%1$s\u3011--------\u95e8\u5e97\u53f7-\u300b\u3010%2$s\u3011", partionKey, organizationCode));
        }
        return partionKey;
    }

    public static class SplitObject {
        private String splitCode;
        private String fieldName;

        public String getSplitCode() {
            return this.splitCode;
        }

        public void setSplitCode(String splitCode) {
            this.splitCode = splitCode;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toString() {
            return "SliceCode{splitCode='" + this.splitCode + "', fieldName='" + this.fieldName + "'}";
        }

        public String toSqlString() {
            return this.fieldName + "='" + this.splitCode + "'";
        }
    }
}

