/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter.standard;

import com.product.storage.slice.filter.standard.ExecutorSliceNewWrapper;
import com.product.util.SpringContext;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SliceBaseNew
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SliceBaseNew.class);
    public static final String FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    @Value(value="${use.base.slice:true}")
    private boolean useBaseSlice;
    @Value(value="${mybatisPath:classpath:mybatis-config.xml}")
    private String mybatisPath;
    public static final Map<String, String> ORGANIZATION_MAP = new ConcurrentHashMap<String, String>();
    public static final Map<String, String> COLLECTION_MAP = new ConcurrentHashMap<String, String>();
    public static final Map<String, String> RULE_MAP = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOrganizationMap(StringRedisTemplate stringRedisTemplate) {
        long beginTimeMillis = System.currentTimeMillis();
        try {
            Set keys = stringRedisTemplate.keys((Object)"dbslice:splitcodeconfig*");
            Map<String, Map> splitcodemap = SliceBaseNew.hgetAll(stringRedisTemplate, keys);
            for (String key : splitcodemap.keySet()) {
                String[] str = key.split(":");
                String fieldName = str[2];
                Map map = splitcodemap.get(key);
                if (!map.containsKey(fieldName) || !map.containsKey("splitCode")) continue;
                String fieldValue = map.get(fieldName).toString();
                String splitCode = map.get("splitCode").toString();
                ORGANIZATION_MAP.put(fieldName + ":" + fieldValue, splitCode);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                log.error(e.getMessage());
            }
            catch (Throwable throwable) {
                long endTimeMillis = System.currentTimeMillis();
                log.info(String.format("SliceBaseNew.initOrganizationMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
                throw throwable;
            }
            long endTimeMillis = System.currentTimeMillis();
            log.info(String.format("SliceBaseNew.initOrganizationMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
        }
        long endTimeMillis = System.currentTimeMillis();
        log.info(String.format("SliceBaseNew.initOrganizationMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCollectionMap(StringRedisTemplate stringRedisTemplate) {
        long beginTimeMillis = System.currentTimeMillis();
        try {
            Set keys = stringRedisTemplate.keys((Object)"dbslice:tableconfig*");
            Map<String, Map> tablemap = SliceBaseNew.hgetAll(stringRedisTemplate, keys);
            for (String key : tablemap.keySet()) {
                Map map = tablemap.get(key);
                if (!map.containsKey("collection")) continue;
                String tableName = map.get("collection").toString();
                if (map.containsKey("fieldname")) {
                    COLLECTION_MAP.put(tableName, map.get("fieldname").toString());
                }
                if (!map.containsKey("rule")) continue;
                RULE_MAP.put(tableName, map.get("rule").toString());
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                log.error(e.getMessage());
            }
            catch (Throwable throwable) {
                long endTimeMillis = System.currentTimeMillis();
                log.info(String.format("SliceBase.initCollectionMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
                throw throwable;
            }
            long endTimeMillis = System.currentTimeMillis();
            log.info(String.format("SliceBase.initCollectionMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
        }
        long endTimeMillis = System.currentTimeMillis();
        log.info(String.format("SliceBase.initCollectionMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", new SimpleDateFormat(FORMAT_PATTERN).format(new Date(beginTimeMillis)), new SimpleDateFormat(FORMAT_PATTERN).format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, new SimpleDateFormat(FORMAT_PATTERN).format(new Date())));
    }

    public Map<String, String> getCollectionMap() {
        return COLLECTION_MAP;
    }

    public Map<String, String> getOrganizationMap() {
        return ORGANIZATION_MAP;
    }

    public Map<String, String> getRuleMap() {
        return RULE_MAP;
    }

    public static boolean isTableWrapper(String tableName) {
        return RULE_MAP.containsKey(tableName) && COLLECTION_MAP.containsKey(tableName);
    }

    public void afterPropertiesSet() throws Exception {
        this.onRefreshSliceRedis();
    }

    public static Map<String, Map> hgetAll(StringRedisTemplate redisTemplate, Set<String> keys) {
        return (Map)redisTemplate.execute(con -> {
            Iterator it = keys.iterator();
            HashMap mapList = new HashMap();
            while (it.hasNext()) {
                String key = (String)it.next();
                Map result = con.hGetAll(key.getBytes());
                if (CollectionUtils.isEmpty((Map)result)) {
                    return new HashMap(0);
                }
                HashMap<String, String> ans = new HashMap<String, String>(result.size());
                for (Map.Entry entry : result.entrySet()) {
                    ans.put(new String((byte[])entry.getKey()), new String((byte[])entry.getValue()));
                }
                mapList.put(key, ans);
            }
            return mapList;
        });
    }

    @Scheduled(cron="0 02 * * * ?")
    public void onRefreshSliceRediTimer() {
        this.onRefreshSliceRedis();
    }

    public void onRefreshSliceRedis() {
        if (this.useBaseSlice && this.isSliceInterceptor().booleanValue()) {
            log.info("onRefreshSliceRedis------begin");
            StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringContext.getBean((String)"stringRedisTemplate", StringRedisTemplate.class);
            if (stringRedisTemplate != null) {
                this.initCollectionMap(stringRedisTemplate);
                this.initOrganizationMap(stringRedisTemplate);
                log.info("\u5206\u7247\u7801\u5b8c\u6210\u521d\u59cb\u5316\u5230\u5185\u5b58\u4e2d");
            }
            log.info("onRefreshSliceRedis------end");
        }
    }

    public Boolean isSliceInterceptor() {
        try {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            Resource resource = resourceLoader.getResource(this.mybatisPath);
            InputStream inputStream = resource.getInputStream();
            XMLConfigBuilder xmlConfigBuilder = new XMLConfigBuilder(inputStream);
            Configuration configuration = xmlConfigBuilder.parse();
            List interceptors = configuration.getInterceptors();
            for (Interceptor interceptor : interceptors) {
                if (!(interceptor instanceof ExecutorSliceNewWrapper)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static class SplitObject {
        private String splitCode;
        private String fieldName;
        private String splitField;
        private String splitFieldValue;

        public String getSplitCode() {
            return this.splitCode;
        }

        public void setSplitCode(String splitCode) {
            this.splitCode = splitCode;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getSplitField() {
            return this.splitField;
        }

        public void setSplitField(String splitField) {
            this.splitField = splitField;
        }

        public String getSplitFieldValue() {
            return this.splitFieldValue;
        }

        public void setSplitFieldValue(String splitFieldValue) {
            this.splitFieldValue = splitFieldValue;
        }

        public String toString() {
            return "SplitObject{splitCode='" + this.splitCode + "', fieldName='" + this.fieldName + "', splitField='" + this.splitField + "', splitFieldValue='" + this.splitFieldValue + "'}";
        }

        public String toSqlString() {
            return this.fieldName + "='" + this.splitCode + "'";
        }
    }
}

