/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class JsonValidator {
    private static CharacterIterator it;
    private static char c;
    private static int col;

    public static boolean validate(String input) {
        input = input.trim();
        boolean ret = JsonValidator.valid(input);
        return ret;
    }

    private static boolean valid(String input) {
        if ("".equals(input)) {
            return true;
        }
        boolean ret = true;
        it = new StringCharacterIterator(input);
        c = it.first();
        col = 1;
        if (!JsonValidator.value()) {
            ret = JsonValidator.error("value", 1);
        } else {
            JsonValidator.skipWhiteSpace();
            if (c != '\uffff') {
                ret = JsonValidator.error("end", col);
            }
        }
        return ret;
    }

    private static boolean value() {
        return JsonValidator.literal("true") || JsonValidator.literal("false") || JsonValidator.literal("null") || JsonValidator.string() || JsonValidator.number() || JsonValidator.object() || JsonValidator.array();
    }

    private static boolean literal(String text) {
        StringCharacterIterator ci = new StringCharacterIterator(text);
        char t = ci.first();
        if (c != t) {
            return false;
        }
        int start = col;
        boolean ret = true;
        t = ci.next();
        while (t != '\uffff') {
            if (t != JsonValidator.nextCharacter()) {
                ret = false;
                break;
            }
            t = ci.next();
        }
        JsonValidator.nextCharacter();
        if (!ret) {
            JsonValidator.error("literal " + text, start);
        }
        return ret;
    }

    private static boolean array() {
        return JsonValidator.aggregate('[', ']', false);
    }

    private static boolean object() {
        return JsonValidator.aggregate('{', '}', true);
    }

    private static boolean aggregate(char entryCharacter, char exitCharacter, boolean prefix) {
        if (c != entryCharacter) {
            return false;
        }
        JsonValidator.nextCharacter();
        JsonValidator.skipWhiteSpace();
        if (c == exitCharacter) {
            JsonValidator.nextCharacter();
            return true;
        }
        while (true) {
            if (prefix) {
                int start = col;
                if (!JsonValidator.string()) {
                    return JsonValidator.error("string", start);
                }
                JsonValidator.skipWhiteSpace();
                if (c != ':') {
                    return JsonValidator.error("colon", col);
                }
                JsonValidator.nextCharacter();
                JsonValidator.skipWhiteSpace();
            }
            if (JsonValidator.value()) {
                JsonValidator.skipWhiteSpace();
                if (c != ',') {
                    if (c == exitCharacter) break;
                    return JsonValidator.error("comma or " + exitCharacter, col);
                }
            } else {
                return JsonValidator.error("value", col);
            }
            JsonValidator.nextCharacter();
            JsonValidator.skipWhiteSpace();
        }
        JsonValidator.nextCharacter();
        return true;
    }

    private static boolean number() {
        if (!Character.isDigit(c) && c != '-') {
            return false;
        }
        int start = col;
        if (c == '-') {
            JsonValidator.nextCharacter();
        }
        if (c == '0') {
            JsonValidator.nextCharacter();
        } else if (Character.isDigit(c)) {
            while (Character.isDigit(c)) {
                JsonValidator.nextCharacter();
            }
        } else {
            return JsonValidator.error("number", start);
        }
        if (c == '.') {
            JsonValidator.nextCharacter();
            if (Character.isDigit(c)) {
                while (Character.isDigit(c)) {
                    JsonValidator.nextCharacter();
                }
            } else {
                return JsonValidator.error("number", start);
            }
        }
        if (c == 'e' || c == 'E') {
            JsonValidator.nextCharacter();
            if (c == '+' || c == '-') {
                JsonValidator.nextCharacter();
            }
            if (Character.isDigit(c)) {
                while (Character.isDigit(c)) {
                    JsonValidator.nextCharacter();
                }
            } else {
                return JsonValidator.error("number", start);
            }
        }
        return true;
    }

    private static boolean string() {
        if (c != '\"') {
            return false;
        }
        int start = col;
        boolean escaped = false;
        JsonValidator.nextCharacter();
        while (c != '\uffff') {
            if (!escaped && c == '\\') {
                escaped = true;
            } else if (escaped) {
                if (!JsonValidator.escape()) {
                    return false;
                }
                escaped = false;
            } else if (c == '\"') {
                JsonValidator.nextCharacter();
                return true;
            }
            JsonValidator.nextCharacter();
        }
        return JsonValidator.error("quoted string", start);
    }

    private static boolean escape() {
        int start = col - 1;
        if (" \\\"/bfnrtu".indexOf(c) < 0) {
            return JsonValidator.error("escape sequence  \\\",\\\\,\\/,\\b,\\f,\\n,\\r,\\t  or  \\uxxxx ", start);
        }
        if (!(c != 'u' || JsonValidator.ishex(JsonValidator.nextCharacter()) && JsonValidator.ishex(JsonValidator.nextCharacter()) && JsonValidator.ishex(JsonValidator.nextCharacter()) && JsonValidator.ishex(JsonValidator.nextCharacter()))) {
            return JsonValidator.error("unicode escape sequence  \\uxxxx ", start);
        }
        return true;
    }

    private static boolean ishex(char d) {
        return "0123456789abcdefABCDEF".indexOf(c) >= 0;
    }

    private static char nextCharacter() {
        c = it.next();
        ++col;
        return c;
    }

    private static void skipWhiteSpace() {
        while (Character.isWhitespace(c)) {
            JsonValidator.nextCharacter();
        }
    }

    private static boolean error(String type, int col) {
        System.out.printf("type: %s, col: %s%s", type, col, System.getProperty("line.separator"));
        return false;
    }
}

