/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.sysmonitor;

import java.io.File;
import java.net.URL;
import org.hyperic.sigar.Sigar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigarUtils {
    public static Sigar sigar = null;
    private static final Logger Log = LoggerFactory.getLogger(SigarUtils.class);

    static Sigar initSigar() {
        try {
            if (sigar == null) {
                URL uri = SigarUtils.class.getResource("/");
                String filePath = uri.toString().substring(5) + "sigar";
                File classPath = new File(filePath);
                Log.info("... sigar classPath = " + classPath.getAbsolutePath());
                String path = System.getProperty("java.library.path");
                String sigarLibPath = classPath.getCanonicalPath();
                if (!path.contains(sigarLibPath)) {
                    path = SigarUtils.isOSWin() ? path + ";" + sigarLibPath : path + ":" + sigarLibPath;
                    System.setProperty("java.library.path", path);
                }
                sigar = new Sigar();
                Log.info("... java.library.path: " + System.getProperty("java.library.path"));
                Log.info("... sigar  ini success ");
            }
            return sigar;
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
            return null;
        }
    }

    public static boolean isOSWin() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.indexOf("win") >= 0;
    }
}

