/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.redis;

import java.time.Duration;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.lang.Nullable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;

public class BaseJedisConnectionFactory
extends JedisConnectionFactory {
    private String host;
    private Integer port;
    private Integer timeout;
    private String password;

    public BaseJedisConnectionFactory() {
    }

    public BaseJedisConnectionFactory(RedisSentinelConfiguration sentinelConfiguration, JedisPoolConfig poolConfiguration) {
        super(sentinelConfiguration, poolConfiguration);
        this.host = sentinelConfiguration.getMaster().getName();
        this.port = 0;
        this.timeout = 0;
        this.password = sentinelConfiguration.getPassword().toString();
    }

    public BaseJedisConnectionFactory(RedisClusterConfiguration redisClusterConfiguration, JedisPoolConfig poolConfiguration) {
        super(redisClusterConfiguration, poolConfiguration);
    }

    public BaseJedisConnectionFactory(RedisStandaloneConfiguration redisStandaloneConfiguration) {
        super(redisStandaloneConfiguration);
        this.host = redisStandaloneConfiguration.getHostName();
        this.port = redisStandaloneConfiguration.getPort();
        this.timeout = 0;
        this.password = redisStandaloneConfiguration.getPassword().toString();
    }

    public BaseJedisConnectionFactory(RedisStandaloneConfiguration redisStandaloneConfiguration, JedisClientConfiguration clientConfig) {
        super(redisStandaloneConfiguration, clientConfig);
        this.host = redisStandaloneConfiguration.getHostName();
        this.port = redisStandaloneConfiguration.getPort();
        this.timeout = 0;
        this.password = redisStandaloneConfiguration.getPassword().toString();
    }

    public Jedis getJedis() {
        return super.fetchJedisConnector();
    }

    public String getJedisPoolInfo() {
        return String.format("host=%1$s port=%2$d timeout=%3$d password=%4$s", this.host, this.port, this.timeout, this.password);
    }

    public static class StandaloneJedisClientConfiguration
    implements JedisClientConfiguration {
        private boolean useSsl;
        @Nullable
        private SSLSocketFactory sslSocketFactory;
        @Nullable
        private SSLParameters sslParameters;
        @Nullable
        private HostnameVerifier hostnameVerifier;
        private boolean usePooling = true;
        private GenericObjectPoolConfig poolConfig = new JedisPoolConfig();
        @Nullable
        private String clientName;
        private Duration readTimeout = Duration.ofMillis(2000L);
        private Duration connectTimeout = Duration.ofMillis(2000L);

        public static JedisClientConfiguration create(GenericObjectPoolConfig jedisPoolConfig) {
            StandaloneJedisClientConfiguration configuration = new StandaloneJedisClientConfiguration();
            configuration.setPoolConfig(jedisPoolConfig);
            return configuration;
        }

        public boolean isUseSsl() {
            return this.useSsl;
        }

        public void setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
        }

        public Optional<SSLSocketFactory> getSslSocketFactory() {
            return Optional.ofNullable(this.sslSocketFactory);
        }

        public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }

        public Optional<SSLParameters> getSslParameters() {
            return Optional.ofNullable(this.sslParameters);
        }

        public void setSslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
        }

        public Optional<HostnameVerifier> getHostnameVerifier() {
            return Optional.ofNullable(this.hostnameVerifier);
        }

        public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        public boolean isUsePooling() {
            return this.usePooling;
        }

        public void setUsePooling(boolean usePooling) {
            this.usePooling = usePooling;
        }

        public Optional<GenericObjectPoolConfig> getPoolConfig() {
            return Optional.ofNullable(this.poolConfig);
        }

        public void setPoolConfig(GenericObjectPoolConfig poolConfig) {
            this.poolConfig = poolConfig;
        }

        public Optional<String> getClientName() {
            return Optional.ofNullable(this.clientName);
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }
    }
}

