/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.redis.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.redis.constant.RedisConstant;
import com.efuture.redis.util.DateUtils;
import com.efuture.redis.util.ListUtils;
import com.efuture.redis.util.LuaUtil;
import com.efuture.sysmonitor.SysMonitorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import redis.clients.jedis.resps.Slowlog;

public class RedisClient {
    private final Logger logger = LoggerFactory.getLogger(RedisClient.class);
    private StringRedisTemplate stringRedisTemplate;
    private HashOperations<String, String, String> opsForHash;
    private ZSetOperations<String, String> opsForZSet;
    private SetOperations<String, String> opsForSet;
    private ValueOperations<String, String> opsForValue;
    private ListOperations<String, String> opsForList;
    private String itemName = null;
    private String redisInfo = "";

    public RedisClient(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.opsForHash = stringRedisTemplate.opsForHash();
        this.opsForZSet = stringRedisTemplate.opsForZSet();
        this.opsForSet = stringRedisTemplate.opsForSet();
        this.opsForValue = stringRedisTemplate.opsForValue();
        this.opsForList = stringRedisTemplate.opsForList();
    }

    public void setKeyExpire(RedisOperations<String, Object> operations, String tableName, Map<String, Object> dataRow, List<String> indexFields, String hashKey, String zsetKey, int seconds) {
        operations.expire((Object)hashKey, (long)seconds, TimeUnit.SECONDS);
        operations.expire((Object)zsetKey, (long)seconds, TimeUnit.SECONDS);
        if (indexFields != null) {
            for (int i = 0; i < indexFields.size(); ++i) {
                String indexKey = tableName + ":" + indexFields.get(i) + ":" + dataRow.get(indexFields.get(i));
                operations.expire((Object)indexKey, (long)seconds, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> onRowInsert(final long entId, final String tableName, final Map<String, Object> dataRow, final String primaryKey, final List<String> indexFields, final int seconds) {
        long startTime = System.currentTimeMillis();
        String code = "0";
        Object error = "";
        List results = null;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            if (primaryKey == null || "".equals(primaryKey)) {
                throw new Exception("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (indexFields != null && ListUtils.checkIsEmpty(indexFields)) {
                throw new Exception("\u7d22\u5f15\u5b57\u6bb5\u4e2d\u5305\u542b\u7a7a\u6709null\u6570\u636e\u548c\u7a7a\u5b57\u7b26\u4e32\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\uff01");
            }
            for (Map.Entry<String, Object> entry : dataRow.entrySet()) {
                if (null == entry.getValue()) {
                    entry.setValue("");
                    continue;
                }
                entry.setValue(entry.getValue().toString());
            }
            results = (List)this.stringRedisTemplate.execute((SessionCallback)new SessionCallback<List<Object>>(){

                public List<Object> execute(RedisOperations operations) throws DataAccessException {
                    operations.multi();
                    String hashKey = String.format("%1$s:%2$s", entId + ":" + tableName, primaryKey);
                    operations.opsForHash().putAll((Object)hashKey, dataRow);
                    long stampTime = DateUtils.getCurrentTimeStamps();
                    String zsetKey = entId + ":" + tableName;
                    operations.opsForZSet().add((Object)zsetKey, (Object)primaryKey, (double)stampTime);
                    if (indexFields != null) {
                        for (int i = 0; i < indexFields.size(); ++i) {
                            String indexKey = entId + ":" + tableName + ":" + (String)indexFields.get(i) + ":" + dataRow.get(indexFields.get(i));
                            operations.opsForSet().add((Object)indexKey, new Object[]{primaryKey});
                        }
                    }
                    operations.opsForSet().add((Object)"redis_table", new Object[]{entId + ":" + tableName});
                    if (seconds > 0) {
                        RedisClient.this.setKeyExpire((RedisOperations<String, Object>)operations, entId + ":" + tableName, dataRow, indexFields, hashKey, zsetKey, seconds);
                    }
                    return operations.exec();
                }
            });
            this.logger.info("...  insertData transaction result: " + results.toString());
            if (CollectionUtils.isEmpty((Collection)results)) {
                error = "redis\u6267\u884c\u4e8b\u52a1\u5f02\u5e38!";
                code = "-1";
            } else {
                if (!results.get(0).equals("OK")) {
                    error = entId + ":" + tableName + ":" + primaryKey + "--\u4e1a\u52a1\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01";
                    code = "-1";
                }
                if (!(results.get(1) instanceof Long)) {
                    error = "".equals(error) ? entId + ":" + tableName + ":" + primaryKey + "--\u65f6\u95f4\u6233\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01" : (String)error + "||" + entId + ":" + tableName + ":" + primaryKey + "--\u65f6\u95f4\u6233\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01";
                    code = "-1";
                }
                if (indexFields != null) {
                    for (int i = 0; i < indexFields.size(); ++i) {
                        if (results.get(2 + i) instanceof Long) continue;
                        error = "".equals(error) ? entId + ":" + tableName + ":" + primaryKey + "--redis\u7d22\u5f15\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01" : (String)error + "||" + entId + ":" + tableName + ":" + primaryKey + "--redis\u7d22\u5f15\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01";
                        code = "-1";
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(entId + ":" + tableName + ":" + primaryKey + "insertData\u6267\u884c\u5f02\u5e38------errorMessage:" + e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            error = e.getMessage();
            code = "-1";
        }
        finally {
            resultMap.put("code", code);
            resultMap.put("error", (String)error);
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("onRowInsert\u6267\u884c\u65f6\u95f4\u3010{}\u3011", (Object)(endTime - startTime));
        if (code == "-1" || endTime - startTime > 1000L) {
            try {
                String slowLog = this.getSlowLog(this.stringRedisTemplate, System.currentTimeMillis());
                this.redisInfo = this.getRedisInfo(this.stringRedisTemplate, System.currentTimeMillis());
                SysMonitorUtils.logRedisInfo((String)this.redisInfo, (String)slowLog);
                SysMonitorUtils.logSystemInfo();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> onRowUpsert(final long entId, final String tableName, final Map<String, Object> updateRow, Map<String, Object> insertRow, final String primaryKey, final List<String> indexFields, final int seconds) {
        HashMap<String, String> resultMap;
        String code;
        long startTime;
        block21: {
            startTime = System.currentTimeMillis();
            code = "0";
            Object error = "";
            List results = null;
            resultMap = new HashMap<String, String>();
            try {
                if (primaryKey == null || "".equals(primaryKey)) {
                    throw new Exception("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (indexFields != null && ListUtils.checkIsEmpty(indexFields)) {
                    throw new Exception("\u7d22\u5f15\u5b57\u6bb5\u4e2d\u5305\u542b\u7a7a\u6709null\u6570\u636e\u548c\u7a7a\u5b57\u7b26\u4e32\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\uff01");
                }
                for (Map.Entry<String, Object> entry : updateRow.entrySet()) {
                    if (null == entry.getValue()) {
                        entry.setValue("");
                        continue;
                    }
                    entry.setValue(entry.getValue().toString());
                }
                final Map data = this.opsForHash.entries((Object)(entId + ":" + tableName + ":" + primaryKey));
                if (data == null) {
                    for (Map.Entry entry : insertRow.entrySet()) {
                        if (null == entry.getValue()) {
                            updateRow.put((String)entry.getKey(), "");
                            continue;
                        }
                        updateRow.put((String)entry.getKey(), entry.getValue().toString());
                    }
                }
                results = (List)this.stringRedisTemplate.execute((SessionCallback)new SessionCallback<List<Object>>(){

                    public List<Object> execute(RedisOperations operations) throws DataAccessException {
                        operations.multi();
                        String hashKey = entId + ":" + tableName + ":" + primaryKey;
                        operations.opsForHash().putAll((Object)hashKey, updateRow);
                        long stampTime = DateUtils.getCurrentTimeStamps();
                        String zsetKey = entId + ":" + tableName;
                        operations.opsForZSet().add((Object)zsetKey, (Object)primaryKey, (double)stampTime);
                        if (indexFields != null) {
                            for (int i = 0; i < indexFields.size(); ++i) {
                                if (data != null) {
                                    operations.opsForSet().remove((Object)(entId + ":" + tableName + ":" + (String)indexFields.get(i) + ":" + (String)data.get(indexFields.get(i))), new Object[]{primaryKey});
                                }
                                String indexKey = entId + ":" + tableName + ":" + (String)indexFields.get(i) + ":" + updateRow.get(indexFields.get(i));
                                operations.opsForSet().add((Object)indexKey, new Object[]{primaryKey});
                            }
                        }
                        operations.opsForSet().add((Object)"redis_table", new Object[]{entId + ":" + tableName});
                        if (seconds > 0) {
                            RedisClient.this.setKeyExpire((RedisOperations<String, Object>)operations, entId + ":" + tableName, updateRow, indexFields, hashKey, zsetKey, seconds);
                        }
                        return operations.exec();
                    }
                });
                this.logger.info("...  updateData transaction result: " + results.toString());
                if (CollectionUtils.isEmpty((Collection)results)) {
                    error = "redis\u6267\u884c\u4e8b\u52a1\u5f02\u5e38!";
                    code = "-1";
                } else {
                    if (!results.get(0).equals("OK")) {
                        error = entId + ":" + tableName + ":" + primaryKey + "--\u4e1a\u52a1\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01";
                        code = "-1";
                    }
                    if (!(results.get(1) instanceof Long)) {
                        error = "".equals(error) ? entId + ":" + tableName + ":" + primaryKey + "--\u65f6\u95f4\u6233\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01" : (String)error + "||" + entId + ":" + tableName + ":" + primaryKey + "--\u65f6\u95f4\u6233\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01";
                        code = "-1";
                    }
                    if (indexFields != null) {
                        for (int i = 0; i < indexFields.size() * 2; ++i) {
                            if (results.get(2 + i) instanceof Long) continue;
                            error = "".equals(error) ? entId + ":" + tableName + ":" + primaryKey + "--redis\u7d22\u5f15\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01" : (String)error + "||" + entId + ":" + tableName + ":" + primaryKey + "--redis\u7d22\u5f15\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01";
                            code = "-1";
                        }
                    }
                }
                resultMap.put("code", code);
            }
            catch (Exception e) {
                this.logger.error(entId + ":" + tableName + ":" + primaryKey + "updateData\u6267\u884c\u5f02\u5e38------errorMessage:" + e.getMessage());
                this.logger.error(e.getMessage(), (Throwable)e);
                error = e.getMessage();
                code = "-1";
                break block21;
            }
            finally {
                resultMap.put("code", code);
                resultMap.put("error", (String)error);
            }
            resultMap.put("error", (String)error);
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("onRowUpsert\u6267\u884c\u65f6\u95f4\u3010{}\u3011", (Object)(endTime - startTime));
        if (code == "-1" || endTime - startTime > 1000L) {
            try {
                String string = this.getSlowLog(this.stringRedisTemplate, System.currentTimeMillis());
                this.redisInfo = this.getRedisInfo(this.stringRedisTemplate, System.currentTimeMillis());
                SysMonitorUtils.logRedisInfo((String)this.redisInfo, (String)string);
                SysMonitorUtils.logSystemInfo();
            }
            catch (Exception exception) {
                this.logger.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> onRowDelete(final long entId, final String tableName, final String primaryKey, final List<String> indexFields) {
        HashMap<String, String> resultMap;
        String code;
        long startTime;
        block14: {
            startTime = System.currentTimeMillis();
            code = "0";
            Object error = "";
            List results = null;
            resultMap = new HashMap<String, String>();
            try {
                if (primaryKey == null || "".equals(primaryKey)) {
                    throw new Exception("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (indexFields != null && ListUtils.checkIsEmpty(indexFields)) {
                    throw new Exception("\u7d22\u5f15\u5b57\u6bb5\u4e2d\u5305\u542b\u7a7a\u6709null\u6570\u636e\u548c\u7a7a\u5b57\u7b26\u4e32\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\uff01");
                }
                final Map data = this.opsForHash.entries((Object)(entId + ":" + tableName + ":" + primaryKey));
                results = (List)this.stringRedisTemplate.execute((SessionCallback)new SessionCallback<List<Object>>(){

                    public List<Object> execute(RedisOperations operations) throws DataAccessException {
                        operations.multi();
                        operations.delete((Object)(entId + ":" + tableName + ":" + primaryKey));
                        operations.opsForZSet().remove((Object)(entId + ":" + tableName), new Object[]{primaryKey});
                        if (indexFields != null) {
                            for (int i = 0; i < indexFields.size(); ++i) {
                                if (data == null) continue;
                                String columnKey = entId + ":" + tableName + ":" + (String)indexFields.get(i) + ":" + (String)data.get(indexFields.get(i));
                                operations.opsForSet().remove((Object)columnKey, new Object[]{primaryKey});
                            }
                        }
                        operations.opsForSet().remove((Object)"redis_table", new Object[]{entId + ":" + tableName});
                        return operations.exec();
                    }
                });
                this.logger.info("...  deleteData transaction result: " + results.toString());
                if (CollectionUtils.isEmpty((Collection)results)) {
                    error = "redis\u6267\u884c\u4e8b\u52a1\u5f02\u5e38!";
                    code = "-1";
                } else {
                    if (!(results.get(0) instanceof Long)) {
                        error = entId + ":" + tableName + ":" + primaryKey + "--\u4e1a\u52a1\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01";
                        code = "-1";
                    }
                    if (!(results.get(1) instanceof Long)) {
                        error = "".equals(error) ? entId + ":" + tableName + ":" + primaryKey + "--\u65f6\u95f4\u6233\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01" : (String)error + "||" + entId + ":" + tableName + ":" + primaryKey + "--\u65f6\u95f4\u6233\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01";
                        code = "-1";
                    }
                    if (indexFields != null) {
                        for (int i = 0; i < indexFields.size(); ++i) {
                            if (results.get(2 + i) instanceof Long) continue;
                            error = "".equals(error) ? entId + ":" + tableName + ":" + primaryKey + "--redis\u7d22\u5f15\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01" : (String)error + "||" + entId + ":" + tableName + ":" + primaryKey + "--redis\u7d22\u5f15\u6570\u636e\u64cd\u4f5c\u5931\u8d25, \u8bf7\u91cd\u8bd5\u4e00\u6b21, \u8d85\u8fc7\u4e09\u6b21\u8bf7\u8054\u7cfbredis\u7ba1\u7406\u5458\uff01";
                            code = "-1";
                        }
                    }
                }
                resultMap.put("code", code);
            }
            catch (Exception e) {
                this.logger.error(entId + ":" + tableName + ":" + primaryKey + "deleteData\u6267\u884c\u5f02\u5e38------errorMessage:" + e.getMessage());
                this.logger.error(e.getMessage(), (Throwable)e);
                error = e.getMessage();
                code = "-1";
                break block14;
            }
            finally {
                resultMap.put("code", code);
                resultMap.put("error", (String)error);
            }
            resultMap.put("error", (String)error);
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("onRowDelete\u6267\u884c\u65f6\u95f4\u3010{}\u3011", (Object)(endTime - startTime));
        if (code == "-1") {
            SysMonitorUtils.logSystemInfo();
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> onQueryById(long entId, String tableName, String id) {
        String error = null;
        long startTime = System.currentTimeMillis();
        HashMap<String, String> dataMap = new HashMap();
        try {
            dataMap = this.opsForHash.entries((Object)(entId + ":" + tableName + ":" + id));
        }
        catch (Exception e) {
            this.logger.info(entId + ":" + tableName + ":" + id + " ----queryDataById\u6267\u884c\u5f02\u5e38, errorMessage:" + e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            error = e.getMessage();
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.stringRedisTemplate.getConnectionFactory());
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("onQueryById\u6267\u884c\u65f6\u95f4\u3010{}\u3011", (Object)(endTime - startTime));
        if (endTime - startTime > 1000L) {
            try {
                String slowLog = this.getSlowLog(this.stringRedisTemplate, System.currentTimeMillis());
                this.redisInfo = this.getRedisInfo(this.stringRedisTemplate, System.currentTimeMillis());
                SysMonitorUtils.logRedisInfo((String)this.redisInfo, (String)slowLog);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> onQueryByIdList(final long entId, final String tableName, final List<String> ids) {
        String error = null;
        long startTime = System.currentTimeMillis();
        List<Object> dataList = new ArrayList();
        try {
            if (ids.size() > 1) {
                dataList = this.stringRedisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

                    public Object doInRedis(RedisConnection connection) throws DataAccessException {
                        StringRedisConnection stringRedisConn = (StringRedisConnection)connection;
                        for (String id : ids) {
                            String key = entId + ":" + tableName + ":" + id;
                            stringRedisConn.hGetAll(key);
                        }
                        return null;
                    }
                });
            } else if (ids.size() == 1) {
                String id = ids.get(0);
                Map map = this.opsForHash.entries((Object)(entId + ":" + tableName + ":" + id));
                dataList.add(map);
            }
        }
        catch (Exception e) {
            this.logger.info(entId + ":" + tableName + ":" + ids + " ----onQueryByIdList1\u6267\u884c\u5f02\u5e38, errorMessage:" + e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            error = e.getMessage();
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.stringRedisTemplate.getConnectionFactory());
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("onQueryByIdList\u6267\u884c\u65f6\u95f4\u3010{}\u3011", (Object)(endTime - startTime));
        if (error != null || endTime - startTime > 1000L) {
            try {
                String slowLog = this.getSlowLog(this.stringRedisTemplate, System.currentTimeMillis());
                this.redisInfo = this.getRedisInfo(this.stringRedisTemplate, System.currentTimeMillis());
                SysMonitorUtils.logRedisInfo((String)this.redisInfo, (String)slowLog);
                SysMonitorUtils.logSystemInfo();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> onQueryPage(long entId, String tableName, int start, int count, RedisConstant.Sort sort) {
        String error = null;
        long startTime = System.currentTimeMillis();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            Set set = new HashSet();
            int stop = --start + count - 1;
            set = sort == RedisConstant.Sort.asc ? this.opsForZSet.range((Object)(entId + ":" + tableName), (long)start, (long)stop) : this.opsForZSet.reverseRange((Object)(entId + ":" + tableName), (long)start, (long)stop);
            if (set.size() > 0) {
                for (String id : set) {
                    Map map = this.opsForHash.entries((Object)(entId + ":" + tableName + ":" + id));
                    list.add(map);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("onQueryPage\u6267\u884c\u5f02\u5e38, \u67e5\u8be2\u6761\u4ef6: sort--" + sort + ",start--" + start + ",count--" + count + ", tableName--" + entId + ":" + tableName);
            this.logger.error(e.getMessage(), (Throwable)e);
            error = e.getMessage();
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.stringRedisTemplate.getConnectionFactory());
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("onQueryPage\u6267\u884c\u65f6\u95f4\u3010{}\u3011", (Object)(endTime - startTime));
        if (endTime - startTime > 1000L) {
            try {
                String slowLog = this.getSlowLog(this.stringRedisTemplate, System.currentTimeMillis());
                this.redisInfo = this.getRedisInfo(this.stringRedisTemplate, System.currentTimeMillis());
                SysMonitorUtils.logRedisInfo((String)this.redisInfo, (String)slowLog);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> onQueryPageByCondition(long entId, RedisConstant.Sort sort, String itemName, int start, int count, String query, List<String> otherKeys) {
        String error = null;
        long startTime = System.currentTimeMillis();
        ArrayList<String> result = new ArrayList();
        try {
            String temp_store_key = "tmpinstore:" + UUID.randomUUID().toString();
            this.opsForSet.intersectAndStore((Object)query, otherKeys, (Object)temp_store_key);
            if (count <= 0) {
                count = 500;
            }
            SortQuery<String> sortQuery = LuaUtil.getSortQuery(temp_store_key, null, sort, start, count);
            result = this.stringRedisTemplate.sort(sortQuery);
            this.stringRedisTemplate.delete((Object)temp_store_key);
        }
        catch (Exception e) {
            result = null;
            this.logger.error("queryByCondition\u6267\u884c\u5f02\u5e38, \u67e5\u8be2\u6761\u4ef6: sort--" + sort + ",itemName--" + itemName + ",start--" + start + ",count--" + count + ",qurey--" + query + ",otherKeys" + otherKeys.toString());
            this.logger.error(e.getMessage(), (Throwable)e);
            error = e.getMessage();
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.stringRedisTemplate.getConnectionFactory());
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("onQueryPageByCondition\u6267\u884c\u65f6\u95f4\u3010{}\u3011", (Object)(endTime - startTime));
        if (endTime - startTime > 1000L) {
            try {
                String slowLog = this.getSlowLog(this.stringRedisTemplate, System.currentTimeMillis());
                this.redisInfo = this.getRedisInfo(this.stringRedisTemplate, System.currentTimeMillis());
                SysMonitorUtils.logRedisInfo((String)this.redisInfo, (String)slowLog);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long onCount(long entId, String itemName, String query, List<String> otherKeys) {
        String error = null;
        long startTime = System.currentTimeMillis();
        Long response = 0L;
        try {
            String temp_store_key = "tmpinstore:" + UUID.randomUUID().toString();
            response = this.opsForSet.intersectAndStore((Object)query, otherKeys, (Object)temp_store_key);
            this.stringRedisTemplate.delete((Object)temp_store_key);
        }
        catch (Exception e) {
            this.logger.error("onCount\u6267\u884c\u5f02\u5e38, \u67e5\u8be2\u6761\u4ef6: query--" + query + ",otherKeys--" + otherKeys.toString());
            this.logger.error(e.getMessage(), (Throwable)e);
            error = e.getMessage();
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.stringRedisTemplate.getConnectionFactory());
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("onCount\u6267\u884c\u65f6\u95f4\u3010{}\u3011", (Object)(endTime - startTime));
        if (endTime - startTime > 1000L) {
            try {
                String slowLog = this.getSlowLog(this.stringRedisTemplate, System.currentTimeMillis());
                this.redisInfo = this.getRedisInfo(this.stringRedisTemplate, System.currentTimeMillis());
                SysMonitorUtils.logRedisInfo((String)this.redisInfo, (String)slowLog);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return response;
    }

    public boolean isTableExists(long entId, String tableName) {
        boolean isExists = true;
        long count = this.opsForZSet.size((Object)(entId + ":" + tableName));
        if (count == 0L) {
            isExists = false;
        }
        return isExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> onQueryIdsByLua(long entId, String tableName, List<String> fieldList, List<String> operatorList, List<Object> argslist) {
        String error = null;
        long startTime = System.currentTimeMillis();
        String script = LuaUtil.createLuaScript(entId + ":" + tableName, fieldList, operatorList, argslist);
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText(script);
        redisScript.setResultType(List.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        List resultIds = null;
        try {
            resultIds = (List)this.stringRedisTemplate.execute((RedisScript)redisScript, list, new Object[]{""});
        }
        catch (Exception e) {
            this.logger.error("onQueryIdsByLua\u6267\u884c\u5f02\u5e38...");
            this.logger.error(e.getMessage(), (Throwable)e);
            error = e.getMessage();
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.stringRedisTemplate.getConnectionFactory());
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("onQueryIdsByLua\u6267\u884c\u65f6\u95f4\u3010{}\u3011", (Object)(endTime - startTime));
        if (endTime - startTime > 1000L) {
            try {
                String slowLog = this.getSlowLog(this.stringRedisTemplate, System.currentTimeMillis());
                this.redisInfo = this.getRedisInfo(this.stringRedisTemplate, System.currentTimeMillis());
                SysMonitorUtils.logRedisInfo((String)this.redisInfo, (String)slowLog);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return resultIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedisInfo(StringRedisTemplate stringRedisTemplate, long startTime) {
        try {
            this.redisInfo = String.valueOf(stringRedisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public String doInRedis(RedisConnection connection) throws DataAccessException {
                    StringRedisConnection stringRedisConn = (StringRedisConnection)connection;
                    RedisClient.this.redisInfo = JSONObject.toJSONString((Object)stringRedisConn.info());
                    return RedisClient.this.redisInfo;
                }
            }));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)stringRedisTemplate.getConnectionFactory());
        }
        this.logger.info("get redisInfo\u3010{}\u3011", (Object)(System.currentTimeMillis() - startTime));
        return this.redisInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSlowLog(StringRedisTemplate stringRedisTemplate, long startTime) {
        String slowLog = "";
        try {
            slowLog = String.valueOf(stringRedisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public String doInRedis(RedisConnection connection) throws DataAccessException {
                    StringRedisConnection stringRedisConn = (StringRedisConnection)connection;
                    Object object = stringRedisConn.execute("SLOWLOG", new String[]{"GET", "10"});
                    List objectList = (List)object;
                    if (null == objectList || objectList.isEmpty()) {
                        return "";
                    }
                    List result = Slowlog.from((List)objectList);
                    return JSONObject.toJSONString((Object)result);
                }
            }));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)stringRedisTemplate.getConnectionFactory());
        }
        this.logger.info("get getSlowLog\u3010{}\u3011", (Object)(System.currentTimeMillis() - startTime));
        return slowLog;
    }
}

