/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.print.yilianyun;

import com.alibaba.fastjson.JSON;
import com.shiji.common.ChannelDJPrintDataHandler;
import com.shiji.common.ChannelprintrespmappingModel;
import com.shiji.common.RequestCommon;
import com.shiji.common.ResponseCommon;
import com.shiji.common.print.request.AddPrintReq;
import com.shiji.common.print.request.AddPrintReqData;
import com.shiji.common.print.request.DeletePrintReq;
import com.shiji.common.print.request.DeletePrintReqData;
import com.shiji.common.print.request.GetPrintStatusReq;
import com.shiji.common.print.request.GetPrintStatusReqData;
import com.shiji.common.print.request.SendModelPrintReq;
import com.shiji.common.print.request.SendModelPrintReqData;
import com.shiji.common.print.request.SetSoundReq;
import com.shiji.common.print.request.SetSoundReqData;
import com.shiji.common.print.response.AddPrintRespData;
import com.shiji.common.print.response.DeletePrintRespData;
import com.shiji.common.print.response.GetPrintStatusRespData;
import com.shiji.common.print.response.SendModelPrintRespData;
import com.shiji.common.print.response.SetSoundRespData;
import com.shiji.print.yilianyun.model.YlyAddPrintResModel;
import com.shiji.print.yilianyun.model.YlyAuthParam;
import com.shiji.print.yilianyun.model.YlyDeletePrintResModel;
import com.shiji.print.yilianyun.model.YlyGetPrintStatusResModel;
import com.shiji.print.yilianyun.model.YlySendModelPrintResModel;
import com.shiji.print.yilianyun.utils.YlyUtil;
import com.yly.java.yly_sdk.RequestMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YiLianYunChannelDJPrintDataAPIImpl
implements ChannelDJPrintDataHandler {
    private static final Logger log = LoggerFactory.getLogger(YiLianYunChannelDJPrintDataAPIImpl.class);

    public ResponseCommon<GetPrintStatusRespData> getPrintStatus(GetPrintStatusReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        GetPrintStatusRespData respData = new GetPrintStatusRespData();
        YlyAuthParam authParam = YlyUtil.getAuthParam((RequestCommon)req);
        GetPrintStatusReqData reqData = (GetPrintStatusReqData)req.getReqData();
        try {
            log.info("Yly_Request ---> " + reqData.getDeviceID());
            String strRes = RequestMethod.getInstance().printerGetPrintStatus(authParam.getAccessToken(), reqData.getDeviceID());
            YlyGetPrintStatusResModel resModel = (YlyGetPrintStatusResModel)JSON.parseObject((String)strRes, YlyGetPrintStatusResModel.class);
            log.info("Yly_Response ---> requestResult " + strRes);
            if (resModel.getError().equals("0")) {
                if (resModel.getBody().getState().equals("1")) {
                    respData.setOnline(1);
                    respData.setStatus(1);
                } else if (resModel.getBody().getState().equals("0")) {
                    respData.setOnline(0);
                    respData.setStatus(3);
                } else if (resModel.getBody().getState().equals("2")) {
                    respData.setOnline(1);
                    respData.setStatus(2);
                }
            } else {
                return ResponseCommon.fail((String)"50000", (String)resModel.getError_description());
            }
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }

    public ResponseCommon<AddPrintRespData> addPrint(AddPrintReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        AddPrintRespData respData = new AddPrintRespData();
        YlyAuthParam authParam = YlyUtil.getAuthParam((RequestCommon)req);
        AddPrintReqData reqData = (AddPrintReqData)req.getReqData();
        try {
            log.info("Yly_Request ---> " + reqData.getDeviceID());
            String strRes = RequestMethod.getInstance().addPrinter(reqData.getDeviceID(), reqData.getDeviceSecret(), authParam.getAccessToken(), "", reqData.getDevName());
            YlyAddPrintResModel resModel = (YlyAddPrintResModel)JSON.parseObject((String)strRes, YlyAddPrintResModel.class);
            log.info("Yly_Response ---> requestResult " + strRes);
            if (!resModel.getError().equals("0")) {
                return ResponseCommon.fail((String)"50000", (String)resModel.getError_description());
            }
            respData.setCode("1");
            respData.setMsg(resModel.getError_description());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }

    public ResponseCommon<DeletePrintRespData> deletePrint(DeletePrintReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        DeletePrintRespData respData = new DeletePrintRespData();
        YlyAuthParam authParam = YlyUtil.getAuthParam((RequestCommon)req);
        DeletePrintReqData reqData = (DeletePrintReqData)req.getReqData();
        try {
            log.info("Yly_Request ---> " + reqData.getDeviceID());
            String strRes = RequestMethod.getInstance().printerDeletePrinter(authParam.getAccessToken(), reqData.getDeviceID());
            YlyDeletePrintResModel resModel = (YlyDeletePrintResModel)JSON.parseObject((String)strRes, YlyDeletePrintResModel.class);
            log.info("Yly_Response ---> requestResult " + strRes);
            if (!resModel.getError().equals("0")) {
                if (resModel.getError().equals("8")) {
                    return ResponseCommon.fail((String)"20000", (String)resModel.getError_description());
                }
                return ResponseCommon.fail((String)"50000", (String)resModel.getError_description());
            }
            respData.setCode("1");
            respData.setMsg(resModel.getError_description());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }

    public ResponseCommon<SendModelPrintRespData> SendModelPrint(SendModelPrintReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        SendModelPrintRespData respData = new SendModelPrintRespData();
        YlyAuthParam authParam = YlyUtil.getAuthParam((RequestCommon)req);
        SendModelPrintReqData reqData = (SendModelPrintReqData)req.getReqData();
        try {
            log.info("Yly_Request ---> " + reqData.getDeviceID() + " Data:" + reqData.getTData());
            String strRes = RequestMethod.getInstance().printIndex(authParam.getAccessToken(), reqData.getDeviceID(), reqData.getTData(), reqData.getMsgNo());
            YlySendModelPrintResModel resModel = (YlySendModelPrintResModel)JSON.parseObject((String)strRes, YlySendModelPrintResModel.class);
            log.info("Yly_Response ---> requestResult " + strRes);
            ChannelprintrespmappingModel model = YlyUtil.getPlatformStatus(req.getChannelId(), String.valueOf(resModel.getError()), resModel.getError_description());
            respData.setCode(String.valueOf(model.getPlatformStatusCode()));
            respData.setMsg(model.getChannelStatusName());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }

    public ResponseCommon<SetSoundRespData> setSound(SetSoundReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        SetSoundRespData respData = new SetSoundRespData();
        YlyAuthParam authParam = YlyUtil.getAuthParam((RequestCommon)req);
        SetSoundReqData reqData = (SetSoundReqData)req.getReqData();
        try {
            log.info("Yly_Request ---> " + reqData.getDeviceID() + " soundType:" + reqData.getSoundType() + " voice: " + reqData.getVoice());
            String soundType = "";
            String voice = "";
            if (reqData.getSoundType() == 1) {
                soundType = "horn";
            } else if (reqData.getSoundType() == 2) {
                soundType = "buzzer";
            } else {
                log.error("\u4f20\u5165\u7684\u58f0\u97f3\u7c7b\u578b\u672a\u627e\u5230");
                return ResponseCommon.fail((String)"50000", (String)"\u4f20\u5165\u7684\u58f0\u97f3\u7c7b\u578b\u672a\u627e\u5230");
            }
            if (reqData.getVoice() == 0) {
                voice = "0";
            }
            if (reqData.getVoice() >= 1 && reqData.getVoice() <= 25) {
                voice = "1";
            }
            if (reqData.getVoice() >= 26 && reqData.getVoice() <= 50) {
                voice = "2";
            }
            if (reqData.getVoice() > 50) {
                voice = "3";
            }
            String strRes = RequestMethod.getInstance().printSetSound(authParam.getAccessToken(), reqData.getDeviceID(), soundType, voice);
            YlySendModelPrintResModel resModel = (YlySendModelPrintResModel)JSON.parseObject((String)strRes, YlySendModelPrintResModel.class);
            log.info("Yly_Response ---> requestResult " + strRes);
            ChannelprintrespmappingModel model = YlyUtil.getPlatformStatus(req.getChannelId(), String.valueOf(resModel.getError()), resModel.getError_description());
            respData.setCode(String.valueOf(model.getPlatformStatusCode()));
            respData.setMsg(model.getChannelStatusName());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }
}

