/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.dubbo.filter;

import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.core.rpc.TLogLabelBean;
import com.yomahub.tlog.core.rpc.TLogRPCHandler;
import com.yomahub.tlog.utils.LocalhostUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"}, order=-10000)
public class TLogDubboFilter
extends TLogRPCHandler
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TLogDubboFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        String side = invoker.getUrl().getParameter("side");
        if (side.equals("provider")) {
            Result result2;
            String preIvkApp = invocation.getAttachment("preIvkApp");
            String preIvkHost = invocation.getAttachment("preIvkHost");
            String preIp = invocation.getAttachment("preIp");
            String traceId = invocation.getAttachment("tlogTraceId");
            String spanId = invocation.getAttachment("tlogSpanId");
            TLogLabelBean labelBean = new TLogLabelBean(preIvkApp, preIvkHost, preIp, traceId, spanId);
            this.processProviderSide(labelBean);
            try {
                result2 = invoker.invoke(invocation);
            }
            finally {
                this.cleanThreadLocal();
            }
            return result2;
        }
        if (side.equals("consumer")) {
            String traceId = TLogContext.getTraceId();
            if (StringUtils.isNotBlank((CharSequence)traceId)) {
                String appName = invoker.getUrl().getParameter("application");
                RpcContext.getContext().setAttachment("tlogTraceId", traceId);
                RpcContext.getContext().setAttachment("preIvkApp", appName);
                RpcContext.getContext().setAttachment("preIvkHost", LocalhostUtil.getHostName());
                RpcContext.getContext().setAttachment("preIp", LocalhostUtil.getHostIp());
                RpcContext.getContext().setAttachment("tlogSpanId", SpanIdGenerator.generateNextSpanId());
            } else {
                log.warn("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
            }
            result = invoker.invoke(invocation);
        } else {
            result = null;
        }
        return result;
    }
}

