/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.web.wrapper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(RequestWrapper.class);
    private final byte[] body;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        String bodyStr = this.getBodyString((ServletRequest)request);
        this.body = bodyStr.getBytes(Charset.defaultCharset());
    }

    public String getBodyString(ServletRequest request) {
        try {
            return this.inputStream2String((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getBodyString() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return this.inputStream2String(inputStream);
    }

    private String inputStream2String(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return inputStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

