/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceDeregisteredEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceRegisteredEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class MicrosoftTeamsNotifier
extends AbstractStatusChangeNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrosoftTeamsNotifier.class);
    private static final String STATUS_KEY = "Status";
    private static final String SERVICE_URL_KEY = "Service URL";
    private static final String HEALTH_URL_KEY = "Health URL";
    private static final String MANAGEMENT_URL_KEY = "Management URL";
    private static final String SOURCE_KEY = "Source";
    private static final String DEFAULT_THEME_COLOR_EXPRESSION = "#{event.type == 'STATUS_CHANGED' ? (event.statusInfo.status=='UP' ? '6db33f' : 'b32d36') : '439fe0'}";
    private static final String DEFAULT_DEREGISTER_ACTIVITY_SUBTITLE_EXPRESSION = "#{instance.registration.name} with id #{instance.id} has de-registered from Spring Boot Admin";
    private static final String DEFAULT_REGISTER_ACTIVITY_SUBTITLE_EXPRESSION = "#{instance.registration.name} with id #{instance.id} has registered with Spring Boot Admin";
    private static final String DEFAULT_STATUS_ACTIVITY_SUBTITLE_EXPRESSION = "#{instance.registration.name} with id #{instance.id} changed status from #{lastStatus} to #{event.statusInfo.status}";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate;
    @Nullable
    private URI webhookUrl;
    private Expression themeColor;
    private Expression deregisterActivitySubtitle;
    private Expression registerActivitySubtitle;
    private Expression statusActivitySubtitle;
    private String deRegisteredTitle = "De-Registered";
    private String registeredTitle = "Registered";
    private String statusChangedTitle = "Status Changed";
    private String messageSummary = "Spring Boot Admin Notification";

    public MicrosoftTeamsNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
        this.themeColor = this.parser.parseExpression(DEFAULT_THEME_COLOR_EXPRESSION, ParserContext.TEMPLATE_EXPRESSION);
        this.deregisterActivitySubtitle = this.parser.parseExpression(DEFAULT_DEREGISTER_ACTIVITY_SUBTITLE_EXPRESSION, ParserContext.TEMPLATE_EXPRESSION);
        this.registerActivitySubtitle = this.parser.parseExpression(DEFAULT_REGISTER_ACTIVITY_SUBTITLE_EXPRESSION, ParserContext.TEMPLATE_EXPRESSION);
        this.statusActivitySubtitle = this.parser.parseExpression(DEFAULT_STATUS_ACTIVITY_SUBTITLE_EXPRESSION, ParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        Message message;
        EvaluationContext context = this.createEvaluationContext(event, instance);
        if (event instanceof InstanceRegisteredEvent) {
            message = this.getRegisteredMessage(instance, context);
        } else if (event instanceof InstanceDeregisteredEvent) {
            message = this.getDeregisteredMessage(instance, context);
        } else if (event instanceof InstanceStatusChangedEvent) {
            message = this.getStatusChangedMessage(instance, context);
        } else {
            return Mono.empty();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (this.webhookUrl == null) {
            return Mono.error((Throwable)new IllegalStateException("'webhookUrl' must not be null."));
        }
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.webhookUrl, (Object)new HttpEntity((Object)message, (MultiValueMap)headers), Void.class));
    }

    @Override
    protected boolean shouldNotify(InstanceEvent event, Instance instance) {
        return event instanceof InstanceRegisteredEvent || event instanceof InstanceDeregisteredEvent || super.shouldNotify(event, instance);
    }

    protected Message getDeregisteredMessage(Instance instance, EvaluationContext context) {
        String activitySubtitle = this.evaluateExpression(context, this.deregisterActivitySubtitle);
        return this.createMessage(instance, this.deRegisteredTitle, activitySubtitle, context);
    }

    protected Message getRegisteredMessage(Instance instance, EvaluationContext context) {
        String activitySubtitle = this.evaluateExpression(context, this.registerActivitySubtitle);
        return this.createMessage(instance, this.registeredTitle, activitySubtitle, context);
    }

    protected Message getStatusChangedMessage(Instance instance, EvaluationContext context) {
        String activitySubtitle = this.evaluateExpression(context, this.statusActivitySubtitle);
        return this.createMessage(instance, this.statusChangedTitle, activitySubtitle, context);
    }

    protected Message createMessage(Instance instance, String registeredTitle, String activitySubtitle, EvaluationContext context) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(new Fact(STATUS_KEY, instance.getStatusInfo().getStatus()));
        facts.add(new Fact(SERVICE_URL_KEY, instance.getRegistration().getServiceUrl()));
        facts.add(new Fact(HEALTH_URL_KEY, instance.getRegistration().getHealthUrl()));
        facts.add(new Fact(MANAGEMENT_URL_KEY, instance.getRegistration().getManagementUrl()));
        facts.add(new Fact(SOURCE_KEY, instance.getRegistration().getSource()));
        Section section = Section.builder().activityTitle(instance.getRegistration().getName()).activitySubtitle(activitySubtitle).facts(facts).build();
        return Message.builder().title(registeredTitle).summary(this.messageSummary).themeColor(this.evaluateExpression(context, this.themeColor)).sections(Collections.singletonList(section)).build();
    }

    protected String evaluateExpression(EvaluationContext context, Expression expression) {
        return (String)Objects.requireNonNull(expression.getValue(context, String.class));
    }

    protected EvaluationContext createEvaluationContext(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        return SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{DataBindingPropertyAccessor.forReadOnlyAccess(), new MapAccessor()}).withRootObject(root).build();
    }

    @Nullable
    public URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(@Nullable URI webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public String getThemeColor() {
        return this.themeColor.getExpressionString();
    }

    public void setThemeColor(String themeColor) {
        this.themeColor = this.parser.parseExpression(themeColor, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getDeregisterActivitySubtitle() {
        return this.deregisterActivitySubtitle.getExpressionString();
    }

    public void setDeregisterActivitySubtitle(String deregisterActivitySubtitle) {
        this.deregisterActivitySubtitle = this.parser.parseExpression(deregisterActivitySubtitle, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getRegisterActivitySubtitle() {
        return this.registerActivitySubtitle.getExpressionString();
    }

    public void setRegisterActivitySubtitle(String registerActivitySubtitle) {
        this.registerActivitySubtitle = this.parser.parseExpression(registerActivitySubtitle, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getStatusActivitySubtitle() {
        return this.statusActivitySubtitle.getExpressionString();
    }

    public void setStatusActivitySubtitle(String statusActivitySubtitle) {
        this.statusActivitySubtitle = this.parser.parseExpression(statusActivitySubtitle, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getDeRegisteredTitle() {
        return this.deRegisteredTitle;
    }

    public void setDeRegisteredTitle(String deRegisteredTitle) {
        this.deRegisteredTitle = deRegisteredTitle;
    }

    public String getRegisteredTitle() {
        return this.registeredTitle;
    }

    public void setRegisteredTitle(String registeredTitle) {
        this.registeredTitle = registeredTitle;
    }

    public String getStatusChangedTitle() {
        return this.statusChangedTitle;
    }

    public void setStatusChangedTitle(String statusChangedTitle) {
        this.statusChangedTitle = statusChangedTitle;
    }

    public String getMessageSummary() {
        return this.messageSummary;
    }

    public void setMessageSummary(String messageSummary) {
        this.messageSummary = messageSummary;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static class Fact {
        private final String name;
        @Nullable
        private final String value;

        public Fact(String name, @Nullable String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fact)) {
                return false;
            }
            Fact other = (Fact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Fact;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "MicrosoftTeamsNotifier.Fact(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }
    }

    public static class Section {
        private final String activityTitle;
        private final String activitySubtitle;
        private final List<Fact> facts;

        private static List<Fact> $default$facts() {
            return new ArrayList<Fact>();
        }

        Section(String activityTitle, String activitySubtitle, List<Fact> facts) {
            this.activityTitle = activityTitle;
            this.activitySubtitle = activitySubtitle;
            this.facts = facts;
        }

        public static SectionBuilder builder() {
            return new SectionBuilder();
        }

        public String getActivityTitle() {
            return this.activityTitle;
        }

        public String getActivitySubtitle() {
            return this.activitySubtitle;
        }

        public List<Fact> getFacts() {
            return this.facts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Section)) {
                return false;
            }
            Section other = (Section)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$activityTitle = this.getActivityTitle();
            String other$activityTitle = other.getActivityTitle();
            if (this$activityTitle == null ? other$activityTitle != null : !this$activityTitle.equals(other$activityTitle)) {
                return false;
            }
            String this$activitySubtitle = this.getActivitySubtitle();
            String other$activitySubtitle = other.getActivitySubtitle();
            if (this$activitySubtitle == null ? other$activitySubtitle != null : !this$activitySubtitle.equals(other$activitySubtitle)) {
                return false;
            }
            List<Fact> this$facts = this.getFacts();
            List<Fact> other$facts = other.getFacts();
            return !(this$facts == null ? other$facts != null : !((Object)this$facts).equals(other$facts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Section;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $activityTitle = this.getActivityTitle();
            result = result * 59 + ($activityTitle == null ? 43 : $activityTitle.hashCode());
            String $activitySubtitle = this.getActivitySubtitle();
            result = result * 59 + ($activitySubtitle == null ? 43 : $activitySubtitle.hashCode());
            List<Fact> $facts = this.getFacts();
            result = result * 59 + ($facts == null ? 43 : ((Object)$facts).hashCode());
            return result;
        }

        public String toString() {
            return "MicrosoftTeamsNotifier.Section(activityTitle=" + this.getActivityTitle() + ", activitySubtitle=" + this.getActivitySubtitle() + ", facts=" + this.getFacts() + ")";
        }

        public static class SectionBuilder {
            private String activityTitle;
            private String activitySubtitle;
            private boolean facts$set;
            private List<Fact> facts$value;

            SectionBuilder() {
            }

            public SectionBuilder activityTitle(String activityTitle) {
                this.activityTitle = activityTitle;
                return this;
            }

            public SectionBuilder activitySubtitle(String activitySubtitle) {
                this.activitySubtitle = activitySubtitle;
                return this;
            }

            public SectionBuilder facts(List<Fact> facts) {
                this.facts$value = facts;
                this.facts$set = true;
                return this;
            }

            public Section build() {
                List facts$value = this.facts$value;
                if (!this.facts$set) {
                    facts$value = Section.$default$facts();
                }
                return new Section(this.activityTitle, this.activitySubtitle, facts$value);
            }

            public String toString() {
                return "MicrosoftTeamsNotifier.Section.SectionBuilder(activityTitle=" + this.activityTitle + ", activitySubtitle=" + this.activitySubtitle + ", facts$value=" + this.facts$value + ")";
            }
        }
    }

    public static class Message {
        private final String summary;
        private final String themeColor;
        private final String title;
        private final List<Section> sections;

        private static List<Section> $default$sections() {
            return new ArrayList<Section>();
        }

        Message(String summary, String themeColor, String title, List<Section> sections) {
            this.summary = summary;
            this.themeColor = themeColor;
            this.title = title;
            this.sections = sections;
        }

        public static MessageBuilder builder() {
            return new MessageBuilder();
        }

        public String getSummary() {
            return this.summary;
        }

        public String getThemeColor() {
            return this.themeColor;
        }

        public String getTitle() {
            return this.title;
        }

        public List<Section> getSections() {
            return this.sections;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$summary = this.getSummary();
            String other$summary = other.getSummary();
            if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
                return false;
            }
            String this$themeColor = this.getThemeColor();
            String other$themeColor = other.getThemeColor();
            if (this$themeColor == null ? other$themeColor != null : !this$themeColor.equals(other$themeColor)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            List<Section> this$sections = this.getSections();
            List<Section> other$sections = other.getSections();
            return !(this$sections == null ? other$sections != null : !((Object)this$sections).equals(other$sections));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $summary = this.getSummary();
            result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
            String $themeColor = this.getThemeColor();
            result = result * 59 + ($themeColor == null ? 43 : $themeColor.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            List<Section> $sections = this.getSections();
            result = result * 59 + ($sections == null ? 43 : ((Object)$sections).hashCode());
            return result;
        }

        public String toString() {
            return "MicrosoftTeamsNotifier.Message(summary=" + this.getSummary() + ", themeColor=" + this.getThemeColor() + ", title=" + this.getTitle() + ", sections=" + this.getSections() + ")";
        }

        public static class MessageBuilder {
            private String summary;
            private String themeColor;
            private String title;
            private boolean sections$set;
            private List<Section> sections$value;

            MessageBuilder() {
            }

            public MessageBuilder summary(String summary) {
                this.summary = summary;
                return this;
            }

            public MessageBuilder themeColor(String themeColor) {
                this.themeColor = themeColor;
                return this;
            }

            public MessageBuilder title(String title) {
                this.title = title;
                return this;
            }

            public MessageBuilder sections(List<Section> sections) {
                this.sections$value = sections;
                this.sections$set = true;
                return this;
            }

            public Message build() {
                List sections$value = this.sections$value;
                if (!this.sections$set) {
                    sections$value = Message.$default$sections();
                }
                return new Message(this.summary, this.themeColor, this.title, sections$value);
            }

            public String toString() {
                return "MicrosoftTeamsNotifier.Message.MessageBuilder(summary=" + this.summary + ", themeColor=" + this.themeColor + ", title=" + this.title + ", sections$value=" + this.sections$value + ")";
            }
        }
    }
}

