/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class LetsChatNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_MESSAGE = "*#{instance.registration.name}* (#{instance.id}) is *#{event.statusInfo.status}*";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate;
    @Nullable
    private URI url;
    @Nullable
    private String room;
    @Nullable
    private String token;
    private String username = "Spring Boot Admin";
    private Expression message;

    public LetsChatNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
        this.message = this.parser.parseExpression(DEFAULT_MESSAGE, ParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String auth = Base64Utils.encodeToString((byte[])String.format("%s:%s", this.token, this.username).getBytes(StandardCharsets.UTF_8));
        headers.add("Authorization", String.format("Basic %s", auth));
        return Mono.fromRunnable(() -> this.restTemplate.exchange(this.createUrl(), HttpMethod.POST, new HttpEntity(this.createMessage(event, instance), (MultiValueMap)headers), Void.class));
    }

    private URI createUrl() {
        if (this.url == null) {
            throw new IllegalStateException("'url' must not be null.");
        }
        return URI.create(String.format("%s/rooms/%s/messages", this.url, this.room));
    }

    protected Object createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, String> messageJson = new HashMap<String, String>();
        messageJson.put("text", this.getText(event, instance));
        return messageJson;
    }

    @Nullable
    protected String getText(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        StandardEvaluationContext context = new StandardEvaluationContext(root);
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        return (String)this.message.getValue((EvaluationContext)context, String.class);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setUrl(@Nullable URI url) {
        this.url = url;
    }

    @Nullable
    public URI getUrl() {
        return this.url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setRoom(@Nullable String room) {
        this.room = room;
    }

    @Nullable
    public String getRoom() {
        return this.room;
    }

    public void setToken(@Nullable String token) {
        this.token = token;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public void setMessage(String message) {
        this.message = this.parser.parseExpression(message, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getMessage() {
        return this.message.getExpressionString();
    }
}

