/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class TelegramNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_MESSAGE = "<strong>#{instance.registration.name}</strong>/#{instance.id} is <strong>#{event.statusInfo.status}</strong>";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate;
    private String apiUrl = "https://api.telegram.org";
    @Nullable
    private String chatId;
    @Nullable
    private String authToken;
    private String parseMode = "HTML";
    private boolean disableNotify = false;
    private Expression message;

    public TelegramNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
        this.message = this.parser.parseExpression(DEFAULT_MESSAGE, ParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> this.restTemplate.getForObject(this.buildUrl(), Void.class, this.createMessage(event, instance)));
    }

    protected String buildUrl() {
        return String.format("%s/bot%s/sendmessage?chat_id={chat_id}&text={text}&parse_mode={parse_mode}&disable_notification={disable_notification}", this.apiUrl, this.authToken);
    }

    private Map<String, Object> createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("chat_id", this.chatId);
        parameters.put("parse_mode", this.parseMode);
        parameters.put("disable_notification", this.disableNotify);
        parameters.put("text", this.getText(event, instance));
        return parameters;
    }

    @Nullable
    protected String getText(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        StandardEvaluationContext context = new StandardEvaluationContext(root);
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        return (String)this.message.getValue((EvaluationContext)context, String.class);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    @Nullable
    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(@Nullable String chatId) {
        this.chatId = chatId;
    }

    @Nullable
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String authToken) {
        this.authToken = authToken;
    }

    public boolean isDisableNotify() {
        return this.disableNotify;
    }

    public void setDisableNotify(boolean disableNotify) {
        this.disableNotify = disableNotify;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setMessage(String message) {
        this.message = this.parser.parseExpression(message, ParserContext.TEMPLATE_EXPRESSION);
    }
}

