/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.core.Atomix;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.CloseProcess;
import io.camunda.zeebe.broker.bootstrap.StartProcess;
import io.camunda.zeebe.broker.clustering.ClusterServices;
import io.camunda.zeebe.broker.clustering.atomix.AtomixFactory;
import io.camunda.zeebe.broker.clustering.topology.TopologyManagerImpl;
import io.camunda.zeebe.broker.clustering.topology.TopologyPartitionListenerImpl;
import io.camunda.zeebe.broker.engine.impl.DeploymentDistributorImpl;
import io.camunda.zeebe.broker.engine.impl.LongPollingJobNotification;
import io.camunda.zeebe.broker.engine.impl.PartitionCommandSenderImpl;
import io.camunda.zeebe.broker.engine.impl.SubscriptionApiCommandMessageHandlerService;
import io.camunda.zeebe.broker.exporter.jar.ExporterJarLoadException;
import io.camunda.zeebe.broker.exporter.repo.ExporterLoadException;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.system.EmbeddedGatewayService;
import io.camunda.zeebe.broker.system.SystemContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import io.camunda.zeebe.broker.system.configuration.SocketBindingCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.BackpressureCfg;
import io.camunda.zeebe.broker.system.management.BrokerAdminService;
import io.camunda.zeebe.broker.system.management.BrokerAdminServiceImpl;
import io.camunda.zeebe.broker.system.management.LeaderManagementRequestHandler;
import io.camunda.zeebe.broker.system.management.deployment.PushDeploymentRequestHandler;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionHealthBroadcaster;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.broker.system.partitions.TypedRecordProcessorsFactory;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.broker.system.partitions.impl.AtomixPartitionMessagingService;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionProcessingState;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionTransitionImpl;
import io.camunda.zeebe.broker.system.partitions.impl.steps.AtomixLogStoragePartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.ExporterDirectorPartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.FollowerPostStoragePartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.LeaderPostStoragePartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.LogDeletionPartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.LogStreamPartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.RaftLogReaderPartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.RocksDbMetricExporterPartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.SnapshotDirectorPartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.SnapshotReplicationPartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.StateControllerPartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.StreamProcessorPartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.ZeebeDbPartitionStep;
import io.camunda.zeebe.broker.transport.backpressure.PartitionAwareRequestLimiter;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiService;
import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.deployment.DeploymentResponder;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributor;
import io.camunda.zeebe.engine.processing.message.command.PartitionCommandSender;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;
import io.camunda.zeebe.snapshots.SnapshotStoreSupplier;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStoreFactory;
import io.camunda.zeebe.transport.ServerTransport;
import io.camunda.zeebe.transport.TransportFactory;
import io.camunda.zeebe.util.LogUtil;
import io.camunda.zeebe.util.VersionUtil;
import io.camunda.zeebe.util.exception.UncheckedExecutionException;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class Broker
implements AutoCloseable {
    public static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private static final List<PartitionStep> LEADER_STEPS = List.of(new AtomixLogStoragePartitionStep(), new LogStreamPartitionStep(), new RaftLogReaderPartitionStep(), new SnapshotReplicationPartitionStep(), new StateControllerPartitionStep(), new LogDeletionPartitionStep(), new LeaderPostStoragePartitionStep(), new ZeebeDbPartitionStep(), new StreamProcessorPartitionStep(), new SnapshotDirectorPartitionStep(), new RocksDbMetricExporterPartitionStep(), new ExporterDirectorPartitionStep());
    private static final List<PartitionStep> FOLLOWER_STEPS = List.of(new RaftLogReaderPartitionStep(), new SnapshotReplicationPartitionStep(), new StateControllerPartitionStep(), new LogDeletionPartitionStep(), new FollowerPostStoragePartitionStep());
    private final SystemContext brokerContext;
    private final List<PartitionListener> partitionListeners;
    private boolean isClosed = false;
    private ClusterServices clusterServices;
    private CompletableFuture<Broker> startFuture;
    private TopologyManagerImpl topologyManager;
    private LeaderManagementRequestHandler managementRequestHandler;
    private CommandApiService commandHandler;
    private ActorScheduler scheduler;
    private CloseProcess closeProcess;
    private EmbeddedGatewayService embeddedGatewayService;
    private BrokerHealthCheckService healthCheckService;
    private final List<DiskSpaceUsageListener> diskSpaceUsageListeners = new ArrayList<DiskSpaceUsageListener>();
    private final SpringBrokerBridge springBrokerBridge;
    private DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private SnapshotStoreSupplier snapshotStoreSupplier;
    private final List<ZeebePartition> partitions = new ArrayList<ZeebePartition>();
    private BrokerAdminService brokerAdminService;
    private final TestCompanionClass testCompanionObject = new TestCompanionClass();

    public Broker(SystemContext systemContext, SpringBrokerBridge springBrokerBridge) {
        this.brokerContext = systemContext;
        this.partitionListeners = new ArrayList<PartitionListener>();
        this.springBrokerBridge = springBrokerBridge;
    }

    public Broker(BrokerCfg cfg, String basePath, ActorClock clock, SpringBrokerBridge springBrokerBridge) {
        this(new SystemContext(cfg, basePath, clock), springBrokerBridge);
    }

    public void addPartitionListener(PartitionListener listener) {
        this.partitionListeners.add(listener);
    }

    public synchronized CompletableFuture<Broker> start() {
        if (this.startFuture == null) {
            this.logBrokerStart();
            this.startFuture = new CompletableFuture();
            LogUtil.doWithMDC(this.brokerContext.getDiagnosticContext(), this::internalStart);
        }
        return this.startFuture;
    }

    private void logBrokerStart() {
        if (LOG.isInfoEnabled()) {
            BrokerCfg brokerCfg = this.getConfig();
            LOG.info("Version: {}", (Object)VersionUtil.getVersion());
            LOG.info("Starting broker {} with configuration {}", (Object)brokerCfg.getCluster().getNodeId(), (Object)brokerCfg.toJson());
        }
    }

    private void internalStart() {
        StartProcess startProcess = this.initStart();
        try {
            this.closeProcess = startProcess.start();
            this.startFuture.complete(this);
            this.healthCheckService.setBrokerStarted();
        }
        catch (Exception bootStrapException) {
            BrokerCfg brokerCfg = this.getConfig();
            LOG.error("Failed to start broker {}!", (Object)brokerCfg.getCluster().getNodeId(), (Object)bootStrapException);
            UncheckedExecutionException exception = new UncheckedExecutionException("Failed to start broker", (Throwable)bootStrapException);
            this.startFuture.completeExceptionally((Throwable)exception);
            throw exception;
        }
    }

    private StartProcess initStart() {
        BrokerCfg brokerCfg = this.getConfig();
        NetworkCfg networkCfg = brokerCfg.getNetwork();
        ClusterCfg clusterCfg = brokerCfg.getCluster();
        BrokerInfo localBroker = new BrokerInfo(clusterCfg.getNodeId(), NetUtil.toSocketAddressString((InetSocketAddress)networkCfg.getCommandApi().getAdvertisedAddress()));
        StartProcess startContext = new StartProcess("Broker-" + localBroker.getNodeId());
        startContext.addStep("actor scheduler", this::actorSchedulerStep);
        startContext.addStep("membership and replication protocol", () -> this.atomixCreateStep(brokerCfg, localBroker));
        startContext.addStep("command api transport and handler", () -> this.commandApiTransportAndHandlerStep(brokerCfg, localBroker));
        startContext.addStep("subscription api", () -> this.subscriptionAPIStep(localBroker));
        startContext.addStep("cluster services", () -> this.clusterServices.start().join());
        startContext.addStep("topology manager", () -> this.topologyManagerStep(clusterCfg, localBroker));
        if (brokerCfg.getGateway().isEnable()) {
            startContext.addStep("embedded gateway", () -> {
                this.embeddedGatewayService = new EmbeddedGatewayService(brokerCfg, this.scheduler, this.clusterServices.getMessagingService(), this.clusterServices.getMembershipService(), this.clusterServices.getEventService());
                return this.embeddedGatewayService;
            });
        }
        startContext.addStep("monitoring services", () -> this.monitoringServerStep(localBroker));
        startContext.addStep("disk space monitor", () -> this.diskSpaceMonitorStep(brokerCfg.getData()));
        startContext.addStep("leader management request handler", () -> this.managementRequestStep(localBroker));
        startContext.addStep("zeebe partitions", () -> this.partitionsStep(brokerCfg, localBroker));
        startContext.addStep("register diskspace usage listeners", this::addDiskSpaceUsageListeners);
        startContext.addStep("upgrade manager", this::addBrokerAdminService);
        return startContext;
    }

    private AutoCloseable addBrokerAdminService() {
        BrokerAdminServiceImpl adminService = new BrokerAdminServiceImpl(this.partitions);
        this.scheduleActor(adminService);
        this.brokerAdminService = adminService;
        this.springBrokerBridge.registerBrokerAdminServiceSupplier(() -> this.brokerAdminService);
        return adminService;
    }

    private AutoCloseable actorSchedulerStep() {
        this.scheduler = this.brokerContext.getScheduler();
        this.scheduler.start();
        return () -> this.scheduler.stop().get(this.brokerContext.getStepTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }

    private AutoCloseable atomixCreateStep(BrokerCfg brokerCfg, BrokerInfo localBroker) {
        Atomix atomix;
        FileBasedSnapshotStoreFactory snapshotStoreFactory = new FileBasedSnapshotStoreFactory(this.scheduler, localBroker.getNodeId());
        this.snapshotStoreSupplier = snapshotStoreFactory;
        this.testCompanionObject.atomix = atomix = AtomixFactory.fromConfiguration(brokerCfg, (ReceivableSnapshotStoreFactory)snapshotStoreFactory);
        this.clusterServices = new ClusterServices(atomix);
        return () -> this.clusterServices.stop().get(this.brokerContext.getStepTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }

    private AutoCloseable commandApiTransportAndHandlerStep(BrokerCfg brokerCfg, BrokerInfo localBroker) {
        ManagedMessagingService messagingService = this.createMessagingService(brokerCfg.getCluster(), brokerCfg.getNetwork().getCommandApi());
        messagingService.start().join();
        LOG.debug("Bound command API to {}, using advertised address {} ", (Object)messagingService.bindingAddresses(), (Object)messagingService.address());
        TransportFactory transportFactory = new TransportFactory(this.scheduler);
        ServerTransport serverTransport = transportFactory.createServerTransport(localBroker.getNodeId(), (MessagingService)messagingService);
        BackpressureCfg backpressureCfg = brokerCfg.getBackpressure();
        PartitionAwareRequestLimiter limiter = PartitionAwareRequestLimiter.newNoopLimiter();
        if (backpressureCfg.isEnabled()) {
            limiter = PartitionAwareRequestLimiter.newLimiter(backpressureCfg);
        }
        this.commandHandler = new CommandApiService(serverTransport, localBroker, limiter);
        this.partitionListeners.add(this.commandHandler);
        this.scheduleActor(this.commandHandler);
        this.diskSpaceUsageListeners.add(this.commandHandler);
        return () -> {
            this.commandHandler.close();
            serverTransport.close();
            messagingService.stop().join();
        };
    }

    private ManagedMessagingService createMessagingService(ClusterCfg clusterCfg, SocketBindingCfg socketCfg) {
        MessagingConfig messagingConfig = new MessagingConfig();
        messagingConfig.setInterfaces(List.of(socketCfg.getHost()));
        messagingConfig.setPort(Integer.valueOf(socketCfg.getPort()));
        return new NettyMessagingService(clusterCfg.getClusterName(), Address.from((String)socketCfg.getAdvertisedHost(), (int)socketCfg.getAdvertisedPort()), messagingConfig);
    }

    private AutoCloseable subscriptionAPIStep(BrokerInfo localBroker) {
        SubscriptionApiCommandMessageHandlerService messageHandlerService = new SubscriptionApiCommandMessageHandlerService(localBroker, this.clusterServices.getCommunicationService());
        this.partitionListeners.add(messageHandlerService);
        this.scheduleActor(messageHandlerService);
        this.diskSpaceUsageListeners.add(messageHandlerService);
        return messageHandlerService;
    }

    private void addDiskSpaceUsageListeners() {
        this.diskSpaceUsageListeners.forEach(this.diskSpaceUsageMonitor::addDiskUsageListener);
    }

    private void scheduleActor(Actor actor) {
        this.brokerContext.getScheduler().submitActor(actor).join(this.brokerContext.getStepTimeout().toSeconds(), TimeUnit.SECONDS);
    }

    private AutoCloseable topologyManagerStep(ClusterCfg clusterCfg, BrokerInfo localBroker) {
        this.topologyManager = new TopologyManagerImpl(this.clusterServices.getMembershipService(), localBroker, clusterCfg);
        this.partitionListeners.add(this.topologyManager);
        this.scheduleActor(this.topologyManager);
        return this.topologyManager;
    }

    private AutoCloseable monitoringServerStep(BrokerInfo localBroker) {
        this.healthCheckService = new BrokerHealthCheckService(localBroker, (PartitionGroup)this.clusterServices.getPartitionGroup());
        this.springBrokerBridge.registerBrokerHealthCheckServiceSupplier(() -> this.healthCheckService);
        this.partitionListeners.add(this.healthCheckService);
        this.scheduleActor(this.healthCheckService);
        return () -> this.healthCheckService.close();
    }

    private AutoCloseable diskSpaceMonitorStep(DataCfg data) {
        this.diskSpaceUsageMonitor = new DiskSpaceUsageMonitor(data);
        if (data.isDiskUsageMonitoringEnabled()) {
            this.scheduleActor(this.diskSpaceUsageMonitor);
            this.diskSpaceUsageListeners.forEach(l -> this.diskSpaceUsageMonitor.addDiskUsageListener((DiskSpaceUsageListener)l));
            return () -> this.diskSpaceUsageMonitor.close();
        }
        LOG.info("Skipping start of disk space usage monitor, as it is disabled by configuration");
        return () -> {};
    }

    private AutoCloseable managementRequestStep(BrokerInfo localBroker) {
        this.managementRequestHandler = new LeaderManagementRequestHandler(localBroker, this.clusterServices.getCommunicationService(), this.clusterServices.getEventService());
        this.scheduleActor(this.managementRequestHandler);
        this.partitionListeners.add(this.managementRequestHandler);
        this.diskSpaceUsageListeners.add(this.managementRequestHandler);
        return this.managementRequestHandler;
    }

    private AutoCloseable partitionsStep(BrokerCfg brokerCfg, BrokerInfo localBroker) throws Exception {
        ManagedPartitionGroup partitionGroup = this.clusterServices.getPartitionGroup();
        MemberId nodeId = this.clusterServices.getMembershipService().getLocalMember().id();
        List owningPartitions = partitionGroup.getPartitionsWithMember(nodeId).stream().map(RaftPartition.class::cast).collect(Collectors.toList());
        StartProcess partitionStartProcess = new StartProcess("Broker-" + nodeId + " partitions");
        for (RaftPartition owningPartition : owningPartitions) {
            Integer partitionId = (Integer)owningPartition.id().id();
            partitionStartProcess.addStep("partition " + partitionId, () -> {
                AtomixPartitionMessagingService messagingService = new AtomixPartitionMessagingService(this.clusterServices.getCommunicationService(), this.clusterServices.getMembershipService(), owningPartition.members());
                PartitionContext context = new PartitionContext(localBroker.getNodeId(), owningPartition, this.partitionListeners, messagingService, this.scheduler, brokerCfg, this.commandHandler, this.snapshotStoreSupplier, this.createFactory(this.topologyManager, brokerCfg.getCluster(), this.clusterServices.getCommunicationService(), this.clusterServices.getEventService(), this.managementRequestHandler), this.buildExporterRepository(brokerCfg), new PartitionProcessingState(owningPartition));
                PartitionTransitionImpl transitionBehavior = new PartitionTransitionImpl(context, LEADER_STEPS, FOLLOWER_STEPS);
                ZeebePartition zeebePartition = new ZeebePartition(context, transitionBehavior);
                this.scheduleActor(zeebePartition);
                zeebePartition.addFailureListener(new PartitionHealthBroadcaster(partitionId, this.topologyManager::onHealthChanged));
                this.healthCheckService.registerMonitoredPartition((Integer)owningPartition.id().id(), zeebePartition);
                this.diskSpaceUsageListeners.add(zeebePartition);
                this.partitions.add(zeebePartition);
                return () -> {
                    this.healthCheckService.removeMonitoredPartition(partitionId);
                    zeebePartition.close();
                };
            });
        }
        return partitionStartProcess.start();
    }

    private ExporterRepository buildExporterRepository(BrokerCfg cfg) {
        ExporterRepository exporterRepository = new ExporterRepository();
        Set<Map.Entry<String, ExporterCfg>> exporterEntries = cfg.getExporters().entrySet();
        for (Map.Entry<String, ExporterCfg> exporterEntry : exporterEntries) {
            String id = exporterEntry.getKey();
            ExporterCfg exporterCfg = exporterEntry.getValue();
            try {
                exporterRepository.load(id, exporterCfg);
            }
            catch (ExporterJarLoadException | ExporterLoadException e) {
                throw new IllegalStateException("Failed to load exporter with configuration: " + exporterCfg, e);
            }
        }
        return exporterRepository;
    }

    private TypedRecordProcessorsFactory createFactory(TopologyManagerImpl topologyManager, ClusterCfg clusterCfg, ClusterCommunicationService communicationService, ClusterEventService eventService, LeaderManagementRequestHandler requestHandler) {
        return (actor, zeebeState, processingContext) -> {
            LogStream stream = processingContext.getLogStream();
            TopologyPartitionListenerImpl partitionListener = new TopologyPartitionListenerImpl(actor);
            topologyManager.addTopologyPartitionListener(partitionListener);
            DeploymentDistributorImpl deploymentDistributor = new DeploymentDistributorImpl(communicationService, eventService, partitionListener, actor);
            PartitionCommandSenderImpl partitionCommandSender = new PartitionCommandSenderImpl(communicationService, topologyManager, actor);
            SubscriptionCommandSender subscriptionCommandSender = new SubscriptionCommandSender(stream.getPartitionId(), (PartitionCommandSender)partitionCommandSender);
            PushDeploymentRequestHandler deploymentRequestHandler = requestHandler.getPushDeploymentRequestHandler();
            LongPollingJobNotification jobsAvailableNotification = new LongPollingJobNotification(this.clusterServices.getEventService());
            return EngineProcessors.createEngineProcessors((ProcessingContext)processingContext, (int)clusterCfg.getPartitionsCount(), (SubscriptionCommandSender)subscriptionCommandSender, (DeploymentDistributor)deploymentDistributor, (DeploymentResponder)deploymentRequestHandler, jobsAvailableNotification::onJobsAvailable);
        };
    }

    public BrokerCfg getConfig() {
        return this.brokerContext.getBrokerConfiguration();
    }

    @Override
    public void close() {
        LogUtil.doWithMDC(this.brokerContext.getDiagnosticContext(), () -> {
            if (!this.isClosed && this.startFuture != null) {
                ((CompletableFuture)this.startFuture.thenAccept(b -> {
                    this.closeProcess.closeReverse();
                    this.isClosed = true;
                    LOG.info("Broker shut down.");
                })).join();
            }
        });
    }

    public EmbeddedGatewayService getEmbeddedGatewayService() {
        return this.embeddedGatewayService;
    }

    @Deprecated
    public Atomix getAtomix() {
        return this.testCompanionObject.atomix;
    }

    public ClusterServices getClusterServices() {
        return this.clusterServices;
    }

    public DiskSpaceUsageMonitor getDiskSpaceUsageMonitor() {
        return this.diskSpaceUsageMonitor;
    }

    public BrokerAdminService getBrokerAdminService() {
        return this.brokerAdminService;
    }

    public SystemContext getBrokerContext() {
        return this.brokerContext;
    }

    @Deprecated
    private static final class TestCompanionClass {
        private Atomix atomix;

        private TestCompanionClass() {
        }
    }
}

