/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.clustering.atomix;

import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryBuilder;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.SwimMembershipProtocol;
import io.atomix.core.Atomix;
import io.atomix.core.AtomixBuilder;
import io.atomix.core.AtomixConfig;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.configuration.ExperimentalCfg;
import io.camunda.zeebe.broker.system.configuration.MembershipCfg;
import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import io.camunda.zeebe.logstreams.impl.log.ZeebeEntryValidator;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.agrona.IoUtil;
import org.slf4j.Logger;

public final class AtomixFactory {
    public static final String GROUP_NAME = "raft-partition";
    private static final Logger LOG = Loggers.CLUSTERING_LOGGER;

    private AtomixFactory() {
    }

    public static Atomix fromConfiguration(BrokerCfg configuration, ReceivableSnapshotStoreFactory snapshotStoreFactory) {
        ClusterCfg clusterCfg = configuration.getCluster();
        int nodeId = clusterCfg.getNodeId();
        String localMemberId = Integer.toString(nodeId);
        NetworkCfg networkCfg = configuration.getNetwork();
        NodeDiscoveryProvider discoveryProvider = AtomixFactory.createDiscoveryProvider(clusterCfg, localMemberId);
        MembershipCfg membershipCfg = clusterCfg.getMembership();
        GroupMembershipProtocol membershipProtocol = SwimMembershipProtocol.builder().withFailureTimeout(membershipCfg.getFailureTimeout()).withGossipInterval(membershipCfg.getGossipInterval()).withProbeInterval(membershipCfg.getProbeInterval()).withProbeTimeout(membershipCfg.getProbeTimeout()).withBroadcastDisputes(membershipCfg.isBroadcastDisputes()).withBroadcastUpdates(membershipCfg.isBroadcastUpdates()).withGossipFanout(membershipCfg.getGossipFanout()).withNotifySuspect(membershipCfg.isNotifySuspect()).withSuspectProbes(membershipCfg.getSuspectProbes()).withSyncInterval(membershipCfg.getSyncInterval()).build();
        AtomixBuilder atomixBuilder = Atomix.builder((AtomixConfig)new AtomixConfig()).withClusterId(clusterCfg.getClusterName()).withMemberId(localMemberId).withMembershipProtocol(membershipProtocol).withMessagingInterface(networkCfg.getInternalApi().getHost()).withMessagingPort(networkCfg.getInternalApi().getPort()).withAddress(Address.from((String)networkCfg.getInternalApi().getAdvertisedHost(), (int)networkCfg.getInternalApi().getAdvertisedPort())).withMembershipProvider(discoveryProvider);
        DataCfg dataConfiguration = configuration.getData();
        String rootDirectory = dataConfiguration.getDirectory();
        IoUtil.ensureDirectoryExists((File)new File(rootDirectory), (String)"Zeebe data directory");
        RaftPartitionGroup partitionGroup = AtomixFactory.createRaftPartitionGroup(configuration, rootDirectory, snapshotStoreFactory);
        return atomixBuilder.withPartitionGroup((ManagedPartitionGroup)partitionGroup).build();
    }

    private static RaftPartitionGroup createRaftPartitionGroup(BrokerCfg configuration, String rootDirectory, ReceivableSnapshotStoreFactory snapshotStoreFactory) {
        File raftDirectory = new File(rootDirectory, GROUP_NAME);
        IoUtil.ensureDirectoryExists((File)raftDirectory, (String)"Raft data directory");
        ClusterCfg clusterCfg = configuration.getCluster();
        ExperimentalCfg experimentalCfg = configuration.getExperimental();
        DataCfg dataCfg = configuration.getData();
        NetworkCfg networkCfg = configuration.getNetwork();
        RaftPartitionGroup.Builder partitionGroupBuilder = RaftPartitionGroup.builder((String)GROUP_NAME).withNumPartitions(clusterCfg.getPartitionsCount()).withPartitionSize(clusterCfg.getReplicationFactor()).withMembers(AtomixFactory.getRaftGroupMembers(clusterCfg)).withDataDirectory(raftDirectory).withSnapshotStoreFactory(snapshotStoreFactory).withMaxAppendBatchSize((int)experimentalCfg.getMaxAppendBatchSizeInBytes()).withMaxAppendsPerFollower(experimentalCfg.getMaxAppendsPerFollower()).withHeartbeatInterval(clusterCfg.getHeartbeatInterval()).withElectionTimeout(clusterCfg.getElectionTimeout()).withEntryValidator((EntryValidator)new ZeebeEntryValidator()).withFlushExplicitly(!experimentalCfg.isDisableExplicitRaftFlush()).withFreeDiskSpace(dataCfg.getFreeDiskSpaceReplicationWatermark()).withJournalIndexDensity(dataCfg.getLogIndexDensity()).withPriorityElection(experimentalCfg.isEnablePriorityElection()).withRequestTimeout(experimentalCfg.getRaft().getRequestTimeout());
        int maxMessageSize = (int)networkCfg.getMaxMessageSizeInBytes();
        long segmentSize = dataCfg.getLogSegmentSizeInBytes();
        if (segmentSize < (long)maxMessageSize) {
            throw new IllegalArgumentException(String.format("Expected the raft segment size greater than the max message size of %s, but was %s.", maxMessageSize, segmentSize));
        }
        partitionGroupBuilder.withSegmentSize(segmentSize);
        return partitionGroupBuilder.build();
    }

    private static List<String> getRaftGroupMembers(ClusterCfg clusterCfg) {
        int clusterSize = clusterCfg.getClusterSize();
        ArrayList<String> members = new ArrayList<String>();
        for (int i = 0; i < clusterSize; ++i) {
            members.add(Integer.toString(i));
        }
        return members;
    }

    private static NodeDiscoveryProvider createDiscoveryProvider(ClusterCfg clusterCfg, String localMemberId) {
        BootstrapDiscoveryBuilder builder = BootstrapDiscoveryProvider.builder();
        List<String> initialContactPoints = clusterCfg.getInitialContactPoints();
        ArrayList nodes = new ArrayList();
        initialContactPoints.forEach(contactAddress -> {
            Node node = Node.builder().withAddress(Address.from((String)contactAddress)).build();
            LOG.debug("Member {} will contact node: {}", (Object)localMemberId, (Object)node.address());
            nodes.add(node);
        });
        return builder.withNodes(nodes).build();
    }
}

