/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.jar;

import io.camunda.zeebe.broker.exporter.jar.ExporterJarLoadException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExporterJarClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExporterJarClassLoader.class);
    private static final String JAVA_PACKAGE_PREFIX = "java.";
    private static final String JAR_URL_FORMAT = "jar:%s!/";

    private ExporterJarClassLoader(URL[] urls) {
        super(urls);
    }

    static ExporterJarClassLoader ofPath(Path jarPath) throws ExporterJarLoadException {
        URL jarUrl;
        try {
            String expandedPath = jarPath.toUri().toURL().toString();
            jarUrl = new URL(String.format(JAR_URL_FORMAT, expandedPath));
        }
        catch (MalformedURLException e) {
            throw new ExporterJarLoadException(jarPath, "bad JAR url", e);
        }
        return new ExporterJarClassLoader(new URL[]{jarUrl});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            if (name.startsWith(JAVA_PACKAGE_PREFIX)) {
                return this.findSystemClass(name);
            }
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.trace("Failed to load class {}, falling back to parent class loader", (Object)name, (Object)ex);
                    clazz = super.loadClass(name);
                }
            }
            return clazz;
        }
    }
}

