/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.metrics;

import io.prometheus.client.Histogram;

public class ExecutionLatencyMetrics {
    private static final Histogram PROCESS_INSTANCE_EXECUTION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("process_instance_execution_time")).help("The execution time of processing a complete process instance")).labelNames(new String[]{"partition"})).register();
    private static final Histogram JOB_LIFE_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("job_life_time")).help("The life time of an job")).labelNames(new String[]{"partition"})).register();
    private static final Histogram JOB_ACTIVATION_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("job_activation_time")).help("The time until an job was activated")).labelNames(new String[]{"partition"})).register();

    public void observeProcessInstanceExecutionTime(int partitionId, long creationTimeMs, long completionTimeMs) {
        ((Histogram.Child)PROCESS_INSTANCE_EXECUTION.labels(new String[]{Integer.toString(partitionId)})).observe(ExecutionLatencyMetrics.latencyInSeconds(creationTimeMs, completionTimeMs));
    }

    public void observeJobLifeTime(int partitionId, long creationTimeMs, long completionTimeMs) {
        ((Histogram.Child)JOB_LIFE_TIME.labels(new String[]{Integer.toString(partitionId)})).observe(ExecutionLatencyMetrics.latencyInSeconds(creationTimeMs, completionTimeMs));
    }

    public void observeJobActivationTime(int partitionId, long creationTimeMs, long activationTimeMs) {
        ((Histogram.Child)JOB_ACTIVATION_TIME.labels(new String[]{Integer.toString(partitionId)})).observe(ExecutionLatencyMetrics.latencyInSeconds(creationTimeMs, activationTimeMs));
    }

    private static double latencyInSeconds(long startTimeMs, long endTimeMs) {
        return (float)(endTimeMs - startTimeMs) / 1000.0f;
    }
}

