/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.MessagingService;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.gateway.Gateway;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.util.sched.ActorScheduler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;

public final class EmbeddedGatewayService
implements AutoCloseable {
    private final Gateway gateway;

    public EmbeddedGatewayService(BrokerCfg configuration, ActorScheduler actorScheduler, MessagingService messagingService, ClusterMembershipService membershipService, ClusterEventService eventService) {
        Function<GatewayCfg, BrokerClient> brokerClientFactory = cfg -> new BrokerClientImpl(cfg, messagingService, membershipService, eventService, actorScheduler, false);
        this.gateway = new Gateway((GatewayCfg)configuration.getGateway(), brokerClientFactory, actorScheduler);
        this.startGateway();
    }

    @Override
    public void close() {
        if (this.gateway != null) {
            this.gateway.stop();
        }
    }

    public Gateway get() {
        return this.gateway;
    }

    private void startGateway() {
        try {
            this.gateway.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Gateway was not able to start", e);
        }
    }
}

