/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.RaftCfg;
import io.camunda.zeebe.broker.system.configuration.RocksdbCfg;
import java.util.Optional;
import org.springframework.util.unit.DataSize;

public class ExperimentalCfg
implements ConfigurationEntry {
    public static final int DEFAULT_MAX_APPENDS_PER_FOLLOWER = 2;
    public static final DataSize DEFAULT_MAX_APPEND_BATCH_SIZE = DataSize.ofKilobytes((long)32L);
    public static final boolean DEFAULT_DISABLE_EXPLICIT_RAFT_FLUSH = false;
    public static final boolean DEFAULT_ENABLE_PRIORITY_ELECTION = false;
    private int maxAppendsPerFollower = 2;
    private DataSize maxAppendBatchSize = DEFAULT_MAX_APPEND_BATCH_SIZE;
    private boolean disableExplicitRaftFlush = false;
    private boolean enablePriorityElection = false;
    private RocksdbCfg rocksdb = new RocksdbCfg();
    private RaftCfg raft = new RaftCfg();

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.rocksdb.init(globalConfig, brokerBase);
        this.raft.init(globalConfig, brokerBase);
    }

    public int getMaxAppendsPerFollower() {
        return this.maxAppendsPerFollower;
    }

    public void setMaxAppendsPerFollower(int maxAppendsPerFollower) {
        this.maxAppendsPerFollower = maxAppendsPerFollower;
    }

    public DataSize getMaxAppendBatchSize() {
        return this.maxAppendBatchSize;
    }

    public void setMaxAppendBatchSize(DataSize maxAppendBatchSize) {
        this.maxAppendBatchSize = maxAppendBatchSize;
    }

    public long getMaxAppendBatchSizeInBytes() {
        return Optional.ofNullable(this.maxAppendBatchSize).orElse(DEFAULT_MAX_APPEND_BATCH_SIZE).toBytes();
    }

    public boolean isDisableExplicitRaftFlush() {
        return this.disableExplicitRaftFlush;
    }

    public void setDisableExplicitRaftFlush(boolean disableExplicitRaftFlush) {
        this.disableExplicitRaftFlush = disableExplicitRaftFlush;
    }

    public RocksdbCfg getRocksdb() {
        return this.rocksdb;
    }

    public void setRocksdb(RocksdbCfg rocksdb) {
        this.rocksdb = rocksdb;
    }

    public boolean isEnablePriorityElection() {
        return this.enablePriorityElection;
    }

    public void setEnablePriorityElection(boolean enablePriorityElection) {
        this.enablePriorityElection = enablePriorityElection;
    }

    public String toString() {
        return "ExperimentalCfg{maxAppendsPerFollower=" + this.maxAppendsPerFollower + ", maxAppendBatchSize=" + this.maxAppendBatchSize + ", disableExplicitRaftFlush=" + this.disableExplicitRaftFlush + ", rocksdb=" + this.rocksdb + "}";
    }

    public RaftCfg getRaft() {
        return this.raft;
    }

    public void setRaft(RaftCfg raft) {
        this.raft = raft;
    }
}

