/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.ConfigurationUtil;
import java.util.Map;
import java.util.Objects;

public final class ExporterCfg
implements ConfigurationEntry {
    private String jarPath;
    private String className;
    private Map<String, Object> args;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        if (this.isExternal()) {
            this.jarPath = ConfigurationUtil.toAbsolutePath(this.jarPath, brokerBase);
        }
    }

    public boolean isExternal() {
        return !this.isEmpty(this.jarPath);
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public void setArgs(Map<String, Object> args) {
        this.args = args;
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public String toString() {
        return "ExporterCfg{, jarPath='" + this.jarPath + "', className='" + this.className + "', args=" + this.args + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExporterCfg that = (ExporterCfg)o;
        return Objects.equals(this.jarPath, that.jarPath) && Objects.equals(this.className, that.className) && Objects.equals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(this.jarPath, this.className, this.args);
    }
}

