/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.backpressure;

import com.google.common.base.Preconditions;
import io.camunda.zeebe.broker.system.configuration.ConfigurationUtil;

public class GradientCfg {
    private int minLimit = 10;
    private int initialLimit = 20;
    private double rttTolerance = 2.0;

    public int getMinLimit() {
        return this.minLimit;
    }

    public void setMinLimit(int minLimit) {
        ConfigurationUtil.checkPositive(minLimit, "minLimit");
        this.minLimit = minLimit;
    }

    public int getInitialLimit() {
        return this.initialLimit;
    }

    public void setInitialLimit(int initialLimit) {
        ConfigurationUtil.checkPositive(initialLimit, "initialLimit");
        this.initialLimit = initialLimit;
    }

    public double getRttTolerance() {
        return this.rttTolerance;
    }

    public void setRttTolerance(double rttTolerance) {
        Preconditions.checkArgument((rttTolerance >= 1.0 ? 1 : 0) != 0, (String)"Expected rttTolerance to be >= 1.0, but found %s", (Object)rttTolerance);
        this.rttTolerance = rttTolerance;
    }

    public String toString() {
        return "GradientCfg{minLimit=" + this.minLimit + ", initialLimit=" + this.initialLimit + ", rttTolerance=" + this.rttTolerance + "}";
    }
}

