/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.management.deployment;

import io.camunda.zeebe.clustering.management.PushDeploymentRequestDecoder;
import io.camunda.zeebe.clustering.management.PushDeploymentRequestEncoder;
import io.camunda.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class PushDeploymentRequest
extends SbeBufferWriterReader<PushDeploymentRequestEncoder, PushDeploymentRequestDecoder> {
    private final PushDeploymentRequestEncoder bodyEncoder = new PushDeploymentRequestEncoder();
    private final PushDeploymentRequestDecoder bodyDecoder = new PushDeploymentRequestDecoder();
    private final DirectBuffer deployment = new UnsafeBuffer(0L, 0);
    private int partitionId = PushDeploymentRequestEncoder.partitionIdNullValue();
    private long deploymentKey = PushDeploymentRequestEncoder.deploymentKeyNullValue();

    public PushDeploymentRequest partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public PushDeploymentRequest deploymentKey(long deploymentKey) {
        this.deploymentKey = deploymentKey;
        return this;
    }

    public long deploymentKey() {
        return this.deploymentKey;
    }

    public PushDeploymentRequest deployment(DirectBuffer directBuffer) {
        this.deployment.wrap(directBuffer);
        return this;
    }

    public DirectBuffer deployment() {
        return this.deployment;
    }

    protected PushDeploymentRequestEncoder getBodyEncoder() {
        return this.bodyEncoder;
    }

    protected PushDeploymentRequestDecoder getBodyDecoder() {
        return this.bodyDecoder;
    }

    public void reset() {
        super.reset();
        this.partitionId = PushDeploymentRequestEncoder.partitionIdNullValue();
        this.deploymentKey = PushDeploymentRequestEncoder.deploymentKeyNullValue();
        this.deployment.wrap(0L, 0);
    }

    public int getLength() {
        return super.getLength() + PushDeploymentRequestEncoder.deploymentHeaderLength() + this.deployment.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.bodyEncoder.partitionId(this.partitionId).deploymentKey(this.deploymentKey).putDeployment(this.deployment, 0, this.deployment.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.partitionId = this.bodyDecoder.partitionId();
        this.deploymentKey = this.bodyDecoder.deploymentKey();
        this.deployment.wrap(buffer, this.bodyDecoder.limit() + PushDeploymentRequestDecoder.deploymentHeaderLength(), this.bodyDecoder.deploymentLength());
    }
}

