/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.monitoring;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionGroup;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.util.health.CriticalComponentsHealthMonitor;
import io.camunda.zeebe.util.health.HealthMonitor;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthStatus;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class BrokerHealthCheckService
extends Actor
implements PartitionListener {
    private static final String PARTITION_COMPONENT_NAME_FORMAT = "Partition-%d";
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final String actorName;
    private Map<Integer, Boolean> partitionInstallStatus;
    private volatile boolean allPartitionsInstalled = false;
    private volatile boolean brokerStarted = false;
    private final HealthMonitor healthMonitor;
    private final MemberId nodeId;
    private final PartitionGroup partitionGroup;

    public BrokerHealthCheckService(BrokerInfo localBroker, PartitionGroup partitionGroup) {
        this.partitionGroup = partitionGroup;
        this.actorName = BrokerHealthCheckService.buildActorName((int)localBroker.getNodeId(), (String)"HealthCheckService");
        this.nodeId = MemberId.from((String)String.valueOf(localBroker.getNodeId()));
        this.healthMonitor = new CriticalComponentsHealthMonitor(this.actor, LOG);
        this.initializePartitionInstallStatus();
        this.initializePartitionHealthStatus();
    }

    private void initializePartitionHealthStatus() {
        this.partitionGroup.getPartitionsWithMember(this.nodeId).stream().map(partition -> (Integer)partition.id().id()).forEach(partitionId -> this.healthMonitor.monitorComponent(String.format(PARTITION_COMPONENT_NAME_FORMAT, partitionId)));
    }

    boolean isBrokerReady() {
        return this.brokerStarted && this.allPartitionsInstalled;
    }

    @Override
    public ActorFuture<Void> onBecomingFollower(int partitionId, long term) {
        return this.updateBrokerReadyStatus(partitionId);
    }

    @Override
    public ActorFuture<Void> onBecomingLeader(int partitionId, long term, LogStream logStream) {
        return this.updateBrokerReadyStatus(partitionId);
    }

    @Override
    public ActorFuture<Void> onBecomingInactive(int partitionId, long term) {
        return CompletableActorFuture.completed(null);
    }

    private ActorFuture<Void> updateBrokerReadyStatus(int partitionId) {
        return this.actor.call(() -> {
            if (!this.allPartitionsInstalled) {
                this.partitionInstallStatus.put(partitionId, true);
                boolean bl = this.allPartitionsInstalled = !this.partitionInstallStatus.containsValue(false);
                if (this.allPartitionsInstalled) {
                    LOG.debug("All partitions are installed. Broker is ready!");
                }
            }
        });
    }

    private void initializePartitionInstallStatus() {
        this.partitionInstallStatus = this.partitionGroup.getPartitions().stream().filter(partition -> partition.members().contains(this.nodeId)).map(partition -> (Integer)partition.id().id()).collect(Collectors.toMap(Function.identity(), p -> false));
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarted() {
        this.healthMonitor.startMonitoring();
    }

    private void registerComponent(String componentName, HealthMonitorable component) {
        this.actor.run(() -> this.healthMonitor.registerComponent(componentName, component));
    }

    public void registerMonitoredPartition(int partitionId, HealthMonitorable partition) {
        String componentName = String.format(PARTITION_COMPONENT_NAME_FORMAT, partitionId);
        this.registerComponent(componentName, partition);
    }

    public void removeMonitoredPartition(int partitionId) {
        String componentName = String.format(PARTITION_COMPONENT_NAME_FORMAT, partitionId);
        this.removeComponent(componentName);
    }

    private void removeComponent(String componentName) {
        this.actor.run(() -> this.healthMonitor.removeComponent(componentName));
    }

    public boolean isBrokerHealthy() {
        return !this.actor.isClosed() && this.getBrokerHealth() == HealthStatus.HEALTHY;
    }

    private HealthStatus getBrokerHealth() {
        if (!this.isBrokerReady()) {
            return HealthStatus.UNHEALTHY;
        }
        return this.healthMonitor.getHealthStatus();
    }

    public void setBrokerStarted() {
        this.actor.run(() -> {
            this.brokerStarted = true;
        });
    }

    public boolean isBrokerStarted() {
        return this.brokerStarted;
    }
}

