/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.storage.log.RaftLogReader;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.logstreams.LogDeletionService;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.partitions.PartitionMessagingService;
import io.camunda.zeebe.broker.system.partitions.SnapshotReplication;
import io.camunda.zeebe.broker.system.partitions.TypedRecordProcessorsFactory;
import io.camunda.zeebe.broker.system.partitions.impl.AsyncSnapshotDirector;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionProcessingState;
import io.camunda.zeebe.broker.system.partitions.impl.StateControllerImpl;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiService;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixLogStorage;
import io.camunda.zeebe.snapshots.SnapshotStoreSupplier;
import io.camunda.zeebe.util.health.HealthMonitor;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class PartitionContext {
    private final int nodeId;
    private final List<PartitionListener> partitionListeners;
    private final PartitionMessagingService messagingService;
    private final ActorScheduler scheduler;
    private final BrokerCfg brokerCfg;
    private final SnapshotStoreSupplier snapshotStoreSupplier;
    private final RaftPartition raftPartition;
    private final TypedRecordProcessorsFactory typedRecordProcessorsFactory;
    private final CommandApiService commandApiService;
    private final Integer partitionId;
    private final int maxFragmentSize;
    private final ExporterRepository exporterRepository;
    private final PartitionProcessingState partitionProcessingState;
    private StreamProcessor streamProcessor;
    private LogStream logStream;
    private AtomixLogStorage atomixLogStorage;
    private long deferredCommitPosition;
    private RaftLogReader raftLogReader;
    private SnapshotReplication snapshotReplication;
    private StateControllerImpl stateController;
    private LogDeletionService logDeletionService;
    private AsyncSnapshotDirector snapshotDirector;
    private HealthMonitor criticalComponentsHealthMonitor;
    private ZeebeDb zeebeDb;
    private ActorControl actor;
    private ScheduledTimer metricsTimer;
    private ExporterDirector exporterDirector;
    private long currentTerm;
    private RaftServer.Role currentRole;

    public PartitionContext(int nodeId, RaftPartition raftPartition, List<PartitionListener> partitionListeners, PartitionMessagingService messagingService, ActorScheduler actorScheduler, BrokerCfg brokerCfg, CommandApiService commandApiService, SnapshotStoreSupplier snapshotStoreSupplier, TypedRecordProcessorsFactory typedRecordProcessorsFactory, ExporterRepository exporterRepository, PartitionProcessingState partitionProcessingState) {
        this.nodeId = nodeId;
        this.raftPartition = raftPartition;
        this.messagingService = messagingService;
        this.brokerCfg = brokerCfg;
        this.snapshotStoreSupplier = snapshotStoreSupplier;
        this.typedRecordProcessorsFactory = typedRecordProcessorsFactory;
        this.commandApiService = commandApiService;
        this.partitionListeners = Collections.unmodifiableList(partitionListeners);
        this.partitionId = (Integer)raftPartition.id().id();
        this.scheduler = actorScheduler;
        this.maxFragmentSize = (int)brokerCfg.getNetwork().getMaxMessageSizeInBytes();
        this.exporterRepository = exporterRepository;
        this.partitionProcessingState = partitionProcessingState;
    }

    public ExporterDirector getExporterDirector() {
        return this.exporterDirector;
    }

    public void setExporterDirector(ExporterDirector exporterDirector) {
        this.exporterDirector = exporterDirector;
    }

    public ScheduledTimer getMetricsTimer() {
        return this.metricsTimer;
    }

    public void setMetricsTimer(ScheduledTimer metricsTimer) {
        this.metricsTimer = metricsTimer;
    }

    public ActorControl getActor() {
        return this.actor;
    }

    public void setActor(ActorControl actor) {
        this.actor = actor;
    }

    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    public void setZeebeDb(ZeebeDb zeebeDb) {
        this.zeebeDb = zeebeDb;
    }

    public HealthMonitor getComponentHealthMonitor() {
        return this.criticalComponentsHealthMonitor;
    }

    public void setComponentHealthMonitor(HealthMonitor criticalComponentsHealthMonitor) {
        this.criticalComponentsHealthMonitor = criticalComponentsHealthMonitor;
    }

    public AsyncSnapshotDirector getSnapshotDirector() {
        return this.snapshotDirector;
    }

    public void setSnapshotDirector(AsyncSnapshotDirector snapshotDirector) {
        this.snapshotDirector = snapshotDirector;
    }

    public LogDeletionService getLogDeletionService() {
        return this.logDeletionService;
    }

    public void setLogDeletionService(LogDeletionService logDeletionService) {
        this.logDeletionService = logDeletionService;
    }

    public StateControllerImpl getSnapshotController() {
        return this.stateController;
    }

    public void setSnapshotController(StateControllerImpl controller) {
        this.stateController = controller;
    }

    public SnapshotReplication getSnapshotReplication() {
        return this.snapshotReplication;
    }

    public void setSnapshotReplication(SnapshotReplication snapshotReplication) {
        this.snapshotReplication = snapshotReplication;
    }

    public RaftLogReader getRaftLogReader() {
        return this.raftLogReader;
    }

    public void setRaftLogReader(RaftLogReader raftLogReader) {
        this.raftLogReader = raftLogReader;
    }

    public long getDeferredCommitPosition() {
        return this.deferredCommitPosition;
    }

    public void setDeferredCommitPosition(long deferredCommitPosition) {
        this.deferredCommitPosition = deferredCommitPosition;
    }

    public AtomixLogStorage getAtomixLogStorage() {
        return this.atomixLogStorage;
    }

    public void setAtomixLogStorage(AtomixLogStorage atomixLogStorage) {
        this.atomixLogStorage = atomixLogStorage;
    }

    public StreamProcessor getStreamProcessor() {
        return this.streamProcessor;
    }

    public void setStreamProcessor(StreamProcessor streamProcessor) {
        this.streamProcessor = streamProcessor;
    }

    public LogStream getLogStream() {
        return this.logStream;
    }

    public void setLogStream(LogStream logStream) {
        this.logStream = logStream;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public List<PartitionListener> getPartitionListeners() {
        return this.partitionListeners;
    }

    public PartitionMessagingService getMessagingService() {
        return this.messagingService;
    }

    public ActorScheduler getScheduler() {
        return this.scheduler;
    }

    public BrokerCfg getBrokerCfg() {
        return this.brokerCfg;
    }

    public SnapshotStoreSupplier getSnapshotStoreSupplier() {
        return this.snapshotStoreSupplier;
    }

    public RaftPartition getRaftPartition() {
        return this.raftPartition;
    }

    public TypedRecordProcessorsFactory getTypedRecordProcessorsFactory() {
        return this.typedRecordProcessorsFactory;
    }

    public CommandApiService getCommandApiService() {
        return this.commandApiService;
    }

    public int getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    public ExporterRepository getExporterRepository() {
        return this.exporterRepository;
    }

    public void setDiskSpaceAvailable(boolean diskSpaceAvailable) {
        this.partitionProcessingState.setDiskSpaceAvailable(diskSpaceAvailable);
    }

    public boolean shouldProcess() {
        return this.partitionProcessingState.shouldProcess();
    }

    public boolean shouldExport() {
        return !this.partitionProcessingState.isExportingPaused();
    }

    public void pauseProcessing() throws IOException {
        this.partitionProcessingState.pauseProcessing();
    }

    public void resumeProcessing() throws IOException {
        this.partitionProcessingState.resumeProcessing();
    }

    public boolean pauseExporting() throws IOException {
        return this.partitionProcessingState.pauseExporting();
    }

    public boolean resumeExporting() throws IOException {
        return this.partitionProcessingState.resumeExporting();
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public void setCurrentTerm(long currentTerm) {
        this.currentTerm = currentTerm;
    }

    public RaftServer.Role getCurrentRole() {
        return this.currentRole;
    }

    public void setCurrentRole(RaftServer.Role currentRole) {
        this.currentRole = currentRole;
    }
}

