/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixLogStorage;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.util.Optional;

public class AtomixLogStoragePartitionStep
implements PartitionStep {
    private static final String WRONG_TERM_ERROR_MSG = "Expected that current term '%d' is same as raft term '%d', but was not. Failing installation of 'AtomixLogStoragePartitionStep' on partition %d.";

    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        CompletableActorFuture openFuture = new CompletableActorFuture();
        RaftPartitionServer server = context.getRaftPartition().getServer();
        Optional appenderOptional = server.getAppender();
        appenderOptional.ifPresentOrElse(logAppender -> {
            long raftTerm = server.getTerm();
            if (raftTerm != context.getCurrentTerm()) {
                openFuture.completeExceptionally((Throwable)new IllegalStateException(String.format(WRONG_TERM_ERROR_MSG, context.getCurrentTerm(), raftTerm, context.getPartitionId())));
            } else {
                context.setAtomixLogStorage(AtomixLogStorage.ofPartition(arg_0 -> ((RaftPartitionServer)server).openReader(arg_0), (ZeebeLogAppender)logAppender));
                openFuture.complete(null);
            }
        }, () -> openFuture.completeExceptionally((Throwable)new IllegalStateException("Not leader of partition " + context.getPartitionId())));
        return openFuture;
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        context.setAtomixLogStorage(null);
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "AtomixLogStorage";
    }
}

