/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirectorContext;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.Collection;

public class ExporterDirectorPartitionStep
implements PartitionStep {
    private static final int EXPORTER_PROCESSOR_ID = 1003;

    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        Collection<ExporterDescriptor> exporterDescriptors = context.getExporterRepository().getExporters().values();
        ExporterDirectorContext exporterCtx = new ExporterDirectorContext().id(1003).name(Actor.buildActorName((int)context.getNodeId(), (String)"Exporter", (int)context.getPartitionId())).logStream(context.getLogStream()).zeebeDb(context.getZeebeDb()).descriptors(exporterDescriptors);
        ExporterDirector director = new ExporterDirector(exporterCtx, !context.shouldExport());
        context.setExporterDirector(director);
        context.getComponentHealthMonitor().registerComponent(director.getName(), (HealthMonitorable)director);
        ActorFuture<Void> startFuture = director.startAsync(context.getScheduler());
        startFuture.onComplete((nothing, error) -> {
            if (error == null) {
                if (!context.shouldExport()) {
                    director.pauseExporting();
                } else {
                    director.resumeExporting();
                }
            }
        });
        return startFuture;
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        ExporterDirector director = context.getExporterDirector();
        context.getComponentHealthMonitor().removeComponent(director.getName());
        ActorFuture future = director.closeAsync();
        context.setExporterDirector(null);
        return future;
    }

    @Override
    public String getName() {
        return "ExporterDirector";
    }
}

