/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.logstreams.AtomixLogCompactor;
import io.camunda.zeebe.broker.logstreams.LogDeletionService;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.future.ActorFuture;

public class LogDeletionPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        AtomixLogCompactor logCompactor = new AtomixLogCompactor(context.getRaftPartition().getServer());
        LogDeletionService deletionService = new LogDeletionService(context.getNodeId(), context.getPartitionId(), logCompactor, context.getSnapshotStoreSupplier().getPersistedSnapshotStore(((Integer)context.getRaftPartition().id().id()).intValue()));
        context.setLogDeletionService(deletionService);
        return context.getScheduler().submitActor((Actor)deletionService);
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        ActorFuture future = context.getLogDeletionService().closeAsync();
        context.setLogDeletionService(null);
        return future;
    }

    @Override
    public String getName() {
        return "LogDeletionService";
    }
}

