/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;

public class LogStreamPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        CompletableActorFuture openFuture = new CompletableActorFuture();
        this.buildLogstream(context).onComplete((logStream, err) -> {
            if (err == null) {
                context.setLogStream((LogStream)logStream);
                if (context.getDeferredCommitPosition() > 0L) {
                    context.getLogStream().setCommitPosition(context.getDeferredCommitPosition());
                    context.setDeferredCommitPosition(-1L);
                }
                context.getComponentHealthMonitor().registerComponent(logStream.getLogName(), (HealthMonitorable)logStream);
                openFuture.complete(null);
            } else {
                openFuture.completeExceptionally(err);
            }
        });
        return openFuture;
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        context.getComponentHealthMonitor().removeComponent(context.getLogStream().getLogName());
        ActorFuture future = context.getLogStream().closeAsync();
        context.setLogStream(null);
        return future;
    }

    @Override
    public String getName() {
        return "logstream";
    }

    private ActorFuture<LogStream> buildLogstream(PartitionContext context) {
        return LogStream.builder().withLogStorage((LogStorage)context.getAtomixLogStorage()).withLogName("logstream-" + context.getRaftPartition().name()).withNodeId(context.getNodeId()).withPartitionId(((Integer)context.getRaftPartition().id().id()).intValue()).withMaxFragmentSize(context.getMaxFragmentSize()).withActorScheduler(context.getScheduler()).buildAsync();
    }
}

