/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.storage.log.RaftLogReader;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;

public class RaftLogReaderPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        RaftLogReader reader = context.getRaftPartition().getServer().openReader(RaftLogReader.Mode.COMMITS);
        context.setRaftLogReader(reader);
        return CompletableActorFuture.completed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        try {
            context.getRaftLogReader().close();
        }
        catch (Exception e) {
            Loggers.SYSTEM_LOGGER.error("Unexpected error closing Raft log reader for partition {}", (Object)context.getPartitionId(), (Object)e);
            CompletableActorFuture completableActorFuture = CompletableActorFuture.completedExceptionally((Throwable)e);
            return completableActorFuture;
        }
        finally {
            context.setRaftLogReader(null);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "RaftLogReader";
    }
}

