/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.db.impl.rocksdb.ZeebeRocksDBMetricExporter;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;

public class RocksDbMetricExporterPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        ZeebeRocksDBMetricExporter metricExporter = (ZeebeRocksDBMetricExporter)DefaultZeebeDbFactory.DEFAULT_DB_METRIC_EXPORTER_FACTORY.apply(Integer.toString(context.getPartitionId()), context.getZeebeDb());
        ScheduledTimer metricsTimer = context.getActor().runAtFixedRate(Duration.ofSeconds(5L), () -> {
            if (context.getZeebeDb() != null) {
                metricExporter.exportMetrics();
            }
        });
        context.setMetricsTimer(metricsTimer);
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        context.getMetricsTimer().cancel();
        context.setMetricsTimer(null);
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "RocksDB metric timer";
    }
}

