/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.AsyncSnapshotDirector;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.time.Duration;

public class SnapshotDirectorPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        Duration snapshotPeriod = context.getBrokerCfg().getData().getSnapshotPeriod();
        AsyncSnapshotDirector director = new AsyncSnapshotDirector(context.getNodeId(), context.getStreamProcessor(), context.getSnapshotController(), context.getLogStream(), snapshotPeriod);
        context.setSnapshotDirector(director);
        context.getComponentHealthMonitor().registerComponent(director.getName(), (HealthMonitorable)director);
        return context.getScheduler().submitActor((Actor)director);
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        AsyncSnapshotDirector director = context.getSnapshotDirector();
        context.getComponentHealthMonitor().removeComponent(director.getName());
        ActorFuture<Void> future = director.closeAsync();
        context.setSnapshotDirector(null);
        return future;
    }

    @Override
    public String getName() {
        return "AsyncSnapshotDirector";
    }
}

