/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.broker.system.partitions.SnapshotReplication;
import io.camunda.zeebe.broker.system.partitions.impl.NoneSnapshotReplication;
import io.camunda.zeebe.broker.system.partitions.impl.StateReplication;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;

public class SnapshotReplicationPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        SnapshotReplication replication = this.shouldReplicateSnapshots(context) ? new StateReplication(context.getMessagingService(), context.getPartitionId(), context.getNodeId()) : new NoneSnapshotReplication();
        context.setSnapshotReplication(replication);
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        try {
            if (context.getSnapshotReplication() != null) {
                context.getSnapshotReplication().close();
            }
        }
        catch (Exception e) {
            Loggers.SYSTEM_LOGGER.error("Unexpected error closing state replication for partition {}", (Object)context.getPartitionId(), (Object)e);
        }
        finally {
            context.setSnapshotReplication(null);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "SnapshotReplication";
    }

    private boolean shouldReplicateSnapshots(PartitionContext state) {
        return state.getBrokerCfg().getCluster().getReplicationFactor() > 1;
    }
}

