/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.logstreams.state.StatePositionSupplier;
import io.camunda.zeebe.broker.system.configuration.RocksdbCfg;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.AtomixRecordEntrySupplierImpl;
import io.camunda.zeebe.broker.system.partitions.impl.StateControllerImpl;
import io.camunda.zeebe.db.impl.rocksdb.RocksDbConfiguration;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.nio.file.Path;

public class StateControllerPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        Path runtimeDirectory = context.getRaftPartition().dataDirectory().toPath().resolve("runtime");
        RocksdbCfg databaseCfg = context.getBrokerCfg().getExperimental().getRocksdb();
        StateControllerImpl stateController = new StateControllerImpl(context.getPartitionId(), DefaultZeebeDbFactory.defaultFactory((RocksDbConfiguration)databaseCfg.createRocksDbConfiguration()), context.getSnapshotStoreSupplier().getConstructableSnapshotStore(context.getPartitionId()), context.getSnapshotStoreSupplier().getReceivableSnapshotStore(context.getPartitionId()), runtimeDirectory, context.getSnapshotReplication(), new AtomixRecordEntrySupplierImpl(context.getRaftLogReader()), StatePositionSupplier::getHighestExportedPosition);
        context.setSnapshotController(stateController);
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        try {
            context.getSnapshotController().close();
        }
        catch (Exception e) {
            Loggers.SYSTEM_LOGGER.error("Unexpected error occurred while closing the state snapshot controller for partition {}.", (Object)context.getPartitionId(), (Object)e);
        }
        finally {
            context.setSnapshotController(null);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "StateController";
    }
}

