/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.message.MessageCorrelator;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class MessageSubscriptionCorrelateProcessor
implements TypedRecordProcessor<MessageSubscriptionRecord> {
    private static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to correlate subscription for element with key '%d' and message name '%s', but no such message subscription exists";
    private final MessageSubscriptionState subscriptionState;
    private final MessageCorrelator messageCorrelator;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;

    public MessageSubscriptionCorrelateProcessor(MessageState messageState, MessageSubscriptionState subscriptionState, SubscriptionCommandSender commandSender, Writers writers) {
        this.subscriptionState = subscriptionState;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.messageCorrelator = new MessageCorrelator(messageState, commandSender, this.stateWriter);
    }

    @Override
    public void processRecord(TypedRecord<MessageSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        MessageSubscriptionRecord command = record.getValue();
        MessageSubscription subscription = this.subscriptionState.get(command.getElementInstanceKey(), command.getMessageNameBuffer());
        if (subscription == null) {
            this.rejectCommand(record);
            return;
        }
        MessageSubscriptionRecord messageSubscription = subscription.getRecord();
        this.stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)MessageSubscriptionIntent.CORRELATED, (RecordValue)messageSubscription);
        if (!messageSubscription.isInterrupting()) {
            this.messageCorrelator.correlateNextMessage(subscription.getKey(), messageSubscription, sideEffect);
        }
    }

    private void rejectCommand(TypedRecord<MessageSubscriptionRecord> record) {
        MessageSubscriptionRecord subscription = record.getValue();
        String reason = String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, subscription.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)subscription.getMessageNameBuffer()));
        this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, reason);
    }
}

